/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.ConditionalIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.IdpTokenProcessorMapping;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.validator.IdpWsTrustTokenMappingValidator;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidator;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.page.ValidatePage;
import com.pingidentity.pf.admin.rest.translator.SpWsTrustTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.WsTrustRequestContract;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class StsRequestContractsToConnectionDepErrorValidatorImpl
extends ValidatePage
implements DependencyErrorValidator {
    private static final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
    private AdministrativeUser currentUser;

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        Collection spConnections = connectionManager.getAllSpConnections();
        WsTrustRequestContract instance = (WsTrustRequestContract)causedByItem;
        for (org.sourceid.saml20.domain.SpConnection spConnection : spConnections) {
            if (spConnection.getWsTrustSettings() == null || !StringUtils.isNotEmpty((String)spConnection.getWsTrustSettings().getRequestContractId()) || !spConnection.getWsTrustSettings().getRequestContractId().equals(instance.getId()) || spConnection.getWsTrustSettings().getTokenToAssertionMappings() == null) continue;
            SpWsTrustTranslator wsTrustTranslator = new SpWsTrustTranslator();
            SpConnection apiConn = new SpConnection();
            wsTrustTranslator.domainToApi(spConnection, apiConn);
            int index = 0;
            for (IdpTokenProcessorMapping apiMapping : apiConn.getWsTrust().getTokenProcessorMappings()) {
                IdpWsTrustTokenMappingValidator validator;
                for (AttributeFulfillmentValue attributeFulfillment : apiMapping.getAttributeContractFulfillment().values()) {
                    if (attributeFulfillment.getSource().getType() != SourceType.REQUEST) continue;
                    validator = new IdpWsTrustTokenMappingValidator(apiMapping, index, apiConn.getWsTrust(), new ValidatorContext(true, this.currentUser == null ? false : this.currentUser.isExpressionAdmin(), true));
                    this.updateDependencyErrors(existingErrors, instance, spConnection.getId(), validator);
                }
                for (ConditionalIssuanceCriteriaEntry issuanceCriteria : apiMapping.getIssuanceCriteria().getConditionalCriteria()) {
                    if (issuanceCriteria.getSource().getType() != SourceType.REQUEST) continue;
                    validator = new IdpWsTrustTokenMappingValidator(apiMapping, index, apiConn.getWsTrust(), new ValidatorContext(true, this.currentUser == null ? false : this.currentUser.isExpressionAdmin(), true));
                    this.updateDependencyErrors(existingErrors, instance, spConnection.getId(), validator);
                }
                ++index;
            }
        }
    }

    private void updateDependencyErrors(Collection<DependencyError> existingErrors, WsTrustRequestContract instance, String connectionId, IdpWsTrustTokenMappingValidator validator) {
        DependencyError error = new DependencyError(connectionId, DependencyType.STS, instance.getId(), AffectedItemType.SP_CONN);
        if (validator.validate()) {
            existingErrors.removeIf(dependencyError -> dependencyError.equals((Object)error));
        } else if (!existingErrors.contains(error)) {
            existingErrors.add(error);
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return true;
    }

    @Override
    public void setCurrentUser(AdministrativeUser currentUser) {
        this.currentUser = currentUser;
    }
}

