/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.admin.api.validator.oauth.exchange.ProcessorMappingTokenTypeValidator;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.pf.admin.rest.translator.oauth.exchange.TokenExchangeProcessorPolicyTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

public class TeppToTokenProcessorValidatorImpl
extends DependencyErrorValidatorImpl {
    private static final TokenProcessorManager tokenProcessorMgr = MgmtFactory.getTokenProcessorManager();
    private static final TokenExchangeProcessorPolicyManager policyManager = MgmtFactory.getTokenExchangeProcessorPolicyManager();
    private final TokenExchangeProcessorPolicyTranslator policyTranslator = new TokenExchangeProcessorPolicyTranslator();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        if (causedByItem instanceof TokenProcessorInstance) {
            TokenProcessorInstance processorInstance = (TokenProcessorInstance)causedByItem;
            if (policyManager.getTokenExchangeProcessorPolicies() != null && policyManager.getTokenExchangeProcessorPolicies().getPolicies() != null) {
                for (TokenExchangeProcessorPolicy policy : policyManager.getTokenExchangeProcessorPolicies().getPolicies().values()) {
                    com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorPolicy apiPolicy = (com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorPolicy)this.policyTranslator.toApi().apply(policy);
                    for (TokenExchangeProcessorMapping mapping : policy.getTokenExchangeProcessorMappings().values()) {
                        if (!processorInstance.getId().equals(mapping.getSubjectTokenProcessorId()) && !processorInstance.getId().equals(mapping.getActorTokenProcessorId())) continue;
                        com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorMapping apiMapping = this.policyTranslator.getApiTokenExchangeProcessorMapping(mapping);
                        ValidatorContext context = new ValidatorContext(true, this.isEaAdmin(), true);
                        ProcessorMappingTokenTypeValidator validator = new ProcessorMappingTokenTypeValidator(context, tokenProcessorMgr, apiMapping, apiPolicy, 0);
                        boolean isValid = validator.validate();
                        DependencyError error = new DependencyError(policy.getId(), DependencyType.TOKEN_PROCESSOR, processorInstance.getId(), AffectedItemType.TEPP);
                        this.updateErrors(existingErrors, isValid, error);
                    }
                }
            }
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return false;
    }
}

