/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.admin.api.model.AttributeMapping;
import com.pingidentity.admin.api.model.oauth.exchange.ProcessorPolicyToGeneratorMapping;
import com.pingidentity.admin.api.validator.oauth.exchange.ProcessorPolicyToGeneratorAttributeMappingValidator;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.dependency.error.validator.impl.AttrMappingDependencyUtil;
import com.pingidentity.fsm.state.impl.OAuthMetadataUtil;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.pf.admin.rest.translator.oauth.exchange.ProcessorPolicyToGeneratorMappingTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.exchange.domain.ProcessorPolicy2GeneratorMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.exchange.manager.ProcessorPolicy2TokenGeneratorManager;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.OAuthSourceId;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.TokenGeneratorInstance;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;

public class TokenGeneratorMappingToTeppDepErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    private static final ProcessorPolicy2TokenGeneratorManager teppToTGManager = MgmtFactory.getProcessorPolicy2TokenGeneratorManager();
    private static final TokenExchangeProcessorPolicyManager teppManager = MgmtFactory.getTokenExchangeProcessorPolicyManager();
    private static final ProcessorPolicyToGeneratorMappingTranslator translator = new ProcessorPolicyToGeneratorMappingTranslator();
    private static final TokenGeneratorManager tokenGeneratorManager = MgmtFactory.getTokenGeneratorManager();
    private static final ContextUtil cxtUtil = new ContextUtil();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        if (causedByItem instanceof TokenExchangeProcessorPolicy) {
            this.teppAttributeValidation(causedByItem, existingErrors);
        } else if (causedByItem instanceof TokenGeneratorInstance) {
            this.tokenGeneratorAttributeValidation(causedByItem, existingErrors);
        } else if (causedByItem instanceof ClientSetting) {
            this.tokenGeneratorAttributeMappingValidation(causedByItem, existingErrors);
        }
    }

    private void tokenGeneratorAttributeValidation(Object causedByItem, Collection<DependencyError> existingErrors) {
        TokenGeneratorInstance tokenGenerator = (TokenGeneratorInstance)causedByItem;
        List mappings = teppToTGManager.getMappingsUsingTarget(tokenGenerator.getId());
        if (mappings != null) {
            for (ProcessorPolicy2GeneratorMapping mapping : mappings) {
                TokenExchangeProcessorPolicy tepp = teppManager.getTokenExchangeProcessorPolicies().getPolicy(mapping.getSourceId());
                boolean valid = this.isValidMapping(tepp, mapping, tokenGenerator);
                OAuthSourceId teppId = new OAuthSourceId(OAuthSourceId.Type.TOKEN_EXCHANGE_PROCESSOR_POLICY, mapping.getTargetId());
                String tempMappingId = cxtUtil.buildQualifiedId(mapping.getSourceId(), teppId);
                DependencyError error = new DependencyError(tempMappingId, DependencyType.TOKEN_GENERATOR, tokenGenerator.getId(), AffectedItemType.TEPP_TO_TG_MAPPING);
                this.updateErrors(existingErrors, valid, error);
            }
        }
    }

    private void tokenGeneratorAttributeMappingValidation(Object causedByItem, Collection<DependencyError> existingErrors) {
        if (!(causedByItem instanceof ClientSetting)) {
            return;
        }
        ClientSetting clientSetting = (ClientSetting)causedByItem;
        Set<String> extendedProps = OAuthMetadataUtil.getExtendedClientMetadataParamsWithPrefix(clientSetting);
        AttrMappingDependencyUtil.clearDependencyErrorForAffectedType(existingErrors, AffectedItemType.TEPP_TO_TG_MAPPING, DependencyType.OAUTH_CLIENT_SETTINGS);
        Collection mappings = teppToTGManager.getMappings();
        if (mappings != null) {
            for (ProcessorPolicy2GeneratorMapping mapping : mappings) {
                OAuthSourceId teppId = new OAuthSourceId(OAuthSourceId.Type.TOKEN_EXCHANGE_PROCESSOR_POLICY, mapping.getTargetId());
                String tempMappingId = cxtUtil.buildQualifiedId(mapping.getSourceId(), teppId);
                if (AttrMappingDependencyUtil.checkDependencyErrorForContractFulfillment(existingErrors, extendedProps, mapping.getAttributeMapping(), AffectedItemType.TEPP_TO_TG_MAPPING, tempMappingId)) {
                    return;
                }
                if (!AttrMappingDependencyUtil.checkDependencyErrorForIssuanceCriteria(existingErrors, extendedProps, mapping.getTokenAuthorizationIssuanceCriteria(), AffectedItemType.TEPP_TO_TG_MAPPING, tempMappingId)) continue;
                return;
            }
        }
    }

    private void teppAttributeValidation(Object causedByItem, Collection<DependencyError> existingErrors) {
        TokenExchangeProcessorPolicy tepp = (TokenExchangeProcessorPolicy)causedByItem;
        List mappings = teppToTGManager.getMappingsMappedToSource(tepp.getId());
        if (mappings != null) {
            for (ProcessorPolicy2GeneratorMapping mapping : mappings) {
                TokenGeneratorInstance tokenGenerator = (TokenGeneratorInstance)tokenGeneratorManager.getInstance(mapping.getTargetId());
                boolean valid = this.isValidMapping(tepp, mapping, tokenGenerator);
                OAuthSourceId teppSourceId = new OAuthSourceId(OAuthSourceId.Type.TOKEN_EXCHANGE_PROCESSOR_POLICY, mapping.getTargetId());
                String tempMappingId = cxtUtil.buildQualifiedId(mapping.getSourceId(), teppSourceId);
                DependencyError error = new DependencyError(tempMappingId, DependencyType.TOKEN_EXCHANGE_PROCESSOR_POLICY, tepp.getId(), AffectedItemType.TEPP_TO_TG_MAPPING);
                this.updateErrors(existingErrors, valid, error);
            }
        }
    }

    private boolean isValidMapping(TokenExchangeProcessorPolicy tepp, ProcessorPolicy2GeneratorMapping mapping, TokenGeneratorInstance tokenGenerator) {
        ProcessorPolicyToGeneratorMapping apiMapping = (ProcessorPolicyToGeneratorMapping)translator.toApi().apply(mapping);
        translator.cleanupContractFulfillmentMapping().accept(apiMapping);
        ProcessorPolicyToGeneratorAttributeMappingValidator attributeMappingValidator = new ProcessorPolicyToGeneratorAttributeMappingValidator((AttributeMapping)apiMapping, (AttributeContract)tepp.getContract(), tokenGenerator.getAttributeContract(), "", new ValidatorContext(true, this.isEaAdmin(), true));
        return attributeMappingValidator.validate();
    }

    @Override
    public boolean requiresConnectionValidation() {
        return false;
    }
}

