/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.SpTokenGeneratorMapping;
import com.pingidentity.admin.api.validator.SpWsTrustTokenMappingValidator;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.pf.admin.rest.translator.IdpWsTrustTranslator;
import java.util.Collection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.TokenGeneratorInstance;

public class TokenGeneratorsToConnectionsDepErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    private static final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        TokenGeneratorInstance tokenGenerator = (TokenGeneratorInstance)causedByItem;
        Collection connections = connectionManager.getAllIdpConnections();
        for (org.sourceid.saml20.domain.IdpConnection idpConnection : connections) {
            DependencyError error = new DependencyError(idpConnection.getId(), DependencyType.TOKEN_GENERATOR, tokenGenerator.getId(), AffectedItemType.IDP_CONN);
            if (idpConnection.getWsTrustSettings() == null || idpConnection.getWsTrustSettings().getAssertionToTokenMappingsMappings() == null) continue;
            IdpWsTrustTranslator wsTrustTranslator = new IdpWsTrustTranslator();
            IdpConnection apiConnection = new IdpConnection();
            wsTrustTranslator.domainToApi(idpConnection, apiConnection);
            int index = 0;
            for (SpTokenGeneratorMapping mapping : apiConnection.getWsTrust().getTokenGeneratorMappings()) {
                if (mapping.getSpTokenGeneratorRef().getId().equals(tokenGenerator.getId())) {
                    SpWsTrustTokenMappingValidator validator = new SpWsTrustTokenMappingValidator(mapping, index, apiConnection.getWsTrust(), null);
                    if (validator.validate()) {
                        existingErrors.removeIf(dependencyError -> dependencyError.equals((Object)error));
                    } else if (!existingErrors.contains(error)) {
                        existingErrors.add(error);
                    }
                }
                ++index;
            }
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return true;
    }
}

