/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.display.filter;

import com.pingidentity.display.filter.DisplayFilter;
import com.pingidentity.display.filter.DisplayMultiKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class BasicSearchFilter
extends DisplayFilter {
    public static final String QUERY_KEY = "QUERY_KEY";
    public static final String IS_CASE_SENSITIVE_KEY = "IS_CASE_SENSITIVE_KEY";
    public static final String ASTERISK = "*";
    protected boolean isCaseSensitive;
    protected List<String> queryTokens = new ArrayList<String>();

    public BasicSearchFilter(DisplayFilter next) {
        super(next);
    }

    @Override
    protected void configureFilter(Properties props) {
        this.isCaseSensitive = "true".equalsIgnoreCase(props.getProperty(IS_CASE_SENSITIVE_KEY, "false"));
        String queryToModify = props.getProperty(QUERY_KEY);
        this.queryTokens.clear();
        if (StringUtils.isNotBlank((String)queryToModify)) {
            this.queryTokens = this.getTokensFromString(this.queryTokens, queryToModify);
        }
    }

    @Override
    protected List<DisplayMultiKey> getFilteredResults(List<DisplayMultiKey> items) {
        if (this.queryTokens.isEmpty()) {
            return items;
        }
        ArrayList<DisplayMultiKey> filteredResults = new ArrayList<DisplayMultiKey>();
        block0: for (DisplayMultiKey item : items) {
            for (Object key : item.getKeys()) {
                boolean matches = this.itemMatchesQuery(this.getProcessedItem((String)key));
                if (!matches) continue;
                filteredResults.add(item);
                continue block0;
            }
        }
        return filteredResults;
    }

    protected boolean itemMatchesQuery(String item) {
        boolean itemContainsAllQueryTokens = true;
        for (String queryToken : this.queryTokens) {
            itemContainsAllQueryTokens &= item.contains(queryToken);
        }
        return itemContainsAllQueryTokens;
    }

    protected String getProcessedItem(String item) {
        return this.isCaseSensitive ? item : item.toLowerCase();
    }

    protected List<String> getTokensFromString(List<String> tokens, String query) {
        for (String token : StringUtils.split((String)query)) {
            token = StringUtils.stripStart((String)token, (String)ASTERISK);
            token = StringUtils.stripEnd((String)token, (String)ASTERISK);
            tokens.add(this.isCaseSensitive ? token.trim() : token.toLowerCase().trim());
        }
        return tokens;
    }
}

