/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.display.filter;

import com.pingidentity.display.filter.BlockFilter;
import com.pingidentity.display.filter.DisplayFilter;
import com.pingidentity.display.filter.DisplayMultiKey;
import java.util.List;

public class PaginationFilter
extends BlockFilter {
    public PaginationFilter(DisplayFilter next) {
        super(next);
    }

    @Override
    protected List<DisplayMultiKey> getFilteredResults(List<DisplayMultiKey> items) {
        if (items.isEmpty()) {
            return items;
        }
        List<DisplayMultiKey> itemsPerSelectedBlock = super.getFilteredResults(items);
        List<DisplayMultiKey> itemsPerSelectedPage = this.getSubListOfItems(itemsPerSelectedBlock, this.itemsPerPage, this.page);
        return itemsPerSelectedPage;
    }

    public static int getPageCount(double numberOfItems, double itemsPerPage) {
        Double roundedUp = Math.ceil(numberOfItems / itemsPerPage);
        return roundedUp.intValue();
    }

    public static int getNumberOfPagesInSelectedBlock(int itemsPerPage, int currentBlock, int pageCount) {
        if (itemsPerPage * currentBlock / pageCount < 1) {
            return itemsPerPage;
        }
        return pageCount % itemsPerPage;
    }
}

