/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.draft.mgmt;

import com.pingidentity.common.util.B64;
import com.pingidentity.draft.ConnectionDraft;
import com.pingidentity.draft.Draft;
import com.pingidentity.draft.mgmt.DraftManager;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.ConnectionImageType;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.xmlbeans.XmlCalendar;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.ConfigManagerBase;
import org.sourceid.websso.Protocol;

public class DraftManagerImpl
extends ConfigManagerBase
implements DraftManager {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final DraftManagerImpl instance = new DraftManagerImpl();
    private final ConfigStore configStore = ConfigStoreFarm.getConfig(this.getClass());
    private static final String CONNECTION_IMAGE_TYPES_DELIMITER = ",";
    private static final String STACK_MAP = "stack-map";
    private static final String PROTOCOL_MAP = "protocol-map";
    private static final String DATE_MAP = "date-map";
    private static final String ROLE_MAP = "role-map";
    private static final String SYSTEM_ID_MAP = "system-id-map";
    private static final String CONNECTION_NAME_MAP = "connection-name-map";
    private static final String CONNECTION_IMAGE_TYPES_MAP = "connection-image-types-map";
    private static final String CONNECTION_VIRTUAL_ID_MAP = "connection-virtual-id-map";
    private static final String CONNECTION_HAS_BROWSER_SSO_MAP = "connection-has-browser-sso";
    private static final String CONNECTION_AS_WS_TRUST_TYPE = "connection-as-ws-trust-type";
    private static final String CONNECTION_HAS_OAUTH_SAML_GRANT_MAP = "connection-has-oauth-saml-grant-map";
    private static final String CONNECTION_HAS_INBOUND_PROV_MAP = "connection-has-inbound-prov-map";
    private static final String CONNECTION_HAS_OUTBOUND_PROV_MAP = "connection-has-outbound-prov-map";

    private DraftManagerImpl() {
    }

    public static DraftManager getInstance() {
        return instance;
    }

    @Override
    public synchronized boolean saveDraft(Draft draft, Stack<Tasklet> stack) {
        block11: {
            Map stackMap = this.configStore.getMapValue(STACK_MAP, new HashMap());
            Map protocolMap = this.configStore.getMapValue(PROTOCOL_MAP, new HashMap());
            Map dateMap = this.configStore.getMapValue(DATE_MAP, new HashMap());
            Map roleMap = this.configStore.getMapValue(ROLE_MAP, new HashMap());
            Map systemIdMap = this.configStore.getMapValue(SYSTEM_ID_MAP, new HashMap());
            Map connectionNameMap = this.configStore.getMapValue(CONNECTION_NAME_MAP, new HashMap());
            Map connectionImageTypesMap = this.configStore.getMapValue(CONNECTION_IMAGE_TYPES_MAP, new HashMap());
            Map connectionVirtualIdMap = this.configStore.getMapValue(CONNECTION_VIRTUAL_ID_MAP, new HashMap());
            Map connectionHasBrowserSsoMap = this.configStore.getMapValue(CONNECTION_HAS_BROWSER_SSO_MAP, new HashMap());
            Map connectionAsWsTrustTypeMap = this.configStore.getMapValue(CONNECTION_AS_WS_TRUST_TYPE, new HashMap());
            Map connectionHasOAuthSamlMap = this.configStore.getMapValue(CONNECTION_HAS_OAUTH_SAML_GRANT_MAP, new HashMap());
            Map connectionHasInProvMap = this.configStore.getMapValue(CONNECTION_HAS_INBOUND_PROV_MAP, new HashMap());
            Map connectionHasOutProvMap = this.configStore.getMapValue(CONNECTION_HAS_OUTBOUND_PROV_MAP, new HashMap());
            ConnectionDraft connDraft = (ConnectionDraft)draft;
            String systemId = connDraft.getDraftId();
            String tempId = this.findSystemId(connDraft.getId(), connDraft.getConnType());
            if (tempId != null) {
                systemId = tempId;
            }
            try {
                stackMap.put(systemId, this.serializeTaskletStack(stack));
                if (stackMap.get(systemId) != null) {
                    Protocol protocol = connDraft.getProtocol();
                    if (protocol != null) {
                        protocolMap.put(systemId, protocol.toString());
                    }
                    dateMap.put(systemId, connDraft.getLastModifiedDate().toString());
                    roleMap.put(systemId, connDraft.getConnType().toString());
                    systemIdMap.put(systemId, connDraft.getId());
                    connectionNameMap.put(systemId, connDraft.getConnectionName());
                    connectionImageTypesMap.put(systemId, connDraft.getConnectionImageTypes().stream().map(Objects::toString).collect(Collectors.joining(CONNECTION_IMAGE_TYPES_DELIMITER)));
                    connectionVirtualIdMap.put(systemId, connDraft.getDefaultVirtualIdentity().getVirtualEntityId(DomainMode.CONFIGTIME));
                    connectionHasBrowserSsoMap.put(systemId, String.valueOf(connDraft.isBrowserSsoConfigured()));
                    connectionAsWsTrustTypeMap.put(systemId, String.valueOf(connDraft.isWsTrustConfigured()));
                    connectionHasOAuthSamlMap.put(systemId, String.valueOf(connDraft.isOauthSamlGrantConfigured()));
                    connectionHasInProvMap.put(systemId, String.valueOf(connDraft.isInboundProvisioningConfigured()));
                    connectionHasOutProvMap.put(systemId, String.valueOf(connDraft.isOutboundProvisioningConfigured()));
                    try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
                        this.configStore.setMapValue(STACK_MAP, stackMap);
                        this.configStore.setMapValue(PROTOCOL_MAP, protocolMap);
                        this.configStore.setMapValue(DATE_MAP, dateMap);
                        this.configStore.setMapValue(ROLE_MAP, roleMap);
                        this.configStore.setMapValue(SYSTEM_ID_MAP, systemIdMap);
                        this.configStore.setMapValue(CONNECTION_NAME_MAP, connectionNameMap);
                        this.configStore.setMapValue(CONNECTION_IMAGE_TYPES_MAP, connectionImageTypesMap);
                        this.configStore.setMapValue(CONNECTION_VIRTUAL_ID_MAP, connectionVirtualIdMap);
                        this.configStore.setMapValue(CONNECTION_HAS_BROWSER_SSO_MAP, connectionHasBrowserSsoMap);
                        this.configStore.setMapValue(CONNECTION_AS_WS_TRUST_TYPE, connectionAsWsTrustTypeMap);
                        this.configStore.setMapValue(CONNECTION_HAS_OAUTH_SAML_GRANT_MAP, connectionHasOAuthSamlMap);
                        this.configStore.setMapValue(CONNECTION_HAS_INBOUND_PROV_MAP, connectionHasInProvMap);
                        this.configStore.setMapValue(CONNECTION_HAS_OUTBOUND_PROV_MAP, connectionHasOutProvMap);
                        auditLoggerScope.log(this.getAdminAuditLoggerComponent(connDraft.getConnType()), tempId == null ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.MODIFY, connDraft.getId());
                        break block11;
                    }
                }
                this.deleteDraft(systemId);
            }
            catch (NotSerializableException n) {
                this.log.debug((Object)("There was a NotSerializableException trying to serialize the draft: " + n));
                this.log.debug((Object)("message: " + n.getMessage()));
                return false;
            }
            catch (IOException io) {
                this.log.debug((Object)("There was an IOException trying to serialize the draft: " + io));
                this.log.debug((Object)("message: " + io.getMessage()));
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isIdpEntityIdInUse(String entityId, String systemId) {
        return this.isDraftEntityIdInUse(entityId, systemId, ConnectionType.IDP);
    }

    @Override
    public boolean isSpEntityIdInUse(String entityId, String systemId) {
        return this.isDraftEntityIdInUse(entityId, systemId, ConnectionType.SP);
    }

    private boolean isDraftEntityIdInUse(String entityId, String systemId, ConnectionType connType) {
        Map roleMap = this.configStore.getMapValue(ROLE_MAP, new HashMap());
        Map systemIdMap = this.configStore.getMapValue(SYSTEM_ID_MAP, new HashMap());
        for (Map.Entry entry : systemIdMap.entrySet()) {
            if (!entityId.equals(entry.getValue())) continue;
            if (systemId != null && systemId.equals(entry.getKey())) {
                return false;
            }
            if (ConnectionType.valueOf((String)roleMap.get(entry.getKey())) != connType) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIdpConnectionNameInUse(String connectionName, String systemId) {
        return this.isDraftConnectionNameInUse(connectionName, systemId, ConnectionType.IDP);
    }

    @Override
    public boolean isSpConnectionNameInUse(String connectionName, String systemId) {
        return this.isDraftConnectionNameInUse(connectionName, systemId, ConnectionType.SP);
    }

    private boolean isDraftConnectionNameInUse(String connectionName, String systemId, ConnectionType connType) {
        Map roleMap = this.configStore.getMapValue(ROLE_MAP, new HashMap());
        Map connectionNameMap = this.configStore.getMapValue(CONNECTION_NAME_MAP, new HashMap());
        for (Map.Entry entry : connectionNameMap.entrySet()) {
            if (!connectionName.equals(entry.getValue())) continue;
            if (systemId != null && systemId.equals(entry.getKey())) {
                return false;
            }
            if (ConnectionType.valueOf((String)roleMap.get(entry.getKey())) != connType) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Draft> getAllDrafts() {
        ArrayList<Draft> drafts = new ArrayList<Draft>();
        Map map = this.configStore.getMapValue(SYSTEM_ID_MAP, new HashMap());
        for (Map.Entry entry : map.entrySet()) {
            Draft draft = this.getDraft((String)entry.getKey());
            drafts.add(draft);
        }
        return drafts;
    }

    @Override
    public Collection<Draft> getIdpDrafts(boolean filterByServerSettings) {
        LocalSettingsManager localSettingsMgr = MgmtFactory.getLocalSettingsManager();
        LocalSettings localSettings = localSettingsMgr.getLocalSettings();
        ArrayList<Draft> drafts = new ArrayList<Draft>();
        Map map = this.configStore.getMapValue(SYSTEM_ID_MAP, new HashMap());
        block7: for (Map.Entry entry : map.entrySet()) {
            ConnectionDraft draft = (ConnectionDraft)this.getDraft((String)entry.getKey());
            if (draft.getConnType() != ConnectionType.IDP) continue;
            if (filterByServerSettings) {
                if (draft.isBrowserSsoConfigured()) {
                    switch (draft.getProtocol()) {
                        case SAML20: {
                            if (!localSettings.isEnableSamlSp()) break;
                            drafts.add(draft);
                            continue block7;
                        }
                        case SAML11: {
                            if (!localSettings.isEnableSamlOneOneRp()) break;
                            drafts.add(draft);
                            continue block7;
                        }
                        case SAML10: {
                            if (!localSettings.isEnableSamlOneZeroRp()) break;
                            drafts.add(draft);
                            continue block7;
                        }
                        case WSFED: {
                            if (!localSettings.isEnableWsFedSp()) break;
                            drafts.add(draft);
                            continue block7;
                        }
                        case OIDC: {
                            if (!localSettings.isEnableOIDCSp()) break;
                            drafts.add(draft);
                            continue block7;
                        }
                    }
                }
                if (draft.isWsTrustConfigured() && localSettings.isEnableWsTrustSp()) {
                    drafts.add(draft);
                    continue;
                }
                if (draft.isOauthSamlGrantConfigured() && MgmtFactory.getAuthzServerManager().isEnableOAuth()) {
                    drafts.add(draft);
                    continue;
                }
                if (!draft.isInboundProvisioningConfigured() || !localSettings.isEnableInboundProvisioning()) continue;
                drafts.add(draft);
                continue;
            }
            drafts.add(draft);
        }
        return drafts;
    }

    @Override
    public Collection<Draft> getSpDrafts(boolean filterByServerSettings) {
        LocalSettingsManager localSettingsMgr = MgmtFactory.getLocalSettingsManager();
        LocalSettings localSettings = localSettingsMgr.getLocalSettings();
        ArrayList<Draft> drafts = new ArrayList<Draft>();
        Map map = this.configStore.getMapValue(SYSTEM_ID_MAP, new HashMap());
        block6: for (Map.Entry entry : map.entrySet()) {
            ConnectionDraft draft = (ConnectionDraft)this.getDraft((String)entry.getKey());
            if (draft.getConnType() != ConnectionType.SP) continue;
            if (filterByServerSettings) {
                if (draft.isBrowserSsoConfigured()) {
                    switch (draft.getProtocol()) {
                        case SAML20: {
                            if (!localSettings.isEnableSamlIdP()) break;
                            drafts.add(draft);
                            continue block6;
                        }
                        case SAML11: {
                            if (!localSettings.isEnableSamlOneOneAp()) break;
                            drafts.add(draft);
                            continue block6;
                        }
                        case SAML10: {
                            if (!localSettings.isEnableSamlOneZeroAp()) break;
                            drafts.add(draft);
                            continue block6;
                        }
                        case WSFED: {
                            if (!localSettings.isEnableWsFedIdP()) break;
                            drafts.add(draft);
                            continue block6;
                        }
                    }
                }
                if (draft.isWsTrustConfigured() && localSettings.isEnableWsTrustIdP()) {
                    drafts.add(draft);
                    continue;
                }
                if (!draft.isOutboundProvisioningConfigured() || !localSettings.isEnableOutboundProvisioning()) continue;
                drafts.add(draft);
                continue;
            }
            drafts.add(draft);
        }
        return drafts;
    }

    @Override
    public Draft getDraft(String systemId) {
        Map protocolMap = this.configStore.getMapValue(PROTOCOL_MAP, new HashMap());
        Map dateMap = this.configStore.getMapValue(DATE_MAP, new HashMap());
        Map roleMap = this.configStore.getMapValue(ROLE_MAP, new HashMap());
        Map systemIdMap = this.configStore.getMapValue(SYSTEM_ID_MAP, new HashMap());
        Map connectionNameMap = this.configStore.getMapValue(CONNECTION_NAME_MAP, new HashMap());
        Map connectionImageTypesMap = this.configStore.getMapValue(CONNECTION_IMAGE_TYPES_MAP, new HashMap());
        Map connectionVirtualIdMap = this.configStore.getMapValue(CONNECTION_VIRTUAL_ID_MAP, new HashMap());
        Map connectionHasBrowserSsoMap = this.configStore.getMapValue(CONNECTION_HAS_BROWSER_SSO_MAP, new HashMap());
        Map connectionAsWsTrustTypeMap = this.configStore.getMapValue(CONNECTION_AS_WS_TRUST_TYPE, new HashMap());
        Map connectionHasOAuthSamlMap = this.configStore.getMapValue(CONNECTION_HAS_OAUTH_SAML_GRANT_MAP, new HashMap());
        Map connectionHasInProvMap = this.configStore.getMapValue(CONNECTION_HAS_INBOUND_PROV_MAP, new HashMap());
        Map connectionHasOutProvMap = this.configStore.getMapValue(CONNECTION_HAS_OUTBOUND_PROV_MAP, new HashMap());
        ConnectionDraft draft = null;
        if (systemIdMap.containsKey(systemId)) {
            draft = new ConnectionDraft();
            draft.setDraftId(systemId);
            String date = (String)dateMap.get(systemId);
            draft.setLastModifiedDate((Calendar)new XmlCalendar(date));
            Protocol protocol = null;
            String protocolString = (String)protocolMap.get(systemId);
            if (protocolString != null) {
                protocol = Protocol.valueOf((String)protocolString);
                switch (protocol) {
                    case SAML20: {
                        draft.setProtocol(Protocol.SAML20);
                        break;
                    }
                    case SAML10: {
                        draft.setProtocol(Protocol.SAML10);
                        break;
                    }
                    case SAML11: {
                        draft.setProtocol(Protocol.SAML11);
                        break;
                    }
                    case WSFED: {
                        draft.setProtocol(Protocol.WSFED);
                        break;
                    }
                    case OIDC: {
                        draft.setProtocol(Protocol.OIDC);
                    }
                }
            }
            draft.setConnectionType(ConnectionType.valueOf((String)roleMap.get(systemId)));
            draft.setId((String)systemIdMap.get(systemId));
            String connName = (String)connectionNameMap.get(systemId);
            if (connName != null) {
                draft.setConnectionName(connName);
            } else {
                draft.setConnectionName(draft.getId());
            }
            String connectionImageTypesValue = (String)connectionImageTypesMap.get(systemId);
            LinkedList<ConnectionImageType> connectionImageTypes = new LinkedList<ConnectionImageType>();
            if (connectionImageTypesValue != null) {
                String[] connectionImageTypesArray;
                for (String connectionImageType : connectionImageTypesArray = connectionImageTypesValue.split(CONNECTION_IMAGE_TYPES_DELIMITER)) {
                    connectionImageTypes.add(ConnectionImageType.valueOf(connectionImageType));
                }
            }
            draft.setConnectionImageTypes(connectionImageTypes);
            String virtualId = (String)connectionVirtualIdMap.get(systemId);
            if (virtualId != null) {
                draft.getDefaultVirtualIdentity().setVirtualEntityId(virtualId, DomainMode.CONFIGTIME);
            }
            draft.setBrowserSsoConfigured(Boolean.valueOf((String)connectionHasBrowserSsoMap.get(systemId)));
            draft.setWsTrustConfigured(Boolean.valueOf((String)connectionAsWsTrustTypeMap.get(systemId)));
            draft.setOauthSamlGrantConfigured(Boolean.valueOf((String)connectionHasOAuthSamlMap.get(systemId)));
            draft.setInboundProvisioningConfigured(Boolean.valueOf((String)connectionHasInProvMap.get(systemId)));
            draft.setOutboundProvisioningConfigured(Boolean.valueOf((String)connectionHasOutProvMap.get(systemId)));
        }
        return draft;
    }

    @Override
    public Stack<Tasklet> getStack(String systemId) {
        Map stackMap = this.configStore.getMapValue(STACK_MAP, new HashMap());
        Stack<Tasklet> stack = new Stack<Tasklet>();
        if (stackMap.containsKey(systemId)) {
            String serializedStack = (String)stackMap.get(systemId);
            try {
                stack = this.deserializeTaskletStack(serializedStack);
            }
            catch (IOException io) {
                this.log.error((Object)("There was an IOException trying to deserialize the draft: " + io));
                this.log.error((Object)("message: " + io.getMessage()));
                return null;
            }
        }
        return stack;
    }

    @Override
    public String getDraftId(String entityId, ConnectionType connectionType) {
        return this.findSystemId(entityId, connectionType);
    }

    protected String findSystemId(String entityId, ConnectionType connType) {
        Map roleMap = this.configStore.getMapValue(ROLE_MAP, new HashMap());
        Map systemIdMap = this.configStore.getMapValue(SYSTEM_ID_MAP, new HashMap());
        for (Map.Entry sysId : systemIdMap.entrySet()) {
            String id;
            ConnectionType entryConnType;
            if (!entityId.equals(sysId.getValue()) || connType != (entryConnType = ConnectionType.valueOf((String)roleMap.get(id = (String)sysId.getKey())))) continue;
            return id;
        }
        return null;
    }

    @Override
    public synchronized void deleteDraft(String entityId, ConnectionType connType) {
        String id = this.findSystemId(entityId, connType);
        if (id != null) {
            this.log.debug((Object)("Deleted draft id " + id));
            this.deleteDraft(id);
        }
    }

    @Override
    public synchronized void deleteDraft(String systemId) {
        Map protocolMap = this.configStore.getMapValue(PROTOCOL_MAP, new HashMap());
        Map dateMap = this.configStore.getMapValue(DATE_MAP, new HashMap());
        Map roleMap = this.configStore.getMapValue(ROLE_MAP, new HashMap());
        Map stackMap = this.configStore.getMapValue(STACK_MAP, new HashMap());
        Map systemIdMap = this.configStore.getMapValue(SYSTEM_ID_MAP, new HashMap());
        Map connectionNameMap = this.configStore.getMapValue(CONNECTION_NAME_MAP, new HashMap());
        Map connectionImageTypes = this.configStore.getMapValue(CONNECTION_IMAGE_TYPES_MAP, new HashMap());
        Map connectionVirtualIdMap = this.configStore.getMapValue(CONNECTION_VIRTUAL_ID_MAP, new HashMap());
        Map connectionHasBrowserSsoMap = this.configStore.getMapValue(CONNECTION_HAS_BROWSER_SSO_MAP, new HashMap());
        Map connectionAsWsTrustTypeMap = this.configStore.getMapValue(CONNECTION_AS_WS_TRUST_TYPE, new HashMap());
        Map connectionHasOAuthSamlMap = this.configStore.getMapValue(CONNECTION_HAS_OAUTH_SAML_GRANT_MAP, new HashMap());
        Map connectionHasInProvMap = this.configStore.getMapValue(CONNECTION_HAS_INBOUND_PROV_MAP, new HashMap());
        Map connectionHasOutProvMap = this.configStore.getMapValue(CONNECTION_HAS_OUTBOUND_PROV_MAP, new HashMap());
        protocolMap.remove(systemId);
        dateMap.remove(systemId);
        String role = (String)roleMap.remove(systemId);
        stackMap.remove(systemId);
        String id = (String)systemIdMap.remove(systemId);
        connectionNameMap.remove(systemId);
        connectionImageTypes.remove(systemId);
        connectionVirtualIdMap.remove(systemId);
        connectionHasBrowserSsoMap.remove(systemId);
        connectionAsWsTrustTypeMap.remove(systemId);
        connectionHasOAuthSamlMap.remove(systemId);
        connectionHasInProvMap.remove(systemId);
        connectionHasOutProvMap.remove(systemId);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.configStore.setMapValue(STACK_MAP, stackMap);
            this.configStore.setMapValue(PROTOCOL_MAP, protocolMap);
            this.configStore.setMapValue(DATE_MAP, dateMap);
            this.configStore.setMapValue(ROLE_MAP, roleMap);
            this.configStore.setMapValue(SYSTEM_ID_MAP, systemIdMap);
            this.configStore.setMapValue(CONNECTION_NAME_MAP, connectionNameMap);
            this.configStore.setMapValue(CONNECTION_IMAGE_TYPES_MAP, connectionImageTypes);
            this.configStore.setMapValue(CONNECTION_VIRTUAL_ID_MAP, connectionVirtualIdMap);
            this.configStore.setMapValue(CONNECTION_HAS_BROWSER_SSO_MAP, connectionHasBrowserSsoMap);
            this.configStore.setMapValue(CONNECTION_AS_WS_TRUST_TYPE, connectionAsWsTrustTypeMap);
            this.configStore.setMapValue(CONNECTION_HAS_OAUTH_SAML_GRANT_MAP, connectionHasOAuthSamlMap);
            this.configStore.setMapValue(CONNECTION_HAS_INBOUND_PROV_MAP, connectionHasInProvMap);
            this.configStore.setMapValue(CONNECTION_HAS_OUTBOUND_PROV_MAP, connectionHasOutProvMap);
            if (id != null) {
                auditLoggerScope.log(this.getAdminAuditLoggerComponent(role), AdminAuditLogger.Event.DELETE, id);
            }
        }
    }

    private String serializeTaskletStack(Stack<Tasklet> stack) throws IOException {
        String serialized = "";
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(stack);
            byte[] bytes = baos.toByteArray();
            serialized = B64.encode((byte[])bytes);
            oos.close();
        }
        return serialized;
    }

    @Override
    public boolean testSerializeTaskletStack(Stack<Tasklet> stack) {
        try {
            this.serializeTaskletStack(stack);
        }
        catch (NotSerializableException n) {
            this.log.debug((Object)("There was a NotSerializableException trying to serialize the draft: " + n));
            this.log.debug((Object)("message: " + n.getMessage()));
            return false;
        }
        catch (IOException io) {
            this.log.debug((Object)("There was an IOException trying to serialize the draft: " + io));
            this.log.debug((Object)("message: " + io.getMessage()));
            return false;
        }
        catch (ApplicationRuntimeException are) {
            this.log.debug((Object)("There was an ApplicationRuntimeException trying to serialize the draft: " + are));
            this.log.debug((Object)("message: " + are.getMessage()));
            return false;
        }
        return true;
    }

    private Stack<Tasklet> deserializeTaskletStack(String serializedStack) throws IOException {
        Stack draftStack = new Stack();
        byte[] decodedBytes = B64.decodeToBytes((String)serializedStack);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(decodedBytes);
             ObjectInputStream ois = new ObjectInputStream(bais);){
            draftStack = (Stack)ois.readObject();
        }
        catch (ClassNotFoundException c) {
            this.log.debug((Object)("There was a ClassNotFoundException thrown while trying to deserialize the draft: " + c));
        }
        return draftStack;
    }

    private AdminAuditLogger.Component getAdminAuditLoggerComponent(ConnectionType connectionType) {
        if (ConnectionType.IDP.equals((Object)connectionType)) {
            return AdminAuditLogger.Component.IDP_CONNECTION_DRAFT;
        }
        if (ConnectionType.SP.equals((Object)connectionType)) {
            return AdminAuditLogger.Component.SP_CONNECTION_DRAFT;
        }
        return AdminAuditLogger.Component.COMPONENT;
    }

    private AdminAuditLogger.Component getAdminAuditLoggerComponent(String role) {
        if (ConnectionType.IDP.toString().equals(role)) {
            return AdminAuditLogger.Component.IDP_CONNECTION_DRAFT;
        }
        if (ConnectionType.SP.toString().equals(role)) {
            return AdminAuditLogger.Component.SP_CONNECTION_DRAFT;
        }
        return AdminAuditLogger.Component.COMPONENT;
    }
}

