/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm;

import com.pingidentity.session.AdminSessionTracker;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionTimeout
implements HttpSessionListener {
    private static final String CONSOLE_SESSION_TIMEOUT = "pf.console.session.timeout";
    private static final String CONSOLE_SESSION_TIMEOUT_VAL = System.getProperty("pf.console.session.timeout");
    private static final Integer CONSOLE_SESSION_TIMEOUT_INT_MIN = 1;
    private static final Integer CONSOLE_SESSION_TIMEOUT_INT_MAX = 480;
    private static final Integer CONSOLE_SESSION_TIMEOUT_INT;
    private static Log log;

    public void sessionCreated(HttpSessionEvent se) {
        if (CONSOLE_SESSION_TIMEOUT_INT != null) {
            se.getSession().setMaxInactiveInterval(CONSOLE_SESSION_TIMEOUT_INT * 60);
        }
        log.info((Object)String.format("Application '%s' session timeout is %d minutes.", se.getSession().getServletContext().getContextPath(), se.getSession().getMaxInactiveInterval() / 60));
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        AdminSessionTracker.getInstance().removeSession(se.getSession());
    }

    static {
        log = LogFactory.getLog(SessionTimeout.class);
        Integer sessionTimeout = null;
        try {
            sessionTimeout = Integer.valueOf(CONSOLE_SESSION_TIMEOUT_VAL);
            if (sessionTimeout < CONSOLE_SESSION_TIMEOUT_INT_MIN) {
                sessionTimeout = null;
                log.warn((Object)String.format("The value '%s' for %s in run.properties is less than the allowed minimum of %d minutes.  Using the default session timeout value.", CONSOLE_SESSION_TIMEOUT_VAL, CONSOLE_SESSION_TIMEOUT, CONSOLE_SESSION_TIMEOUT_INT_MIN));
            } else if (sessionTimeout > CONSOLE_SESSION_TIMEOUT_INT_MAX) {
                sessionTimeout = null;
                log.warn((Object)String.format("The value '%s' for %s in run.properties is more than the allowed maximum of %d hours.  Using the default session timeout value.", CONSOLE_SESSION_TIMEOUT_VAL, CONSOLE_SESSION_TIMEOUT, CONSOLE_SESSION_TIMEOUT_INT_MAX / 60));
            }
        }
        catch (NumberFormatException e) {
            sessionTimeout = null;
            log.warn((Object)String.format("The value '%s' for %s in run.properties is not a valid integer.  Using the default session timeout value.", CONSOLE_SESSION_TIMEOUT_VAL, CONSOLE_SESSION_TIMEOUT));
        }
        CONSOLE_SESSION_TIMEOUT_INT = sessionTimeout;
    }
}

