/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm;

import com.pingidentity.common.util.SizeBoundedLinkedHashMap;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.session.CopyAndPastePolicyManager;
import com.pingidentity.session.LoginTracker;
import com.pingidentity.sso.OIDCAuthenticationResult;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import javax.servlet.http.HttpSession;
import org.apache.tapestry.IMessages;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.NotificationBanner;
import org.sourceid.saml20.state.State;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public class Visit
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private static final int MAX_REQUEST_STATE_CAPACITY = 5;
    private volatile Stack<Tasklet> taskletStack = new Stack();
    private Tasklet initialTasklet;
    private boolean isUserAuthenticated;
    private AdministrativeUser currentUser;
    private transient IMessages messages;
    private final Queue<Tasklet> steps = new LinkedList<Tasklet>();
    private String lastPageViewed;
    private boolean skipForUIPerformanceFlag;
    private final transient Map<String, Object> uiDataSourceCache = new HashMap<String, Object>();
    private final transient Map<String, State> oidcAuthenticationRequestStateMap = new SizeBoundedLinkedHashMap(5, false, 5);
    private transient OIDCAuthenticationResult oidcAuthenticationResult;
    private boolean pingOneSso = false;
    private transient CopyAndPastePolicyManager copyAndPastePolicyManager;
    private transient NotificationBanner notificationBanner;
    private boolean hasNotificationBanner = false;

    public Tasklet pop() {
        Tasklet tasklet = this.taskletStack.pop();
        this.checkStack();
        return tasklet;
    }

    public Tasklet peek() {
        return this.taskletStack.peek();
    }

    public boolean empty() {
        return this.taskletStack.empty();
    }

    public int size() {
        return this.taskletStack.size();
    }

    public Tasklet push(Tasklet tasklet) {
        return this.taskletStack.push(tasklet);
    }

    public void clear() {
        this.taskletStack.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStack() {
        if (this.taskletStack.empty()) {
            Queue<Tasklet> queue = this.steps;
            synchronized (queue) {
                if (!this.steps.isEmpty()) {
                    this.taskletStack.push(this.steps.poll());
                }
            }
        }
    }

    public Tasklet getCurrentTasklet() {
        this.checkStack();
        return this.taskletStack.peek();
    }

    public Tasklet getTasklet() {
        this.checkStack();
        return this.taskletStack.peek();
    }

    public Iterator<Tasklet> getTaskletList() {
        return this.taskletStack.iterator();
    }

    public TaskletState getCurrentState() {
        if (!this.taskletStack.empty()) {
            return (TaskletState)this.taskletStack.peek().getCurrentState();
        }
        return null;
    }

    public void swapTasklet(Tasklet taskletToSwap) {
        if (!this.taskletStack.empty()) {
            this.taskletStack.pop();
            this.taskletStack.push(taskletToSwap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStep(Tasklet tasklet) {
        Queue<Tasklet> queue = this.steps;
        synchronized (queue) {
            this.steps.offer(tasklet);
            tasklet.getCurrentState().onStateActivated();
        }
    }

    public boolean isStepsEmpty() {
        return this.steps.isEmpty();
    }

    public Tasklet getInitialTasklet() {
        return this.initialTasklet;
    }

    public void setInitialTasklet(Tasklet initialTasklet) {
        this.initialTasklet = initialTasklet;
    }

    public boolean isUserAuthenticated() {
        return this.isUserAuthenticated;
    }

    public void setUserAuthenticated(boolean isUserAuthenticated) {
        this.isUserAuthenticated = isUserAuthenticated;
    }

    public AdministrativeUser getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(AdministrativeUser currentUser) {
        this.currentUser = currentUser;
    }

    public void logout(IRequestCycle cycle) {
        this.logout(cycle.getRequestContext().getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(HttpSession session) {
        Queue<Tasklet> queue = this.steps;
        synchronized (queue) {
            if (session != null) {
                session.invalidate();
            }
            LoginTracker.getInstance().logOutUser(session, this.currentUser);
            this.setUserAuthenticated(false);
            AdminAuditLogger.log((AdminAuditLogger.Component)AdminAuditLogger.Component.USER, (AdminAuditLogger.Event)AdminAuditLogger.Event.LOGOUT, (String)"");
            this.setCurrentUser(null);
            this.taskletStack.clear();
            this.steps.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUserSteps() {
        Queue<Tasklet> queue = this.steps;
        synchronized (queue) {
            this.setCurrentUser(null);
            this.setUserAuthenticated(false);
            this.taskletStack.clear();
            this.steps.clear();
        }
    }

    public IMessages getMessages() {
        return this.messages;
    }

    public void setMessages(IMessages messages) {
        this.messages = messages;
    }

    public Stack<Tasklet> getTaskletStack() {
        return this.taskletStack;
    }

    public void setTaskletStack(Stack<Tasklet> stack) {
        this.taskletStack = stack;
    }

    public void setTaskletStack(ArrayList<Tasklet> draftTaskletList) {
        for (Tasklet t : draftTaskletList) {
            this.taskletStack.push(t);
        }
    }

    public void setTaskletStack(List<Tasklet> draftTaskletList) {
        for (Tasklet t : draftTaskletList) {
            this.taskletStack.push(t);
        }
    }

    public Stack<Tasklet> popStackToTasklet(Class<? extends Tasklet> taskletToStopOn) {
        Stack<Tasklet> targetStack = new Stack<Tasklet>();
        while (!this.taskletStack.isEmpty()) {
            Tasklet t = this.taskletStack.pop();
            targetStack.push(t);
            if (!taskletToStopOn.isInstance(t)) continue;
            return targetStack;
        }
        return null;
    }

    public String getLastPageViewed() {
        return this.lastPageViewed;
    }

    public void setLastPageViewed(String lastPageViewed) {
        this.lastPageViewed = lastPageViewed;
    }

    public boolean isSkipForUIPerformanceFlag() {
        return this.skipForUIPerformanceFlag;
    }

    public void setSkipForUIPerformanceFlag(boolean skipForUIPerformanceFlag) {
        this.skipForUIPerformanceFlag = skipForUIPerformanceFlag;
    }

    public Map<String, Object> getUIDataSourceCache() {
        return this.uiDataSourceCache;
    }

    public State getOidcAuthenticationRequestState(String state) {
        return this.oidcAuthenticationRequestStateMap.get(state);
    }

    public void setOidcAuthenticationRequestState(String state, State oidcAuthenticationRequestState) {
        this.oidcAuthenticationRequestStateMap.put(state, oidcAuthenticationRequestState);
    }

    public OIDCAuthenticationResult getOIDCAuthenticationResult() {
        return this.oidcAuthenticationResult;
    }

    public void setOIDCAuthenticationResult(OIDCAuthenticationResult oidcAuthenticationResult) {
        this.oidcAuthenticationResult = oidcAuthenticationResult;
    }

    public boolean isPingOneSso() {
        return this.pingOneSso;
    }

    public void setPingOneSso(boolean pingOneSso) {
        this.pingOneSso = pingOneSso;
    }

    public Queue<Tasklet> getSteps() {
        return this.steps;
    }

    public CopyAndPastePolicyManager getCopyAndPastePolicyManager() {
        if (this.copyAndPastePolicyManager == null) {
            this.copyAndPastePolicyManager = new CopyAndPastePolicyManager();
        }
        return this.copyAndPastePolicyManager;
    }

    public void setNotificationBannerContent(NotificationBanner notificationBanner) {
        this.notificationBanner = notificationBanner;
        this.hasNotificationBanner = true;
    }

    public boolean hasNotificationBannerContent() {
        return this.hasNotificationBanner;
    }

    public NotificationBanner consumeNotificationBanner() {
        this.hasNotificationBanner = false;
        return this.notificationBanner;
    }
}

