/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.helper;

import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.pingcommons.util.NumberUtils;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.impl.util.HexBin;

public class ImportMetadataSummaryHelper {
    private static final Log log = LogFactory.getLog(ImportMetadataSummaryHelper.class);

    public static String getFingerprint(String algo, Cert signCert) {
        String fingerprint;
        try {
            MessageDigest digester = MessageDigest.getInstance(algo);
            byte[] digest = digester.digest(signCert.getEncoded());
            fingerprint = HexBin.bytesToString((byte[])digest);
        }
        catch (GeneralSecurityException e) {
            log.debug((Object)("An error occurred when generating " + algo + " fingerprint: "), (Throwable)e);
            fingerprint = "(ERROR)";
        }
        return fingerprint;
    }

    private static String getSubjectAlternativeNames(Cert cert) {
        try {
            return cert.getX509CertificateSubjectAlternativeNames().stream().collect(Collectors.joining(", "));
        }
        catch (CertificateParsingException e) {
            log.debug((Object)"An error occurred when extracting subject alternative names from certificate: ", (Throwable)e);
            return "(ERROR)";
        }
    }

    public static Collection<SummaryInfo> getCertSummary(Cert cert, TaskletState state) {
        ArrayList<SummaryInfo> summaryList = new ArrayList<SummaryInfo>(7);
        if (cert != null && state != null) {
            summaryList.add(new SummaryInfo("Serial Number", NumberUtils.createHexStringForDisplay((BigInteger)cert.getX509Certificate().getSerialNumber()), state));
            summaryList.add(new SummaryInfo("Subject DN", cert.getX509Certificate().getSubjectDN().getName(), state));
            summaryList.add(new SummaryInfo("Subject Alternative Names", ImportMetadataSummaryHelper.getSubjectAlternativeNames(cert), state));
            summaryList.add(new SummaryInfo("Issuer DN", cert.getX509Certificate().getIssuerDN().getName(), state));
            summaryList.add(new SummaryInfo("Expires", cert.getX509Certificate().getNotAfter().toString(), state));
            summaryList.add(new SummaryInfo("Signature Algorithm", cert.getX509Certificate().getSigAlgName(), state));
            summaryList.add(new SummaryInfo("SHA1 Fingerprint", ImportMetadataSummaryHelper.getFingerprint("SHA1", cert), state));
            summaryList.add(new SummaryInfo("SHA256 Fingerprint", ImportMetadataSummaryHelper.getFingerprint("SHA-256", cert), state));
        }
        return summaryList;
    }
}

