/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.helper;

import java.util.List;
import org.sourceid.oauth20.domain.ScopeUtil;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;

public final class ScopeFilterableSelectionHelper {
    public static final FilterableSelectionFieldDescriptor.SearchableTypeConfig OAUTH_COMMON_SCOPE_GROUP_WITH_DEFAULT_OIDC = new FilterableSelectionFieldDescriptor.SearchableTypeConfig(FilterableSelectionFieldDescriptor.SearchableType.OAUTH_COMMON_SCOPE, List.of(new FilterableSelectionFieldDescriptor.QueryParam("includeDefaultOpenId", "true")), "oauth-common-scope");

    private ScopeFilterableSelectionHelper() {
    }

    public static FilterableSelectionFieldDescriptor.SearchableType getSearchableType(String scopeName) {
        if (ScopeUtil.getAllCommonScopeDescriptions().containsKey(scopeName)) {
            return FilterableSelectionFieldDescriptor.SearchableType.OAUTH_COMMON_SCOPE;
        }
        if (ScopeUtil.getAllExclusiveScopeDescriptions().containsKey(scopeName)) {
            return FilterableSelectionFieldDescriptor.SearchableType.OAUTH_EXCLUSIVE_SCOPE;
        }
        if (ScopeUtil.getCommonScopeGroupDescriptions().containsKey(scopeName)) {
            return FilterableSelectionFieldDescriptor.SearchableType.OAUTH_COMMON_SCOPE_GROUP;
        }
        if (ScopeUtil.getExclusiveScopeGroupDescriptions().containsKey(scopeName)) {
            return FilterableSelectionFieldDescriptor.SearchableType.OAUTH_EXCLUSIVE_SCOPE_GROUP;
        }
        return null;
    }

    public static String getDescription(String scopeName) {
        if (ScopeUtil.getAllCommonScopeDescriptions().containsKey(scopeName)) {
            return (String)ScopeUtil.getAllCommonScopeDescriptions().get(scopeName);
        }
        if (ScopeUtil.getAllExclusiveScopeDescriptions().containsKey(scopeName)) {
            return (String)ScopeUtil.getAllExclusiveScopeDescriptions().get(scopeName);
        }
        if (ScopeUtil.getCommonScopeGroupDescriptions().containsKey(scopeName)) {
            return (String)ScopeUtil.getCommonScopeGroupDescriptions().get(scopeName);
        }
        if (ScopeUtil.getExclusiveScopeGroupDescriptions().containsKey(scopeName)) {
            return (String)ScopeUtil.getExclusiveScopeGroupDescriptions().get(scopeName);
        }
        return null;
    }

    public static String getScopeDisplayName(String scopeName, FilterableSelectionFieldDescriptor.SearchableType searchableType) {
        if (FilterableSelectionFieldDescriptor.SearchableType.OAUTH_COMMON_SCOPE.equals(searchableType)) {
            return scopeName + " - (Common Scope)";
        }
        if (FilterableSelectionFieldDescriptor.SearchableType.OAUTH_EXCLUSIVE_SCOPE.equals(searchableType)) {
            return scopeName + " - (Exclusive Scope)";
        }
        if (FilterableSelectionFieldDescriptor.SearchableType.OAUTH_COMMON_SCOPE_GROUP.equals(searchableType)) {
            return scopeName + " - (Common Scope Group)";
        }
        if (FilterableSelectionFieldDescriptor.SearchableType.OAUTH_EXCLUSIVE_SCOPE_GROUP.equals(searchableType)) {
            return scopeName + " - (Exclusive Scope Group)";
        }
        return null;
    }
}

