/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.LoggingMode;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class GeneralSettingsState
extends TaskletState {
    private static final String DONT_OVERRIDE = "Don't Override";
    private String dataStoreValidationInterval;
    private boolean enableAutomaticConnectionValidation;
    private String idpLoggingMode;
    private String spLoggingMode;
    private String requestHeaderNameForCorrelationId;

    public GeneralSettingsState(IWizard owner) {
        super(owner);
    }

    @Override
    public void populate(Object dataFromDisk) {
        LocalSettings settings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        this.dataStoreValidationInterval = Integer.toString(settings.getDataStoreValidationInterval());
        this.enableAutomaticConnectionValidation = settings.isDisableAutomaticConnectionValidation();
        this.requestHeaderNameForCorrelationId = settings.getRequestHeaderNameForCorrelationId();
        if (LoggingMode.isIdpOverrideOn()) {
            this.idpLoggingMode = LoggingMode.getIdpOverrideMode().getLabel();
        }
        if (LoggingMode.isSpOverrideOn()) {
            this.spLoggingMode = LoggingMode.getSpOverrideMode().getLabel();
        }
        super.populate(dataFromDisk);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if ("".equals(this.dataStoreValidationInterval)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Interval_required"), ValidationConstraint.REQUIRED);
        } else {
            try {
                int dataStoreIntervalInt = Integer.parseInt(this.dataStoreValidationInterval);
                if (dataStoreIntervalInt < 0) {
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("Interval_int_range_error"), ValidationConstraint.REQUIRED);
                }
            }
            catch (NumberFormatException nfe) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Interval_int_range_error"), ValidationConstraint.REQUIRED);
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        LocalSettingsManager localSettingsManager = MgmtFactory.getLocalSettingsManager();
        LocalSettings localSettings = localSettingsManager.getLocalSettings();
        localSettings.setDataStoreValidationInterval(Integer.parseInt(this.dataStoreValidationInterval));
        localSettings.setDisableAutomaticConnectionValidation(this.enableAutomaticConnectionValidation);
        localSettings.setRequestHeaderNameForCorrelationId(this.requestHeaderNameForCorrelationId);
        LoggingMode idpLoggingModeEnum = LoggingMode.fromLabel((String)this.idpLoggingMode);
        if (idpLoggingModeEnum != null) {
            LoggingMode.setIdpOverrideMode((LoggingMode)idpLoggingModeEnum);
            LoggingMode.setIdpOverrideOn((boolean)true);
        } else {
            LoggingMode.setIdpOverrideMode((LoggingMode)LoggingMode.STANDARD);
            LoggingMode.setIdpOverrideOn((boolean)false);
        }
        LoggingMode spLoggingModeEnum = LoggingMode.fromLabel((String)this.spLoggingMode);
        if (spLoggingModeEnum != null) {
            LoggingMode.setSpOverrideMode((LoggingMode)spLoggingModeEnum);
            LoggingMode.setSpOverrideOn((boolean)true);
        } else {
            LoggingMode.setSpOverrideMode((LoggingMode)LoggingMode.STANDARD);
            LoggingMode.setSpOverrideOn((boolean)false);
        }
        localSettingsManager.saveLocalSettings(localSettings, AdminAuditLogger.Component.GENERAL_SETTINGS);
        return super.save(dataToDisk);
    }

    private boolean isLoggingModeOverride(String currentValue) {
        return !DONT_OVERRIDE.equals(currentValue);
    }

    public String getDataStoreValidationInterval() {
        return this.dataStoreValidationInterval;
    }

    public void setDataStoreValidationInterval(String dataSourceValidationInterval) {
        this.dataStoreValidationInterval = dataSourceValidationInterval;
    }

    public boolean isEnableAutomaticConnectionValidation() {
        return this.enableAutomaticConnectionValidation;
    }

    public void setEnableAutomaticConnectionValidation(boolean enableAutomaticConnectionValidation) {
        this.enableAutomaticConnectionValidation = enableAutomaticConnectionValidation;
    }

    public String getRequestHeaderNameForCorrelationId() {
        return this.requestHeaderNameForCorrelationId;
    }

    public void setRequestHeaderNameForCorrelationId(String requestHeaderNameForCorrelationId) {
        this.requestHeaderNameForCorrelationId = requestHeaderNameForCorrelationId;
    }

    public void toggleConnValidation() {
        this.enableAutomaticConnectionValidation = !this.enableAutomaticConnectionValidation;
    }

    public String getIdpLoggingMode() {
        return this.idpLoggingMode;
    }

    public void setIdpLoggingMode(String idpLoggingMode) {
        this.idpLoggingMode = idpLoggingMode;
    }

    public String getSpLoggingMode() {
        return this.spLoggingMode;
    }

    public void setSpLoggingMode(String spLoggingMode) {
        this.spLoggingMode = spLoggingMode;
    }

    public IPropertySelectionModel getLoggingModeList() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(false);
        model.add(DONT_OVERRIDE, "DONT_OVERRIDE");
        model.addAll(Arrays.stream(LoggingMode.values()).map(value -> new StringPairPropertySelectionModel.SPair(value.getLabel(), value.getLabel())).collect(Collectors.toList()));
        return model;
    }
}

