/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.authnselection.ui.AsUiAction;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.APCAdapterContractMappingState;
import com.pingidentity.fsm.state.impl.APCIssuanceCriteriaState;
import com.pingidentity.fsm.state.impl.AbstractPolicyContractMappingTasklet;
import com.pingidentity.fsm.state.impl.AbstractPolicyState;
import com.pingidentity.fsm.state.impl.ApcAttributeSourceState;
import com.pingidentity.fsm.state.impl.AuthnPoliciesState;
import com.pingidentity.fsm.state.impl.BaseConfigAttributeSourcesState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.fragments.FragmentMappingTasklet;
import com.pingidentity.fsm.state.impl.localidentity.RegistrationConfigState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.util.SAML2MappingModel;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.OAuthAssertionGrantMapping;

public class APCMappingTasklet
extends AbstractPolicyContractMappingTasklet
implements AttributeNamesApi {
    protected final APCAdapterContractMappingState apcAdapterContractMappingState;
    protected final APCIssuanceCriteriaState issuanceCriteriaState;
    private final SummaryCardState summaryCardState;
    private List<String> contractsToFulfill;
    private AbstractPolicyState state;

    public APCMappingTasklet(Visit visit) {
        super("APCMappingTasklet", "Mapping Configuration");
        this.setMenuName("Authentication Policy Contract Mapping");
        this.setSystemVisit(visit);
        this.issuanceCriteriaState = new APCIssuanceCriteriaState(this);
        this.apcAdapterContractMappingState = new APCAdapterContractMappingState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.setInitialState(this.configAttributeSourcesState);
        this.setCancelAvailable(true);
        this.reconfigureTransitions(visit.getCurrentState());
    }

    @Override
    public void reconfigureTransitions(TaskletState curState) {
        if (!(curState instanceof AuthnPoliciesState) && !(curState instanceof RegistrationConfigState)) {
            this.clearAllStatesOutgoingTransitions(curState);
        }
        this.configAttributeSourcesState.addOutgoingTransition(this, this.apcAdapterContractMappingState);
        this.apcAdapterContractMappingState.addOutgoingTransition(this, this.issuanceCriteriaState);
        this.issuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    public List<String> getContractToFulfill() {
        return this.contractsToFulfill;
    }

    public void setContractToFulfill(List<String> contracts) {
        this.contractsToFulfill = contracts;
    }

    @Override
    public boolean isSaveAllAvailable() {
        return false;
    }

    @Override
    public SAML2MappingModel getMappingModel() {
        AttributeMapping mapping = this.apcAdapterContractMappingState.getModel().getMapping();
        AttributeMapping populatedMapping = (AttributeMapping)this.getPopulateData();
        if (populatedMapping != null) {
            mapping.setTokenAuthorizationIssuanceCriteria(populatedMapping.getTokenAuthorizationIssuanceCriteria());
            List attributeSources = populatedMapping.getAttributeSources();
            attributeSources.forEach(arg_0 -> ((AttributeMapping)mapping).addAttributeSource(arg_0));
        }
        return this.apcAdapterContractMappingState.getModel();
    }

    @Override
    public BaseConfigAttributeSourcesState constructConfigAttributeSourcesState() {
        return new ApcAttributeSourceState(this, "configAttributeSources");
    }

    @Override
    public Collection<String> getAdditionalInputAttributesForFilter() {
        DataMap.Sources sources = new DataMap.Sources();
        this.getUpstreamSources(sources);
        this.addTrackedParamsToSelectionSources(sources);
        this.addInputContractToSelectionSources(sources);
        if (!(this instanceof FragmentMappingTasklet)) {
            this.addExtendedPropertiesToSelectionSources(sources);
            this.addContextToSelectionSources(sources);
        }
        return sources.getValidSubstituterValues().keySet();
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return null;
    }

    @Override
    public String getMappingSourceForDisplay() {
        return null;
    }

    @Override
    public void cancel() {
        Object origData = this.getPopulateData();
        if (origData != null) {
            AttributeMapping mapping = (AttributeMapping)origData;
            super.cancel();
            this.setPopulateData(mapping);
        } else {
            super.cancel();
        }
    }

    @Override
    public void finish() {
        OAuthAssertionGrantMapping mapping = new OAuthAssertionGrantMapping();
        this.save(mapping);
        this.setPopulateData(mapping);
        super.finish();
        this.state.getNodeIdsWithMappingErrors().remove(((AsUiAction)this.getSelectedNode().getData()).getNodeId());
    }

    public void setState(AbstractPolicyState state) {
        this.state = state;
    }

    @Override
    public Set<String> getAllAttributeNames() {
        return new HashSet<String>(this.contractsToFulfill);
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        return this.contractsToFulfill;
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        return null;
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        return null;
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }
}

