/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.impl.AbstractPolicyTasklet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.websso.authn.AuthnPolicyUtil;

public abstract class AbstractPoliciesState
extends TaskletListState {
    public AbstractPoliciesState(IWizard owner) {
        super(owner);
    }

    protected abstract Tasklet initializeNewTasklet();

    public Tasklet createNewTasklet() {
        return this.initializeNewTasklet();
    }

    public void edit(Integer indexToEdit, IRequestCycle cycle) {
        Tasklet tasklet = this.getTasklet(indexToEdit);
        this.loadTasklet(tasklet);
        tasklet.gotoSummaryState(cycle);
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        this.setDelegate(this.getParent().getDelegate(this.getParent().getCycle()));
        this.appendErrors((IValidationDelegate)this.getDelegate(), null, false);
    }

    public void copyPolicy(int taskletIndex) {
        AbstractPolicyTasklet copyFromTasklet = (AbstractPolicyTasklet)this.getTasklet(taskletIndex);
        AuthnSelectionTree tree = copyFromTasklet.getDomainPolicy();
        tree.setId(AuthnPolicyUtil.getDefault().generateId());
        tree.setName(null);
        Tasklet tasklet = this.initializeNewTasklet();
        tasklet.populate(tree);
        this.loadTasklet(tasklet);
        this.addTasklet(tasklet);
    }

    public List<String> getPolicyNames() {
        return this.getTasklets().stream().map(tasklet -> ((AbstractPolicyTasklet)tasklet).getName()).collect(Collectors.toList());
    }

    public List<String> getPolicyIds() {
        return this.getTasklets().stream().map(tasklet -> ((AbstractPolicyTasklet)tasklet).getId()).collect(Collectors.toList());
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        super.appendErrors(delegate, component, fastFail);
        this.getUndeletedTasklets().forEach(undeletedTasklet -> {
            AbstractPolicyTasklet tasklet = (AbstractPolicyTasklet)undeletedTasklet;
            if (tasklet.checkForErrors()) {
                delegate.record(this.getMessage("policy_has_errors", new Object[]{tasklet.getName()}), ValidationConstraint.CONSISTENCY);
            }
        });
    }
}

