/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.CollapsibleSummaryState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpBrowserSsoTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConfigAdapterMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpProtocolSettingsTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.openid.connect.util.OIDCUtil;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.util.SSOApplicationUrlUtil;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.websso.Protocol;

public class ActivationState
extends CollapsibleSummaryState {
    private static final long serialVersionUID = 20050515L;
    private static final String ENABLED = "0";
    private static final String DISABLED = "1";
    private String connStatus = "0";
    private String connStatusFromDisk;

    public ActivationState(Tasklet value) {
        super(value);
        this.setMenuName("Activation & Summary");
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase con = (ConnectionBase)dataFromDisk;
        this.connStatusFromDisk = con.isActive() ? ENABLED : DISABLED;
        this.connStatus = this.connStatusFromDisk;
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase tempCon = (ConnectionBase)dataToDisk;
        tempCon.setActive(this.connStatus.equals(ENABLED));
        return true;
    }

    @Override
    public void reset() {
        this.connStatus = DISABLED;
    }

    public boolean isEnabled() {
        return this.connStatus.equals(ENABLED);
    }

    public void setEnabled(boolean enabled) {
        this.connStatus = enabled ? ENABLED : DISABLED;
    }

    public boolean isConnectionActive() {
        return ENABLED.equals(this.connStatus);
    }

    public boolean isConnectionActiveFromDisk() {
        return ENABLED.equals(this.connStatusFromDisk);
    }

    public boolean showSaveNotAvailable() {
        return !LicenseManager.canAddConnection() && this.getParent().isModeCreate();
    }

    public boolean showOidcRedirectUri() {
        Tasklet t = this.getParent();
        if (t instanceof IdpConnectionConfigTasklet) {
            IdpConnectionConfigTasklet idpConnTasklet = (IdpConnectionConfigTasklet)t;
            return idpConnTasklet.isConnectionProtocolOIDC();
        }
        return false;
    }

    public String getOidcRedirectUri() {
        Tasklet t = this.getParent();
        if (t instanceof IdpConnectionConfigTasklet) {
            IdpConnectionConfigTasklet idpConnTasklet = (IdpConnectionConfigTasklet)t;
            String entityId = idpConnTasklet.getConnId();
            return OIDCUtil.getRedirectUri((String)entityId);
        }
        return "";
    }

    public boolean showOidcBackChannelLogoutUri() {
        IdpProtocolSettingsTasklet idpProtocolSettingsTasklet;
        IdpBrowserSsoTasklet idpBrowserSsoTasklet;
        IdpConnectionConfigTasklet idpConnTasklet;
        Tasklet t = this.getParent();
        if (t instanceof IdpConnectionConfigTasklet && (idpConnTasklet = (IdpConnectionConfigTasklet)t).isConnectionProtocolOIDC() && (idpBrowserSsoTasklet = idpConnTasklet.getIdpBrowserSsoTasklet()) != null && (idpProtocolSettingsTasklet = idpBrowserSsoTasklet.getIdpProtocolSettingsTasklet()) != null) {
            return idpProtocolSettingsTasklet.getOpenIdProviderMetadataState().isTrackUserSessionsForLogout();
        }
        return false;
    }

    public String getOidcBackChannelLogoutUri() {
        Tasklet t = this.getParent();
        if (t instanceof IdpConnectionConfigTasklet) {
            IdpConnectionConfigTasklet idpConnTasklet = (IdpConnectionConfigTasklet)t;
            String entityId = idpConnTasklet.getConnId();
            return OIDCUtil.getBackChannelLogoutUri((String)entityId);
        }
        return "";
    }

    public boolean showOidcFrontChannelLogoutUri() {
        Tasklet t = this.getParent();
        if (t instanceof IdpConnectionConfigTasklet) {
            IdpConnectionConfigTasklet idpConnTasklet = (IdpConnectionConfigTasklet)t;
            return idpConnTasklet.isConnectionProtocolOIDC();
        }
        return false;
    }

    public String getOidcFrontChannelLogoutUri() {
        Tasklet t = this.getParent();
        if (t instanceof IdpConnectionConfigTasklet) {
            IdpConnectionConfigTasklet idpConnTasklet = (IdpConnectionConfigTasklet)t;
            String entityId = idpConnTasklet.getConnId();
            return OIDCUtil.getFrontChannelLogoutUri((String)entityId);
        }
        return "";
    }

    public boolean showOidcPostLogoutRedirectUri() {
        IdpProtocolSettingsTasklet idpProtocolSettingsTasklet;
        IdpBrowserSsoTasklet idpBrowserSsoTasklet;
        IdpConnectionConfigTasklet idpConnTasklet;
        Tasklet t = this.getParent();
        if (t instanceof IdpConnectionConfigTasklet && (idpConnTasklet = (IdpConnectionConfigTasklet)t).isConnectionProtocolOIDC() && (idpBrowserSsoTasklet = idpConnTasklet.getIdpBrowserSsoTasklet()) != null && (idpProtocolSettingsTasklet = idpBrowserSsoTasklet.getIdpProtocolSettingsTasklet()) != null) {
            return StringUtils.isNotBlank((String)idpProtocolSettingsTasklet.getOpenIdProviderMetadataState().getLogoutEndpoint());
        }
        return false;
    }

    public String getOidcPostLogoutRedirectUri() {
        return OIDCUtil.getPostLogoutRedirectUri();
    }

    public boolean showSsoApplicationEndpoint() {
        Tasklet t = this.getParent();
        if (t instanceof SpConnectionConfigTasklet) {
            SpConnectionConfigTasklet spConnTasklet = (SpConnectionConfigTasklet)t;
            return SSOApplicationUrlUtil.displaySpConnectionSsoURL((Protocol)spConnTasklet.getProtocolType(), (boolean)spConnTasklet.isIdpSSOSelected());
        }
        if (t instanceof IdpConnectionConfigTasklet) {
            IdpConnectionConfigTasklet idpConnTasklet = (IdpConnectionConfigTasklet)t;
            return SSOApplicationUrlUtil.displayIdpConnectionSsoURL((boolean)idpConnTasklet.isSpSSOSelected(), (boolean)idpConnTasklet.isConnectionProtocolOIDC(), (int)idpConnTasklet.getMappedToAdapterCount(), (int)idpConnTasklet.getMappedToC2cCount());
        }
        return true;
    }

    public String getSsoApplicationEndpoint() {
        Tasklet t = this.getParent();
        boolean isSpAuthnSelectionEnabled = MgmtFactory.getAuthnSelectionConfigManager().isEnableSpAuthnSelection();
        String nonCBPOAdapterId = null;
        String entityId = null;
        if (t instanceof IdpConnectionConfigTasklet) {
            List<IdpConfigAdapterMappingTasklet> mappedAdapters;
            IdpConnectionConfigTasklet idpConnTasklet = (IdpConnectionConfigTasklet)t;
            entityId = idpConnTasklet.getConnId();
            if (isSpAuthnSelectionEnabled && (mappedAdapters = idpConnTasklet.getAdapterTasklets()) != null && mappedAdapters.size() == 1) {
                nonCBPOAdapterId = mappedAdapters.get(0).getNonCBPOAdapterId();
            }
        } else if (t instanceof SpConnectionConfigTasklet) {
            entityId = ((SpConnectionConfigTasklet)t).getConnId();
        }
        String ssoUrl = SSOApplicationUrlUtil.getSSOUrl((boolean)(t instanceof IdpConnectionConfigTasklet), (boolean)(t instanceof SpConnectionConfigTasklet), (String)entityId, nonCBPOAdapterId);
        return ssoUrl;
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        Tasklet t = this.getParent();
        if (t instanceof ConnectionTasklet) {
            long end = System.currentTimeMillis();
            ConnectionTasklet connTasklet = (ConnectionTasklet)t;
            long start = connTasklet.getStartTime();
            if (start > -1L) {
                this.log.debug((Object)("Activation state for connection " + connTasklet.getConnId() + " activated in " + (end - start) + "ms"));
            }
            connTasklet.setStartTime(-1L);
        }
    }
}

