/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.DataMap;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.Adapter2AdapterMappingState;
import com.pingidentity.fsm.state.impl.Adapter2AdapterSummaryState;
import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.state.impl.Source2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.TargetApplicationInfoState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.impl.DependencyErrorManagementTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.List;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;
import org.sourceid.a2a.domain.mgmt.Source2TargetManager;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.AdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class Adapter2AdapterMappingTasklet
extends Source2TargetMappingTasklet<Direct2SpAdapterMapping> {
    private static final long serialVersionUID = 1L;
    private TargetApplicationInfoState targetApplInfoState;
    private Adapter2AdapterSummaryState adapter2AdapterSummaryState;

    public Adapter2AdapterMappingTasklet(Visit visit) {
        super("Adapter2AdapterMappingTasklet", "Mapping Configuration", visit);
    }

    @Override
    public void loadMapping(Direct2SpAdapterMapping mapping) {
        this.s2tMapping = mapping;
        AdapterManager adapterManager = MgmtFactory.getAdapterManager();
        this.sourceInstance = adapterManager.getIdpAuthnAdapterInstance(((Direct2SpAdapterMapping)this.s2tMapping).getSourceId());
        this.targetInstance = adapterManager.getSpAuthnAdapterInstance(((Direct2SpAdapterMapping)this.s2tMapping).getTargetId());
    }

    @Override
    public MappingState buildMappingFullfillmentState() {
        return new Adapter2AdapterMappingState(this, "mapping");
    }

    @Override
    public String getNoteKeySuffix() {
        return "A2A";
    }

    @Override
    public String getMappingSourceForDisplay() {
        return "Adapter";
    }

    @Override
    public void addStandardSourcesToPropertySelectionSources(DataMap.Sources sources) {
        ConfigurablePluginInstance sourceInstance = this.getSelectedPlugin();
        List srcNames = sourceInstance.getAttributeContract().getAllAttrNamesSorted();
        sources.addPropertySelectionSource("Adapter", new StringPairPropertySelectionModel(true, srcNames));
        StringPairPropertySelectionModel contextSelectionModel = new StringPairPropertySelectionModel(true);
        for (SourceContextType sct : SourceContextType.getContextTypesForA2A()) {
            contextSelectionModel.add(sct.getDescription(), sct.getId());
        }
        sources.addPropertySelectionSource("Context", contextSelectionModel);
    }

    @Override
    public Direct2SpAdapterMapping copyMapping(Direct2SpAdapterMapping mapping) {
        return new Direct2SpAdapterMapping(mapping);
    }

    @Override
    protected void createTransitions() {
        this.licenseGroupState.addOutgoingTransition(this, this.configAttributeSourcesState);
        this.targetApplInfoState = new TargetApplicationInfoState(this);
        this.configAttributeSourcesState.addOutgoingTransition(this, this.targetApplInfoState);
        this.targetApplInfoState.addOutgoingTransition(this, this.mappingFullfillmentState);
        this.mappingFullfillmentState.addOutgoingTransition(this, this.defaultTargetUrlState);
        this.defaultTargetUrlState.addOutgoingTransition(this, this.issuanceCriteriaState);
        this.adapter2AdapterSummaryState = new Adapter2AdapterSummaryState(this);
        this.issuanceCriteriaState.addOutgoingTransition(this, this.adapter2AdapterSummaryState);
    }

    @Override
    public Source2TargetManager<Direct2SpAdapterMapping> getSource2TargetManager() {
        return MgmtFactory.getAdapter2AdapterManager();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.adapter2AdapterSummaryState;
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public boolean isSaveAllAvailable() {
        return this.getParentTasklet() instanceof DependencyErrorManagementTasklet ? false : this.isModeEdit();
    }

    @Override
    public AffectedItemType getAffectedItemType() {
        return AffectedItemType.IDP_TO_SP_ADAPTER_MAPPING;
    }
}

