/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.AdminUserList;
import com.pingidentity.email.util.NotificationSupportHelper;
import com.pingidentity.fsm.state.impl.PasswordGenerationState;
import com.pingidentity.fsm.state.impl.UserMgmtState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.SingleStateTasklet;
import com.pingidentity.fsm.tasklet.impl.UserInfoTasklet;
import com.pingidentity.pingone.PingOneAdminService;
import com.pingidentity.sdk.notification.NotificationEventType;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.NotificationSenderPluginInstance;
import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationMgr;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserManagerImpl;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class AdministrativeAccountsState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private ArrayList<AdministrativeUser> users = null;
    private final ArrayList<String> resetPasswordUsers = new ArrayList();
    private transient Object componentState;
    private boolean notifyOfAccountChanges;
    private String selectedNotificationPublisher;
    private final transient AdminUserManager adminUserManager = AdminUserManagerImpl.getInstance();

    public AdministrativeAccountsState(Tasklet value) {
        super(value);
        this.setMenuName("Administrative Accounts");
    }

    @Override
    public boolean populateAllStates(Object data) {
        NotificationMgr notificationMgr = MgmtFactory.getNotificationMgr();
        NotificationSettings settings = notificationMgr.getNotificationSettings();
        this.notifyOfAccountChanges = settings.isEnableAccountChangesNotification();
        this.selectedNotificationPublisher = settings.getNotificationPublisherAccountChanges();
        return true;
    }

    @Override
    public boolean save(Object dataFromDisk) {
        for (AdministrativeUser user : this.getUsers()) {
            if (!user.isAuditor()) continue;
            user.setAdminManager(Boolean.FALSE.booleanValue());
            user.setAdmin(Boolean.FALSE.booleanValue());
            user.setCryptoManager(Boolean.FALSE.booleanValue());
            user.setExpressionAdmin(Boolean.FALSE.booleanValue());
            user.setDataCollectionAdmin(Boolean.FALSE.booleanValue());
        }
        Map<String, AdministrativeUser> oldUsers = this.getExistingUsers();
        Map<String, AdministrativeUser> adminUsers = this.getUpdatedUsers();
        AdministrativeUser currentUser = this.getVisit().getCurrentUser();
        NotificationMgr notificationMgr = MgmtFactory.getNotificationMgr();
        NotificationSettings settings = notificationMgr.getNotificationSettings();
        NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
        boolean originalNotifyOfAccountChanges = settings.isEnableAccountChangesNotification();
        String originalNotificationPublisher = settings.getNotificationPublisherAccountChanges();
        if (originalNotifyOfAccountChanges != this.notifyOfAccountChanges || StringUtils.isNotBlank((String)originalNotificationPublisher) && StringUtils.isBlank((String)this.selectedNotificationPublisher) || StringUtils.isBlank((String)originalNotificationPublisher) && StringUtils.isNotBlank((String)this.selectedNotificationPublisher) || StringUtils.isNotBlank((String)originalNotificationPublisher) && StringUtils.isNotBlank((String)this.selectedNotificationPublisher) && !Objects.equals(originalNotificationPublisher, this.selectedNotificationPublisher)) {
            settings.setNotificationPublisherAccountChanges(this.selectedNotificationPublisher);
            settings.setEnableAccountChangesNotification(this.notifyOfAccountChanges);
            notificationMgr.saveNotificationSettings(settings);
        }
        if (notificationSupportHelper.isNotifyFlagSwitchingOff(originalNotifyOfAccountChanges, settings.isEnableAccountChangesNotification())) {
            notificationSupportHelper.sendNotificationsChangeEmail(settings, currentUser, adminUsers, oldUsers, settings.getNotificationPublisherAccountChanges(), NotificationEventType.ADMIN_ACCOUNT_CHANGE_NOTIFICATION_OFF, new String[]{"Notify administrator of account changes"});
        }
        if (settings.isEnableAccountChangesNotification()) {
            for (Map.Entry<String, AdministrativeUser> updatedUserKeyEntry : adminUsers.entrySet()) {
                AdministrativeUser origUser;
                AdministrativeUser updatedUser = updatedUserKeyEntry.getValue();
                if (!(StringUtils.isBlank((String)updatedUser.getNewPassword()) || StringUtils.isBlank((String)updatedUser.getEmailAddress()) || currentUser.equals((Object)updatedUser))) {
                    notificationSupportHelper.sendPasswordChangeEmail(currentUser, updatedUser, settings);
                }
                if ((origUser = oldUsers.get(updatedUser.getUserName())) == null || !notificationSupportHelper.isUserEmailChanged(origUser, updatedUser) || !settings.isEnableAccountChangesNotification()) continue;
                notificationSupportHelper.sendEmailChangeEmail(currentUser, updatedUser, origUser, settings);
            }
        } else {
            settings.setNotificationPublisherAccountChanges("");
        }
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.adminUserManager.saveUsers(adminUsers.values());
            for (Map.Entry<String, AdministrativeUser> userEntry : adminUsers.entrySet()) {
                AdministrativeUser user;
                boolean newUser = false;
                AdministrativeUser oldUser = oldUsers.get(userEntry.getKey());
                if (oldUser == null) {
                    newUser = true;
                }
                if (this.resetPasswordUsers.contains((user = userEntry.getValue()).getUserName())) {
                    auditLoggerScope.log(AdminAuditLogger.Component.USER, AdminAuditLogger.Event.PASSWORD_RESET, user.getUserName());
                    this.resetPasswordUsers.remove(user.getUserName());
                }
                if (newUser) {
                    auditLoggerScope.log(AdminAuditLogger.Component.USER, AdminAuditLogger.Event.CREATE, user.getUserName());
                }
                if ((newUser || !oldUser.isActive()) && user.isActive()) {
                    auditLoggerScope.log(AdminAuditLogger.Component.USER, AdminAuditLogger.Event.ACTIVATE, user.getUserName());
                } else if ((newUser || oldUser.isActive()) && !user.isActive()) {
                    auditLoggerScope.log(AdminAuditLogger.Component.USER, AdminAuditLogger.Event.DEACTIVATE, user.getUserName());
                }
                if (newUser) continue;
                if (!(Objects.equals(oldUser.getDescription(), user.getDescription()) && Objects.equals(oldUser.getPhoneNumber(), user.getPhoneNumber()) && Objects.equals(oldUser.getDepartment(), user.getDepartment()))) {
                    auditLoggerScope.log(AdminAuditLogger.Component.USER, AdminAuditLogger.Event.MODIFY, user.getUserName());
                }
                if (oldUser.isAdmin() != user.isAdmin() || oldUser.isAdminManager() != user.isAdminManager() || oldUser.isCryptoManager() != user.isCryptoManager() || oldUser.isAuditor() != user.isAuditor() || oldUser.isExpressionAdmin() != user.isExpressionAdmin()) {
                    String message = user.getUserName() + " | " + oldUser.describeUser(true) + " | " + user.describeUser(true);
                    auditLoggerScope.log(AdminAuditLogger.Component.USER, AdminAuditLogger.Event.ROLE_CHANGE, message);
                }
                if (!notificationSupportHelper.isUserEmailChanged(oldUser, user)) continue;
                auditLoggerScope.log(AdminAuditLogger.Component.USER, AdminAuditLogger.Event.MODIFY, "Email change detected for administrator '" + oldUser.getUserName() + "'");
            }
        }
        return true;
    }

    @Override
    public void refreshState() {
        block3: {
            TaskletState state;
            block5: {
                block4: {
                    if (!(this.getTaskletToEdit() instanceof UserInfoTasklet)) break block4;
                    UserInfoTasklet userInfoTasklet = (UserInfoTasklet)this.getTaskletToEdit();
                    AdministrativeUser user = userInfoTasklet.getUserChanges();
                    for (int i = 0; i < this.getUsers().size(); ++i) {
                        AdministrativeUser tempUser = this.getUsers().get(i);
                        if (!tempUser.getUserName().equals(user.getUserName())) continue;
                        this.getUsers().remove(i);
                    }
                    this.getUsers().add(user);
                    break block3;
                }
                if (!(this.getTaskletToEdit() instanceof SingleStateTasklet)) break block3;
                SingleStateTasklet tasklet = (SingleStateTasklet)this.getTaskletToEdit();
                state = (TaskletState)tasklet.getCurrentState();
                if (!(state instanceof PasswordGenerationState)) break block5;
                PasswordGenerationState passwordGenerationState = (PasswordGenerationState)state;
                String userName = passwordGenerationState.getUserName();
                for (AdministrativeUser user : this.getUsers()) {
                    if (!userName.equals(user.getUserName())) continue;
                    user.setPassword(passwordGenerationState.getGeneratedPassword());
                    user.setNewPassword(passwordGenerationState.getGeneratedPassword());
                    user.setChangeRequired(true);
                    this.resetPasswordUsers.add(userName);
                    break block3;
                }
                break block3;
            }
            if (!(state instanceof UserMgmtState)) break block3;
            UserMgmtState userMgmtState = (UserMgmtState)state;
            String userName = userMgmtState.getUserName();
            for (AdministrativeUser user : this.getUsers()) {
                if (!userName.equals(user.getUserName())) continue;
                user.setPassword(userMgmtState.getNewPassword());
                user.setNewPassword(userMgmtState.getNewPassword());
                break;
            }
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        boolean atLeastOneAdminManager = false;
        for (AdministrativeUser user : this.getUsers()) {
            if (user.isAdminManager() && user.isActive()) {
                atLeastOneAdminManager = true;
            }
            if (!(!user.isActive() || user.isAuditor() || user.isAdminManager() || user.isAdmin() || user.isCryptoManager() || user.isExpressionAdmin())) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("One_role_required") + " (" + user.getUserName() + ")", ValidationConstraint.REQUIRED);
            }
            if (user.isExpressionAdmin() && !user.isAdmin()) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Ea_role_without_admin") + " (" + user.getUserName() + ")", ValidationConstraint.REQUIRED);
            }
            if (!user.isDataCollectionAdmin() || user.isAdmin() && user.isAdminManager() && user.isCryptoManager()) continue;
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Dca_role_without_required_roles") + " (" + user.getUserName() + ")", ValidationConstraint.REQUIRED);
        }
        if (!atLeastOneAdminManager && this.isRequireOneAdminManager()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("One_admin_manager_required"), ValidationConstraint.REQUIRED);
        }
        NotificationSenderPluginInstance notificationSenderPluginInstance = (NotificationSenderPluginInstance)MgmtFactory.getNotificationPublisherPluginManager().getDefaultInstance();
        if (this.notifyOfAccountChanges && StringUtils.isBlank((String)this.selectedNotificationPublisher) && notificationSenderPluginInstance == null) {
            this.validateNotificationPublisher(delegate);
        }
    }

    private void validateNotificationPublisher(IValidationDelegate delegate) {
        if (StringUtils.isBlank((String)this.selectedNotificationPublisher)) {
            delegate.record(this.getMessage("Notification_Publisher_required", new String[]{"Account Change Events"}), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        AdministrativeUser currentUser = this.getVisit().getCurrentUser();
        if (currentUser.isAdminManager()) {
            for (AdministrativeUser user : this.getUsers()) {
                if (!user.isActive()) continue;
                summaryList.add(new SummaryInfo(this.getMessage("Username"), user.describeUser(false).toString(), this));
            }
        } else {
            summaryList.add(new SummaryInfo(this.getMessage("Username"), currentUser.describeUser(false).toString(), this));
        }
        summaryList.add(new SummaryInfo(this.getMessage("Password_notification"), Boolean.toString(this.isNotifyOfAccountChanges()), this));
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.getParent().isPostInstallWizard()) {
            AdministrativeUser currentUser = this.getVisit().getCurrentUser();
            String userName = currentUser.getUserName();
            AdministrativeUser newCurrentUser = this.adminUserManager.getUser(userName);
            this.getVisit().setCurrentUser(newCurrentUser);
            for (AdministrativeUser user : this.getUsers()) {
                if (!userName.equals(user.getUserName())) continue;
                user.setSalt(newCurrentUser.getSalt());
                user.setHash(newCurrentUser.getHash());
                user.setChangeRequired(false);
                break;
            }
        }
        if (!this.displayNotificationPublisherButton()) {
            this.setTaskletToEditToNull();
        }
    }

    public boolean isRequireOneAdminManager() {
        return !this.isSsoEnabled();
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMenuName(), "", this, true));
        this.doSummary(summaryList);
    }

    public boolean displayNotificationPublisherButton() {
        return this.getVisit().getCurrentUser().isAdmin() && this.notifyOfAccountChanges;
    }

    public boolean isNotifyOfAccountChanges() {
        return this.notifyOfAccountChanges;
    }

    public void setNotifyOfAccountChanges(boolean notifyOfAccountChanges) {
        this.notifyOfAccountChanges = notifyOfAccountChanges;
    }

    public boolean displayAccountChangesCheckbox() {
        return this.getVisit().getCurrentUser().isAdminManager();
    }

    public ArrayList<AdministrativeUser> getUsers() {
        if (this.users == null) {
            Collection usersMap = this.adminUserManager.getUsers();
            this.users = new ArrayList(usersMap);
        }
        return this.users;
    }

    public Map<String, AdministrativeUser> getUpdatedUsers() {
        CaseInsensitiveMap adminUsers = new CaseInsensitiveMap(new HashMap());
        ArrayList<AdministrativeUser> users = this.getUsers();
        for (AdministrativeUser user : users) {
            adminUsers.put(user.getUserName(), user);
        }
        return adminUsers;
    }

    public void setUsers(ArrayList<AdministrativeUser> users) {
        this.users = users;
    }

    public AdministrativeUser getUser(String userToFind) {
        for (AdministrativeUser user : this.getUsers()) {
            if (!user.getUserName().equals(userToFind)) continue;
            return user;
        }
        return null;
    }

    private Map<String, AdministrativeUser> getExistingUsers() {
        CaseInsensitiveMap adminUsers = new CaseInsensitiveMap(new HashMap());
        Collection users = this.adminUserManager.getUsers();
        for (AdministrativeUser user : users) {
            adminUsers.put(user.getUserName(), user);
        }
        return adminUsers;
    }

    public boolean isShowCreateUsersButton() {
        return this.getVisit().getCurrentUser().isAdminManager();
    }

    @Override
    public String getNoteKey() {
        if (!this.getVisit().getCurrentUser().isAdminManager()) {
            return super.getNoteKey() + "_Non_admin_mgr_mode";
        }
        return super.getNoteKey();
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    protected boolean isSsoEnabled() {
        PingOneAdminService service = MgmtFactory.getPingOneAdminService();
        return service.isAssociated() && service.getSettings().isEnableAdminConsoleSso();
    }

    public String getSelectedNotificationPublisher() {
        return this.selectedNotificationPublisher;
    }

    public void setSelectedNotificationPublisher(String selectedNotificationPublisher) {
        this.selectedNotificationPublisher = selectedNotificationPublisher;
    }

    public StringPairPropertySelectionModel getNotificationPublishers() {
        StringPairPropertySelectionModel notificationPublisherModel = new StringPairPropertySelectionModel("Default");
        List<StringPairPropertySelectionModel.SPair> items = MgmtFactory.getNotificationPublisherPluginManager().getInstances().stream().map(sender -> new StringPairPropertySelectionModel.SPair(sender.getName(), sender.getId())).collect(Collectors.toList());
        notificationPublisherModel.addAll(items);
        notificationPublisherModel.sort();
        return notificationPublisherModel;
    }

    @Override
    public void reset() {
        super.reset();
        this.users = null;
        if (this.componentState instanceof AdminUserList.State) {
            AdminUserList.State state = (AdminUserList.State)this.componentState;
            state.reset();
        }
        this.populateAllStates(null);
    }
}

