/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.AdvancedJdbcDataStoreValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.JdbcDataSource;

public class AdvancedDataBaseOptionsState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String minPoolSize;
    private String maxPoolSize;
    private String blockingTimeout;
    private String idleTimeout;
    private String resetMinPoolSize;
    private String resetMaxPoolSize;
    private String resetBlockingTimeout;
    private String resetIdleTimeout;

    public AdvancedDataBaseOptionsState(Tasklet value) {
        super(value);
        this.setMenuName("Advanced Database Options");
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk != null) {
            JdbcDataSource jdbc = (JdbcDataSource)dataFromDisk;
            this.minPoolSize = Integer.toString(jdbc.getMinPoolSize());
            this.maxPoolSize = Integer.toString(jdbc.getMaxPoolSize());
            this.blockingTimeout = Integer.toString(jdbc.getBlockingTimeoutMillis());
            this.idleTimeout = Integer.toString(jdbc.getIdleTimeoutMinutes());
        } else {
            this.minPoolSize = String.valueOf(10);
            this.maxPoolSize = String.valueOf(100);
            this.blockingTimeout = String.valueOf(5000);
            this.idleTimeout = String.valueOf(5);
        }
        this.resetMinPoolSize = this.minPoolSize;
        this.resetMaxPoolSize = this.maxPoolSize;
        this.resetBlockingTimeout = this.blockingTimeout;
        this.resetIdleTimeout = this.idleTimeout;
    }

    @Override
    public boolean save(Object dataToDisk) {
        JdbcDataSource tempJdbc = (JdbcDataSource)dataToDisk;
        if (tempJdbc != null) {
            int minPool = Integer.parseInt(this.minPoolSize);
            int maxPool = Integer.parseInt(this.maxPoolSize);
            int blockingTimeoutMillis = Integer.parseInt(this.blockingTimeout);
            int idleTimeoutMinutes = Integer.parseInt(this.idleTimeout);
            tempJdbc.setMinPoolSize(minPool);
            tempJdbc.setMaxPoolSize(maxPool);
            tempJdbc.setBlockingTimeoutMillis(blockingTimeoutMillis);
            tempJdbc.setIdleTimeoutMinutes(idleTimeoutMinutes);
        }
        return true;
    }

    public void applyDefaults() {
        this.minPoolSize = String.valueOf(10);
        this.maxPoolSize = String.valueOf(100);
        this.blockingTimeout = String.valueOf(5000);
        this.idleTimeout = String.valueOf(5);
    }

    @Override
    public void reset() {
        this.minPoolSize = this.resetMinPoolSize;
        this.maxPoolSize = this.resetMaxPoolSize;
        this.blockingTimeout = this.resetBlockingTimeout;
        this.idleTimeout = this.resetIdleTimeout;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        AdvancedJdbcDataStoreValidator validator = new AdvancedJdbcDataStoreValidator.Builder().setMinPoolSize(this.minPoolSize).setMaxPoolSize(this.maxPoolSize).setBlockingTimeout(this.blockingTimeout).setIdleTimeout(this.idleTimeout).build();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Minimum_Pool_Size"), this.minPoolSize, this));
        summaryList.add(new SummaryInfo(this.getMessage("Maximum_Pool_Size"), this.maxPoolSize, this));
        summaryList.add(new SummaryInfo(this.getMessage("Blocking_Timeout"), this.blockingTimeout, this));
        summaryList.add(new SummaryInfo(this.getMessage("Idle_Timeout"), this.idleTimeout, this));
    }

    public String getBlockingTimeout() {
        return this.blockingTimeout;
    }

    public void setBlockingTimeout(String blockingTimeout) {
        this.blockingTimeout = blockingTimeout;
    }

    public String getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(String idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public String getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(String maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public String getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(String minPoolSize) {
        this.minPoolSize = minPoolSize;
    }
}

