/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.domain.LdapDataSource;

public class AdvancedLdapOptionsBinaryAttrsState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 20120601L;
    private List<String> binaryAttributes = new ArrayList<String>();
    private Object componentState;

    public AdvancedLdapOptionsBinaryAttrsState(IWizard owner, String cardName) {
        super(owner, "LDAP Binary Attributes");
    }

    public AdvancedLdapOptionsBinaryAttrsState(IWizard owner) {
        super(owner);
        this.setMenuName("LDAP Binary Attributes");
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.binaryAttributes != null) {
            for (String binaryAttribute : this.binaryAttributes) {
                summaryList.add(new SummaryInfo(this.getMessage("Binary_Attribute"), binaryAttribute, this));
            }
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        LdapDataSource ldap;
        super.populate(dataFromDisk);
        if (dataFromDisk != null && (ldap = (LdapDataSource)dataFromDisk).getBinaryAttributes() != null) {
            this.binaryAttributes = new ArrayList<String>(ldap.getBinaryAttributes());
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        LdapDataSource tempLdap = (LdapDataSource)dataToDisk;
        if (tempLdap != null) {
            tempLdap.setBinaryAttributes(this.binaryAttributes);
        }
        this.componentState = null;
        return true;
    }

    public List<String> getBinaryAttributes() {
        return this.binaryAttributes;
    }

    public void setBinaryAttributes(List<String> binaryAttributes) {
        this.binaryAttributes = binaryAttributes;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }
}

