/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.AdvancedLdapDataStoreValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.AdvancedLdapOptionsTasklet;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AdvancedLdapOptionsState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private boolean testOnBorrow;
    private boolean testOnReturn;
    private boolean createIfNecessary;
    private boolean retryFailedOperations;
    private String min;
    private String max;
    private String maxWait;
    private String timeBetweenEvictionRunsMillis;
    private String readTimeoutMillis;
    private String connTimeoutMillis;
    private boolean verifyHost;
    private String dnsTtlMillis;
    private String ldapDnsSrvPrefix;
    private String ldapsDnsSrvPrefix;

    public AdvancedLdapOptionsState(Tasklet value) {
        super(value);
        this.setMenuName("Advanced LDAP Options");
        this.applyDefaults();
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk != null) {
            LdapDataSource ldap = (LdapDataSource)dataFromDisk;
            this.setPoolOptions(ldap);
        }
    }

    private void setPoolOptions(LdapDataSource ldap) {
        this.testOnBorrow = ldap.isTestOnBorrow();
        this.testOnReturn = ldap.isTestOnReturn();
        this.createIfNecessary = ldap.isCreateIfNecessary();
        this.retryFailedOperations = ldap.isRetryFailedOperations();
        this.min = String.valueOf(ldap.getMin());
        this.max = String.valueOf(ldap.getMax());
        this.maxWait = String.valueOf(ldap.getMaxWait());
        this.timeBetweenEvictionRunsMillis = String.valueOf(ldap.getTimeBetweenEvictionRunsMillis());
        this.readTimeoutMillis = String.valueOf(ldap.getReadTimeoutMillis());
        this.connTimeoutMillis = String.valueOf(ldap.getConnTimeoutMillis());
        this.verifyHost = ldap.isVerifyHost();
        this.dnsTtlMillis = String.valueOf(ldap.getDnsTtlMillis());
        this.ldapDnsSrvPrefix = ldap.getLdapDnsSrvPrefix();
        this.ldapsDnsSrvPrefix = ldap.getLdapsDnsSrvPrefix();
    }

    @Override
    public boolean save(Object dataToDisk) {
        LdapDataSource tempLdap = (LdapDataSource)dataToDisk;
        if (tempLdap != null) {
            tempLdap.setTestOnBorrow(this.testOnBorrow);
            tempLdap.setTestOnReturn(this.testOnReturn);
            tempLdap.setCreateIfNecessary(this.createIfNecessary);
            tempLdap.setRetryFailedOperations(this.retryFailedOperations);
            tempLdap.setMin(Integer.parseInt(this.min));
            tempLdap.setMax(Integer.parseInt(this.max));
            tempLdap.setMaxWait(Integer.parseInt(this.maxWait));
            tempLdap.setTimeBetweenEvictionRunsMillis(Integer.parseInt(this.timeBetweenEvictionRunsMillis));
            tempLdap.setReadTimeoutMillis(Integer.parseInt(this.readTimeoutMillis));
            tempLdap.setConnTimeoutMillis(Integer.parseInt(this.connTimeoutMillis));
            tempLdap.setVerifyHost(this.verifyHost);
            tempLdap.setDnsTtlMillis(Integer.parseInt(this.dnsTtlMillis));
            tempLdap.setLdapDnsSrvPrefix(this.ldapDnsSrvPrefix);
            tempLdap.setLdapsDnsSrvPrefix(this.ldapsDnsSrvPrefix);
        }
        return true;
    }

    public void applyDefaults() {
        LdapDataSource ldap = MgmtFactory.getDataSourceManager().getDefaultLdapDataSourceSettings();
        ldap.setVerifyHost(true);
        this.setPoolOptions(ldap);
    }

    @Override
    public void reset() {
        this.applyDefaults();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        AdvancedLdapDataStoreValidator validator = new AdvancedLdapDataStoreValidator.Builder().setMinConnections(this.min).setMaxConnections(this.max).setMaxWait(this.maxWait).setTimeBetweenEvictions(this.timeBetweenEvictionRunsMillis).setReadTimeout(this.readTimeoutMillis).setConnectionTimeout(this.connTimeoutMillis).setDnsTtl(this.dnsTtlMillis).setLdapDnsSrvPrefix(this.ldapDnsSrvPrefix).setLdapsDnsSrvPrefix(this.ldapsDnsSrvPrefix).setBinaryAttributes(this.getBinaryAttributes()).build();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    private List<String> getBinaryAttributes() {
        return this.getParent(AdvancedLdapOptionsTasklet.class).getBinaryAttributes();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Retry_Failed_Operations"), Boolean.toString(this.retryFailedOperations), this));
        summaryList.add(new SummaryInfo(this.getMessage("Test_Connection_on_Borrow"), Boolean.toString(this.testOnBorrow), this));
        summaryList.add(new SummaryInfo(this.getMessage("Test_Connection_on_Return"), Boolean.toString(this.testOnReturn), this));
        summaryList.add(new SummaryInfo(this.getMessage("Create_New_Connections_if_Necessary"), Boolean.toString(this.createIfNecessary), this));
        summaryList.add(new SummaryInfo(this.getMessage("Verify_LDAPS_Hostname"), Boolean.toString(this.verifyHost), this));
        summaryList.add(new SummaryInfo(this.getMessage("Minimum_Connections"), this.min, this));
        summaryList.add(new SummaryInfo(this.getMessage("Maximum_Connections"), this.max, this));
        summaryList.add(new SummaryInfo(this.getMessage("Maximum_Wait"), this.maxWait, this));
        summaryList.add(new SummaryInfo(this.getMessage("Time_Between_Eviction"), this.timeBetweenEvictionRunsMillis, this));
        summaryList.add(new SummaryInfo(this.getMessage("Read_Timeout"), this.readTimeoutMillis, this));
        summaryList.add(new SummaryInfo(this.getMessage("Connection_Timeout"), this.connTimeoutMillis, this));
        summaryList.add(new SummaryInfo(this.getMessage("DNS_TTL"), this.dnsTtlMillis, this));
        summaryList.add(new SummaryInfo(this.getMessage("LDAP_DNS_SRV_Record_prefix"), this.ldapDnsSrvPrefix, this));
        summaryList.add(new SummaryInfo(this.getMessage("LDAPs_DNS_SRV_Record_prefix"), this.ldapsDnsSrvPrefix, this));
        for (String attr : this.getBinaryAttributes()) {
            summaryList.add(new SummaryInfo(this.getMessage("Binary_Attribute"), attr, this));
        }
    }

    public String getMin() {
        return this.min;
    }

    public void setMin(String min) {
        this.min = min;
    }

    public String getMax() {
        return this.max;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public String getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(String maxWait) {
        this.maxWait = maxWait;
    }

    public String getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(String timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public String getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public void setReadTimeoutMillis(String readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public String getConnTimeoutMillis() {
        return this.connTimeoutMillis;
    }

    public void setConnTimeoutMillis(String connTimeoutMillis) {
        this.connTimeoutMillis = connTimeoutMillis;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public boolean isCreateIfNecessary() {
        return this.createIfNecessary;
    }

    public void setCreateIfNecessary(boolean createIfNecessary) {
        this.createIfNecessary = createIfNecessary;
    }

    public boolean isRetryFailedOperations() {
        return this.retryFailedOperations;
    }

    public void setRetryFailedOperations(boolean retryFailedOperations) {
        this.retryFailedOperations = retryFailedOperations;
    }

    public boolean isVerifyHost() {
        return this.verifyHost;
    }

    public void setVerifyHost(boolean verifyHost) {
        this.verifyHost = verifyHost;
    }

    public String getDnsTtlMillis() {
        return this.dnsTtlMillis;
    }

    public void setDnsTtlMillis(String dnsTtlMillis) {
        this.dnsTtlMillis = dnsTtlMillis;
    }

    public String getLdapDnsSrvPrefix() {
        return this.ldapDnsSrvPrefix;
    }

    public void setLdapDnsSrvPrefix(String ldapDnsSrvPrefix) {
        this.ldapDnsSrvPrefix = ldapDnsSrvPrefix;
    }

    public String getLdapsDnsSrvPrefix() {
        return this.ldapsDnsSrvPrefix;
    }

    public void setLdapsDnsSrvPrefix(String ldapsDnsSrvPrefix) {
        this.ldapsDnsSrvPrefix = ldapsDnsSrvPrefix;
    }
}

