/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.IncomingBindingsValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.SamlProfilesApi;
import com.pingidentity.fsm.tasklet.api.WebSsoApi;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.MultiProtocolTasklet;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.metadata.Role;

public class AllowableSamlBindingsState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private boolean artifactBinding = true;
    private boolean postBinding = true;
    private boolean redirectBinding = true;
    private boolean soapBinding = true;

    public AllowableSamlBindingsState(Tasklet value) {
        super(value);
        this.setMenuName("Allowable SAML Bindings");
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase connection = (ConnectionBase)dataFromDisk;
        this.artifactBinding = connection.getIncomingBindings().getArtifactBinding();
        this.postBinding = connection.getIncomingBindings().getPostBinding();
        this.redirectBinding = connection.getIncomingBindings().getRedirectBinding();
        this.soapBinding = connection.getIncomingBindings().getSoapBinding();
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase tempConnection = (ConnectionBase)dataToDisk;
        tempConnection.getIncomingBindings().setArtifactBinding(this.artifactBinding);
        tempConnection.getIncomingBindings().setPostBinding(this.postBinding);
        tempConnection.getIncomingBindings().setRedirectBinding(this.redirectBinding);
        tempConnection.getIncomingBindings().setSoapBinding(this.soapBinding);
        return true;
    }

    @Override
    public void reset() {
        this.artifactBinding = true;
        this.postBinding = true;
        this.redirectBinding = true;
        this.soapBinding = true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        SamlProfilesApi spa = this.findParent(SamlProfilesApi.class);
        WebSsoApi wsa = this.findParent(WebSsoApi.class);
        IncomingBindingsValidator validator = new IncomingBindingsValidator(this.artifactBinding, this.postBinding, this.redirectBinding, this.soapBinding, this.isIdpConnection() ? Role.IDP : Role.SP, spa.isSomethingOtherThanIdpInitiatedSsoSelected(), wsa.isArtifactSsoSlo(), this.findParent(MultiProtocolTasklet.class).getProtocolType());
        validator.skipSaml1xValidation(true);
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    public boolean isArtifactBindingSelected() {
        return this.artifactBinding;
    }

    public boolean isPostOrRedirectSelected() {
        return this.postBinding || this.redirectBinding;
    }

    public boolean isSoapBindingSelected() {
        return this.soapBinding;
    }

    public boolean isAnyBindingSelected() {
        return this.artifactBinding || this.postBinding || this.redirectBinding || this.soapBinding;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Artifact", String.valueOf(this.artifactBinding), this));
        summaryList.add(new SummaryInfo("POST", String.valueOf(this.postBinding), this));
        if (this.showRedirectChoice()) {
            summaryList.add(new SummaryInfo("Redirect", new Boolean(this.redirectBinding).toString(), this));
        }
        if (this.showSoapChoice()) {
            summaryList.add(new SummaryInfo("SOAP", new Boolean(this.soapBinding).toString(), this));
        }
    }

    public boolean isIdpConnection() {
        ConnectionTasklet parent = this.findParent(ConnectionTasklet.class);
        return parent.getConnectionType() == ConnectionType.IDP;
    }

    public boolean showRedirectChoice() {
        SamlProfilesApi spa;
        if (this.isIdpConnection() && (!(spa = this.findParent(SamlProfilesApi.class)).isSomethingOtherThanIdpInitiatedSsoSelected() || this.isConnectionProtocol1x())) {
            this.redirectBinding = false;
            return false;
        }
        return true;
    }

    public boolean showSoapChoice() {
        if (this.isIdpConnection()) {
            SamlProfilesApi spa = this.findParent(SamlProfilesApi.class);
            if (this.isConnectionProtocol1x() || this.isConnectionProtocol20() && spa.onlyIdpSsoSelected()) {
                this.soapBinding = false;
                return false;
            }
        }
        return true;
    }

    public boolean isConnectionProtocol1x() {
        return this.findParent(MultiProtocolTasklet.class).isConnectionProtocol1x();
    }

    public boolean isConnectionProtocol20() {
        return this.findParent(MultiProtocolTasklet.class).isConnectionProtocol20();
    }

    public boolean isArtifactBinding() {
        return this.artifactBinding;
    }

    public void setArtifactBinding(boolean artifactBinding) {
        this.artifactBinding = artifactBinding;
    }

    public boolean isPostBinding() {
        return this.postBinding;
    }

    public void setPostBinding(boolean postBinding) {
        this.postBinding = postBinding;
    }

    public boolean isRedirectBinding() {
        return this.redirectBinding;
    }

    public void setRedirectBinding(boolean redirectBinding) {
        this.redirectBinding = redirectBinding;
    }

    public boolean isSoapBinding() {
        return this.soapBinding;
    }

    public void setSoapBinding(boolean soapBinding) {
        this.soapBinding = soapBinding;
    }
}

