/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.Adapter2AdapterMappingState;
import com.pingidentity.fsm.state.impl.Apc2SpAdapterMappingsState;
import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.state.impl.Source2TargetMappingTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.List;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;
import org.sourceid.a2a.domain.mgmt.Source2TargetManager;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.AdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class Apc2SpAdapterMappingTasklet
extends Source2TargetMappingTasklet<Direct2SpAdapterMapping> {
    private static final long serialVersionUID = 1L;

    public Apc2SpAdapterMappingTasklet(Visit visit) {
        super("Apc2SpAdapterMappingTasklet", "Mapping Configuration", visit);
    }

    @Override
    public Source2TargetManager<Direct2SpAdapterMapping> getSource2TargetManager() {
        return MgmtFactory.getApc2SpAdapterManager();
    }

    @Override
    public void loadMapping(Direct2SpAdapterMapping mapping) {
        this.s2tMapping = mapping;
        AdapterManager adapterManager = MgmtFactory.getAdapterManager();
        C2cContractManager apcManager = MgmtFactory.getC2cContractManager();
        C2cContract apc = apcManager.getContract(((Direct2SpAdapterMapping)this.s2tMapping).getSourceId());
        this.sourceInstance = Apc2SpAdapterMappingsState.buildDummySourcePlugin(apc);
        this.targetInstance = adapterManager.getSpAuthnAdapterInstance(((Direct2SpAdapterMapping)this.s2tMapping).getTargetId());
    }

    @Override
    public MappingState buildMappingFullfillmentState() {
        return new Adapter2AdapterMappingState(this, "mapping");
    }

    @Override
    public String getNoteKeySuffix() {
        return "Apc2SpA";
    }

    @Override
    public String getMappingSourceForDisplay() {
        return "Authentication Policy Contract";
    }

    @Override
    public void addStandardSourcesToPropertySelectionSources(DataMap.Sources sources) {
        ConfigurablePluginInstance sourceInstance = this.getSelectedPlugin();
        List srcNames = sourceInstance.getAttributeContract().getAllAttrNamesSorted();
        sources.addPropertySelectionSource("Authentication Policy Contract", new StringPairPropertySelectionModel(true, srcNames));
        StringPairPropertySelectionModel contextSelectionModel = new StringPairPropertySelectionModel(true);
        for (SourceContextType sct : SourceContextType.getContextTypesForApc2SpAdapter()) {
            contextSelectionModel.add(sct.getDescription(), sct.getId());
        }
        sources.addPropertySelectionSource("Context", contextSelectionModel);
    }

    @Override
    public Direct2SpAdapterMapping copyMapping(Direct2SpAdapterMapping mapping) {
        return new Direct2SpAdapterMapping(mapping);
    }

    @Override
    protected void createTransitions() {
        this.licenseGroupState.addOutgoingTransition(this, this.configAttributeSourcesState);
        this.configAttributeSourcesState.addOutgoingTransition(this, this.mappingFullfillmentState);
        this.mappingFullfillmentState.addOutgoingTransition(this, this.defaultTargetUrlState);
        this.defaultTargetUrlState.addOutgoingTransition(this, this.issuanceCriteriaState);
        this.issuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
    }

    @Override
    public AffectedItemType getAffectedItemType() {
        return AffectedItemType.APC2SPA;
    }
}

