/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.ArtifactItem;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.util.SortUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.IndexedEndpoints;

public class ArtifactConfigState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private static final Integer UNSIGNED_SHORT = 65535;
    private String url;
    private String endpointIndex;
    private String urlToAdd;
    private String endpointIndexToAdd;
    private int lastIndex = -1;
    private List<ArtifactItem> artifactList = new ArrayList<ArtifactItem>();

    public ArtifactConfigState(Tasklet value) {
        super(value);
        this.setMenuName("Artifact Resolver Locations");
    }

    @Override
    public boolean populateAllStates(Object data) {
        ConnectionBase tempConnection = (ConnectionBase)data;
        this.makeArtifactList(tempConnection);
        return true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase connection = (ConnectionBase)dataFromDisk;
        this.makeArtifactList(connection);
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase tempConnection = (ConnectionBase)dataToDisk;
        IndexedEndpoints endpoints = new IndexedEndpoints();
        for (ArtifactItem artifactItem : this.artifactList) {
            Endpoint endpoint = new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:SOAP", artifactItem.getUrl());
            endpoints.setEndpoint(Integer.parseInt(artifactItem.getIndex()), endpoint);
        }
        tempConnection.setArtifactResolutionServices(endpoints);
        return true;
    }

    @Override
    public void cancel(Object newData) {
        this.cancelEdit();
        super.cancel(newData);
    }

    @Override
    public void reset() {
        this.url = null;
        this.endpointIndex = null;
        this.urlToAdd = null;
        this.endpointIndexToAdd = null;
        this.lastIndex = -1;
        this.artifactList.clear();
    }

    public void addArtifact() {
        String string = this.endpointIndexToAdd = StringUtils.isBlank((String)this.endpointIndexToAdd) ? this.incrementIndex() : this.endpointIndexToAdd;
        if (this.validate(this.urlToAdd, this.endpointIndexToAdd, true)) {
            ArtifactItem newItem = new ArtifactItem(this.urlToAdd);
            newItem.setIndex(this.endpointIndexToAdd);
            this.add(newItem);
        }
    }

    public void deleteArtifact(int index) {
        this.artifactList.remove(index);
    }

    public void editArtifact(int index, String artifactToEdit, String artifactIndex) {
        this.url = artifactToEdit;
        this.endpointIndex = artifactIndex;
        this.lastIndex = index;
        ArtifactItem item = this.artifactList.get(index);
        item.setArtifactToEdit(true);
    }

    private boolean validate(String testUrl, String testEndpointIndex, boolean testProtocolConsistency) {
        this.delegate.clearErrors();
        if (StringUtils.isBlank((String)testUrl)) {
            this.delegate.record(this.getMessage("Url_required"), ValidationConstraint.REQUIRED);
        }
        if (!this.delegate.getHasErrors() && !this.isValidIndex(testEndpointIndex)) {
            this.delegate.record(this.getMessage("Index_gte_0_lte_65535"), ValidationConstraint.NUMBER_FORMAT);
        }
        if (!this.delegate.getHasErrors()) {
            if (!ValidationUtil.isValidHttpOrHttpsUrl((String)testUrl)) {
                if (this.isBaseUrlConfigured()) {
                    if (!ValidationUtil.startsWithForwardSlash((String)testUrl)) {
                        this.delegate.record(this.getMessage("Endpoint_base_url_malformed"), ValidationConstraint.URL_FORMAT);
                    }
                } else {
                    this.delegate.record(this.getMessage("Common", "Malformed_url"), ValidationConstraint.URL_FORMAT);
                }
            }
            if (testProtocolConsistency && !this.isProtocolConsistent(testUrl)) {
                this.delegate.setFormComponent(null);
                this.delegate.record(this.getMessage("Common", "Protocols_must_match"), ValidationConstraint.REQUIRED);
            }
        }
        if (!this.delegate.getHasErrors() && this.isDuplicate(testEndpointIndex)) {
            this.delegate.record(this.getMessage("Duplicate_index"), ValidationConstraint.REQUIRED);
        }
        return !this.delegate.getHasErrors();
    }

    public void updateArtifact() {
        String string = this.endpointIndex = StringUtils.isBlank((String)this.endpointIndex) ? this.incrementIndex() : this.endpointIndex;
        if (this.validate(this.url, this.endpointIndex, false)) {
            ArtifactItem item = this.artifactList.get(this.lastIndex);
            item.setUrl(this.url);
            item.setIndex(this.endpointIndex);
            item.setArtifactToEdit(false);
            this.artifactList = SortUtil.copyAndSort(this.artifactList);
            this.lastIndex = -1;
        }
    }

    public void cancelEdit() {
        if (this.lastIndex > -1) {
            ArtifactItem item = this.artifactList.get(this.lastIndex);
            item.setArtifactToEdit(false);
            this.lastIndex = -1;
        }
    }

    private boolean isDuplicate(String testIndex) {
        List<ArtifactItem> list = this.artifactList;
        for (int i = 0; i < list.size(); ++i) {
            ArtifactItem temp = list.get(i);
            if (!temp.getIndex().equals(testIndex) || i == this.lastIndex) continue;
            return true;
        }
        return false;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.artifactList.isEmpty()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Indexed_endpoint_required"), ValidationConstraint.REQUIRED);
        }
        if (this.lastIndex != -1) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Update_required"), ValidationConstraint.REQUIRED);
        }
        if (this.anyRelativeUrls()) {
            if (!StringUtils.isBlank((String)this.getBaseUrlString())) {
                if (!this.isProtocolConsistent(this.getBaseUrlString())) {
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("Common", "Protocols_must_match"), ValidationConstraint.REQUIRED);
                }
            } else {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Common", "Protocols_must_match"), ValidationConstraint.REQUIRED);
            }
        } else if (!this.isProtocolConsistent(null)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Common", "Protocols_must_match"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.artifactList != null) {
            for (ArtifactItem item : this.artifactList) {
                summaryList.add(new SummaryInfo("Artifact Resolution Endpoint", "index = " + item.getIndex() + ", " + item.getUrl(), this));
            }
        } else {
            summaryList.add(new SummaryInfo("Artifact Resolution Endpoint", "None", this));
        }
    }

    private boolean isValidIndex(String index) {
        try {
            Integer newIndex = Integer.valueOf(index);
            return newIndex >= 0 && newIndex <= UNSIGNED_SHORT;
        }
        catch (NumberFormatException n) {
            return false;
        }
    }

    private void add(ArtifactItem newItem) {
        this.artifactList.add(newItem);
        this.artifactList = SortUtil.copyAndSort(this.artifactList);
        this.setUrlToAdd(null);
        this.setEndpointIndexToAdd(null);
    }

    private String incrementIndex() {
        Integer largestInt = 0;
        for (ArtifactItem item : this.artifactList) {
            Integer temp = Integer.valueOf(item.getIndex());
            if (temp <= largestInt) continue;
            largestInt = temp;
        }
        if (this.artifactList.size() > 0) {
            Integer n = largestInt;
            Integer n2 = largestInt = Integer.valueOf(largestInt + 1);
        }
        if (largestInt > 65535) {
            return "";
        }
        return largestInt.toString();
    }

    private boolean isBaseUrlConfigured() {
        ConnectionTasklet c = this.getConnectionTasklet();
        return c != null ? c.isBaseUrlConfigured() : false;
    }

    private String getBaseUrlString() {
        ConnectionTasklet c = this.getConnectionTasklet();
        return c != null ? c.getBaseUrlString() : new String();
    }

    private ConnectionTasklet getConnectionTasklet() {
        Tasklet t = this.findParent(ConnectionTasklet.class);
        return t != null && t instanceof ConnectionTasklet ? (ConnectionTasklet)t : null;
    }

    private List<URL> artifactItemToUrlList(List<ArtifactItem> artifacts) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ArtifactItem item : artifacts) {
            Object temp = null;
            temp = ValidationUtil.startsWithForwardSlash((String)item.getUrl()) && this.isBaseUrlConfigured() ? this.getBaseUrlString() + item.getUrl() : item.getUrl();
            urls.add(this.stringToUrl((String)temp));
        }
        return urls;
    }

    private URL stringToUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private boolean isProtocolConsistent(String testUrl) {
        List<URL> artifactListUrlList = this.artifactItemToUrlList(this.artifactList);
        if (ValidationUtil.startsWithForwardSlash((String)testUrl) && this.isBaseUrlConfigured()) {
            testUrl = this.getBaseUrlString() + (String)testUrl;
        }
        return ValidationUtil.isUrlProtocolConsistentWithList(artifactListUrlList, (URL)this.stringToUrl((String)testUrl));
    }

    private boolean anyRelativeUrls() {
        for (URL endpoint : this.artifactItemToUrlList(this.artifactList)) {
            if (endpoint != null) continue;
            return true;
        }
        return false;
    }

    public String getClassType() {
        return this.lastIndex == -1 ? "plain" : "disabled";
    }

    public String getEndpointIndex() {
        return this.endpointIndex;
    }

    public void setEndpointIndex(String endpointIndex) {
        this.endpointIndex = endpointIndex;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = StringUtils.stripToEmpty((String)url);
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public void setLastIndex(int lastIndex) {
        this.lastIndex = lastIndex;
    }

    public String getEndpointIndexToAdd() {
        return this.endpointIndexToAdd;
    }

    public void setEndpointIndexToAdd(String endpointIndexToAdd) {
        this.endpointIndexToAdd = endpointIndexToAdd;
    }

    public String getUrlToAdd() {
        return this.urlToAdd;
    }

    public void setUrlToAdd(String urlToAdd) {
        this.urlToAdd = StringUtils.stripToEmpty((String)urlToAdd);
    }

    public List<ArtifactItem> getArtifactList() {
        return this.artifactList;
    }

    public List<ArtifactItem> getArtifactListCopy() {
        List<ArtifactItem> artifactListCopy = this.artifactList.stream().collect(Collectors.toList());
        return artifactListCopy;
    }

    public void setArtifactList(List<ArtifactItem> artifactList) {
        this.artifactList = artifactList;
    }

    private void makeArtifactList(ConnectionBase connection) {
        IndexedEndpoints artifactResolutionServices = connection.getArtifactResolutionServices();
        if (artifactResolutionServices != null) {
            Map endpointMap = artifactResolutionServices.getEndpointsMap();
            Iterator iter = endpointMap.keySet().iterator();
            ArrayList<ArtifactItem> list = new ArrayList<ArtifactItem>();
            while (iter.hasNext()) {
                Integer key = (Integer)iter.next();
                Endpoint endpoint = (Endpoint)endpointMap.get(key);
                ArtifactItem newItem = new ArtifactItem(endpoint.getLocation());
                newItem.setIndex(key.toString());
                list.add(newItem);
            }
            this.artifactList = list;
        }
    }

    public boolean anyEndpointNotUsingHttps() {
        for (ArtifactItem item : this.artifactList) {
            String itemURL = item.getUrl().toLowerCase();
            if (itemURL.startsWith("https")) continue;
            if (this.isBaseUrlConfigured()) {
                if (this.getBaseUrlString().toLowerCase().startsWith("https")) continue;
                return true;
            }
            return true;
        }
        return false;
    }
}

