/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.ArtifactItem;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.xmlbeans.impl.util.HexBin;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.Protocol;

public class ArtifactResolverLocationState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private String endpoint;
    private String sourceId;
    private byte[] sourceIdOnDisk;
    private String connectionIdOnPopulate;

    public ArtifactResolverLocationState(Tasklet parent) {
        super(parent);
        this.setMenuName("Artifact Resolution Location");
    }

    @Override
    public void initialize() {
        this.initializeData(this.getParent().getPopulateData());
    }

    @Override
    public boolean populateAllStates(Object dataFromDisk) {
        this.initializeData(dataFromDisk);
        return true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.initializeData(dataFromDisk);
    }

    private void initializeData(Object initializeData) {
        ConnectionBase connection = (ConnectionBase)initializeData;
        IndexedEndpoints artifactResolutionServices = connection.getArtifactResolutionServices();
        Endpoint arsEndpoint = artifactResolutionServices.getFirstEndpoint();
        this.endpoint = arsEndpoint == null ? "" : arsEndpoint.getLocation();
        this.sourceId = connection.getSourceIdString();
        this.sourceIdOnDisk = connection.getSourceIdOnDisk();
        this.connectionIdOnPopulate = connection.getEntityId();
    }

    @Override
    public boolean save(Object dataToSave) {
        ConnectionBase tempConnection = (ConnectionBase)dataToSave;
        IndexedEndpoints endpoints = new IndexedEndpoints();
        Endpoint newEndpoint = new Endpoint("urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", this.endpoint);
        endpoints.setEndpoint(0, newEndpoint);
        tempConnection.setArtifactResolutionServices(endpoints);
        tempConnection.setSourceIdString(this.sourceId);
        tempConnection.setSourceIdOnDisk(this.sourceIdOnDisk);
        return true;
    }

    @Override
    public void reset() {
        this.endpoint = "";
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        StringBuilder sb = new StringBuilder();
        sb.append("URL: ").append(this.endpoint);
        summaryList.add(new SummaryInfo(this.getMessage("Endpoint"), sb.toString(), this));
        summaryList.add(new SummaryInfo(this.getMessage("source_id_desc"), this.sourceId, this));
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isBlank((String)this.endpoint)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Endpoint_required"), ValidationConstraint.REQUIRED);
        } else if (!ValidationUtil.isValidHttpOrHttpsUrl((String)this.endpoint)) {
            if (this.isBaseUrlConfigured()) {
                if (!ValidationUtil.startsWithForwardSlash((String)this.endpoint)) {
                    delegate.record(this.getMessage("Endpoint_base_url_malformed"), ValidationConstraint.URL_FORMAT);
                }
                if (!this.findParent(ConnectionTasklet.class).getBaseUrlString().toLowerCase().startsWith("https")) {
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("Base_url_must_be_https"), ValidationConstraint.REQUIRED);
                }
            } else {
                delegate.record(this.getMessage("Malformed_url"), ValidationConstraint.URL_FORMAT);
            }
        } else if (!this.endpoint.toLowerCase().startsWith("https")) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Endpoint_must_be_https"), ValidationConstraint.REQUIRED);
        }
        if (!StringUtils.isBlank((String)this.sourceId)) {
            String connectionId;
            if (HexBin.stringToBytes((String)this.sourceId) == null) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Format_invalid"), ValidationConstraint.REQUIRED);
            }
            if (this.sourceId.length() != 40) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Length_invalid"), ValidationConstraint.REQUIRED);
            }
            String string = connectionId = this.connectionIdOnPopulate != null ? this.connectionIdOnPopulate : this.findParent(ConnectionTasklet.class).getConnId();
            if (MgmtFactory.getConnectionManager().isSourceIdInUse(this.sourceId, connectionId, new Protocol[]{Protocol.SAML11, Protocol.SAML10})) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Duplicate_source_id"), ValidationConstraint.REQUIRED);
            }
        }
    }

    private boolean isBaseUrlConfigured() {
        return this.findParent(ConnectionTasklet.class).isBaseUrlConfigured();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = StringUtils.stripToEmpty((String)endpoint);
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = StringUtils.stripToEmpty((String)sourceId);
    }

    public List<ArtifactItem> getArtifactList() {
        ArrayList<ArtifactItem> list = new ArrayList<ArtifactItem>();
        ArtifactItem newItem = new ArtifactItem(this.endpoint);
        newItem.setIndex("0");
        list.add(newItem);
        return list;
    }

    public boolean anyEndpointNotUsingHttps() {
        boolean isEndpointNotUsingHttps = false;
        isEndpointNotUsingHttps = this.isBaseUrlConfigured() ? !this.findParent(ConnectionTasklet.class).getBaseUrlString().toLowerCase().startsWith("https") : !this.endpoint.toLowerCase().startsWith("https");
        return isEndpointNotUsingHttps;
    }
}

