/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.CreateAdapterContractState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.PluginInstanceApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class AtmContractState
extends CreateAdapterContractState {
    private static final long serialVersionUID = 20130225L;
    private String defaultSubjectAttribute;
    private transient Object componentState;
    private Set<String> multiValuedList = new HashSet<String>();

    public AtmContractState(Tasklet value) {
        super(value);
        this.setMenuName("Access Token Attribute Contract");
    }

    @Override
    public Object getComponentState() {
        return this.componentState;
    }

    @Override
    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    @Override
    public void populate(Object dataFromDisk) {
        super.populate(dataFromDisk);
        this.setComponentState(null);
        if (dataFromDisk != null) {
            BearerAccessTokenMgmtPluginInstance pluginInstance = (BearerAccessTokenMgmtPluginInstance)dataFromDisk;
            this.defaultSubjectAttribute = pluginInstance.findEffectiveDefaultSubjectAttribute();
            this.multiValuedList = pluginInstance.getMultiValuedContractAttributes();
        }
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        if (this.isInheritingContract()) {
            this.loadParentAtmContractSettings();
        }
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.isInheritingContract()) {
            this.componentState = null;
            this.loadParentAtmContractSettings();
        }
    }

    private void loadParentAtmContractSettings() {
        PluginInstanceApi parentTasklet = this.getParent(PluginInstanceApi.class);
        PluginManager<?, ?> pluginMgr = parentTasklet.getPluginManager();
        BearerAccessTokenMgmtPluginInstance parentInstance = (BearerAccessTokenMgmtPluginInstance)pluginMgr.getInstance(this.getParentInstanceId());
        this.defaultSubjectAttribute = parentInstance.getDefaultSubjectAttribute();
        this.multiValuedList = parentInstance.getMultiValuedContractAttributes().stream().collect(Collectors.toSet());
    }

    @Override
    public boolean save(Object dataToDisk) {
        BearerAccessTokenMgmtPluginInstance pluginInstance = (BearerAccessTokenMgmtPluginInstance)dataToDisk;
        if (this.isInheritingContract() || "USER_KEY".equals(this.defaultSubjectAttribute)) {
            pluginInstance.setDefaultSubjectAttribute(null);
        } else {
            pluginInstance.setDefaultSubjectAttribute(this.defaultSubjectAttribute);
        }
        pluginInstance.setMultiValuedContractAttributes(this.multiValuedList);
        super.save(pluginInstance);
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        for (String item : this.contract.getSortedImmutableAttributeNames()) {
            summaryList.add(new SummaryInfo("Attribute", item, this));
        }
        for (String item : this.contract.getSortedMutableAttributeNames()) {
            summaryList.add(new SummaryInfo("Attribute", (String)(this.multiValuedList.contains(item) ? item + " (Multi-Valued Selected)" : item), this));
        }
        summaryList.add(new SummaryInfo("Default Subject Attribute", StringUtils.isNotBlank((String)this.defaultSubjectAttribute) ? this.defaultSubjectAttribute : "USER_KEY", this));
    }

    public String getDefaultSubjectAttribute() {
        return this.defaultSubjectAttribute;
    }

    public void setDefaultSubjectAttribute(String defaultSubjectAttribute) {
        if (defaultSubjectAttribute != null) {
            this.defaultSubjectAttribute = defaultSubjectAttribute;
        }
    }

    public void resetDefaultSubjectAttribute() {
        this.defaultSubjectAttribute = null;
    }

    public Set<String> getMultiValuedList() {
        return this.multiValuedList;
    }

    public void setMultiValuedList(Set<String> multiValuedList) {
        this.multiValuedList = multiValuedList;
    }
}

