/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.PluginInstanceApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import com.pingidentity.util.ScopeSelectionModalUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.TokenEndpointAttributeContract;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class AtmTokenEndpointContractState
extends TaskletState {
    private static final long serialVersionUID = 20130225L;
    private BearerAccessTokenMgmtPluginInstance adapterInstance;
    private String currentContractItem;
    private boolean isInheritingContract = false;
    private TokenEndpointAttributeContract contract = new TokenEndpointAttributeContract();
    private TokenEndpointAttributeContract parentContract = new TokenEndpointAttributeContract();
    private transient Object componentState;
    private transient Consumer<String> currentContractItemSetter = value -> this.setCurrentContractItem((String)value);
    protected String extendedContractLabel;
    private String oldParentId = null;
    private boolean isDisplayingForFirstTime = true;

    public AtmTokenEndpointContractState(Tasklet value2) {
        super(value2);
        this.setMenuName("Token Endpoint Attribute Contract");
        this.setExtendedContractLabel("Extend the Contract");
    }

    @Override
    public void onStateActivated() {
        boolean addingParent;
        PluginInstanceTasklet parentTasklet = this.getParent(PluginInstanceTasklet.class);
        boolean hasParent = this.hasParentInstance();
        String parentId = this.getParentInstanceId();
        boolean removingParent = !hasParent && this.oldParentId != null;
        boolean bl = addingParent = hasParent && this.oldParentId == null;
        if (hasParent) {
            this.initParentContract();
        }
        if (removingParent || hasParent) {
            if (removingParent) {
                this.parentContract = null;
                this.isInheritingContract = false;
            } else if (addingParent) {
                if (parentTasklet.isNewTasklet() && this.isDisplayingForFirstTime) {
                    this.isInheritingContract = true;
                    this.isDisplayingForFirstTime = false;
                } else {
                    this.isInheritingContract = false;
                }
            }
        }
        this.oldParentId = parentId;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.isInheritingContract) {
            this.initParentContract();
        }
        if (StringUtils.isNotBlank((String)cycle.getRequestContext().getParameter("selectedScopes"))) {
            this.getContract().getMappedScopes().put(this.currentContractItem, new HashSet());
            ScopeSelectionModalUtil.setScopesForModal(cycle.getRequestContext(), ((Set)this.getContract().getMappedScopes().get(this.currentContractItem))::addAll, null);
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.setComponentState(null);
        if (dataFromDisk != null) {
            this.adapterInstance = (BearerAccessTokenMgmtPluginInstance)dataFromDisk;
            this.oldParentId = this.adapterInstance.getParentId();
            this.contract = this.copyContract(this.adapterInstance.getTokenEndpointAttributeContract());
            this.isInheritingContract = this.adapterInstance.isInheritTokenEndpointAttributeContract() && this.hasParentInstance();
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        BearerAccessTokenMgmtPluginInstance tempAdapterInstance = (BearerAccessTokenMgmtPluginInstance)dataToDisk;
        if (this.isInheritingContract) {
            tempAdapterInstance.setTokenEndpointAttributeContract(new TokenEndpointAttributeContract());
        } else {
            tempAdapterInstance.setTokenEndpointAttributeContract(this.contract);
        }
        tempAdapterInstance.setInheritTokenEndpointAttributeContract(this.isInheritingContract);
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        for (String item : this.contract.getSortedMutableAttributeNames()) {
            StringJoiner joiner = new StringJoiner(", ");
            if (this.contract.getMultiValued().contains(item)) {
                joiner.add("Multi-Valued Selected");
            }
            if (!this.contract.getMappedScopes().getOrDefault(item, Collections.emptySet()).isEmpty()) {
                joiner.add("Scopes Mapped");
            }
            String result = item + (String)(joiner.length() > 0 ? " (" + joiner + ")" : "");
            summaryList.add(new SummaryInfo("Attribute", result.toString(), this));
        }
    }

    private void initParentContract() {
        PluginInstanceApi parentTasklet = this.getParent(PluginInstanceApi.class);
        PluginManager<?, ?> pluginMgr = parentTasklet.getPluginManager();
        BearerAccessTokenMgmtPluginInstance parentInstance = (BearerAccessTokenMgmtPluginInstance)pluginMgr.getInstance(this.getParentInstanceId());
        this.parentContract = this.copyContract(parentInstance.findEffectiveTokenEndpointAttributeContract());
    }

    public boolean hasParentInstance() {
        return this.getParent(PluginInstanceApi.class).getParentPluginInstanceId() != null;
    }

    public String getParentInstanceId() {
        return this.getParent(PluginInstanceApi.class).getParentPluginInstanceId();
    }

    public TokenEndpointAttributeContract getContract() {
        return this.contract;
    }

    public void setContract(TokenEndpointAttributeContract contract) {
        this.contract = contract;
    }

    public TokenEndpointAttributeContract getParentContract() {
        return this.parentContract;
    }

    public void setParentContract(TokenEndpointAttributeContract parentContract) {
        this.parentContract = parentContract;
    }

    public Consumer<String> getCurrentContractItemSetter() {
        return this.currentContractItemSetter;
    }

    public void setCurrentContractItemSetter(Consumer<String> currentContractItemSetter) {
        this.currentContractItemSetter = currentContractItemSetter;
    }

    public String getCurrentContractItem() {
        return this.currentContractItem;
    }

    public void setCurrentContractItem(String currentContractItem) {
        this.currentContractItem = currentContractItem;
    }

    public boolean isInheritingContract() {
        return this.isInheritingContract;
    }

    public void setInheritingContract(boolean inheritingContract) {
        this.isInheritingContract = inheritingContract;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public String getExtendedContractLabel() {
        return this.extendedContractLabel;
    }

    public void setExtendedContractLabel(String extendedContractLabel) {
        this.extendedContractLabel = extendedContractLabel;
    }

    private TokenEndpointAttributeContract copyContract(TokenEndpointAttributeContract source) {
        TokenEndpointAttributeContract copyOfContract = new TokenEndpointAttributeContract();
        copyOfContract.setMutableAttributeNames(new HashSet(source.getMutableAttributeNames()));
        copyOfContract.setMultiValued(new HashSet(source.getMultiValued()));
        copyOfContract.setMappedScopes(new HashMap(source.getMappedScopes()));
        return copyOfContract;
    }
}

