/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import org.sourceid.saml20.domain.AttributeRequester;

public class AttrReqSecurityPolicyState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private boolean signResponse;
    private boolean signAssertion;
    private boolean encryptAssertion;
    private boolean requireSignedAttributeQuery;
    private boolean requireEncryptedNameId;
    private boolean disableXmlEncryption;

    public AttrReqSecurityPolicyState(Tasklet value) {
        super(value);
        this.setMenuName("Security Policy");
    }

    @Override
    public void populate(Object dataFromDisk) {
        AttributeRequester attributeRequester = (AttributeRequester)dataFromDisk;
        this.signResponse = attributeRequester.isSignResponse();
        this.signAssertion = attributeRequester.isSignAssertion();
        this.encryptAssertion = attributeRequester.isEncryptAssertion();
        this.requireSignedAttributeQuery = attributeRequester.isRequireSignedAttributeQuery();
        this.requireEncryptedNameId = attributeRequester.isRequireEncryptedNameId();
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populate(data);
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeRequester tempAttributeRequester = (AttributeRequester)dataToDisk;
        tempAttributeRequester.setSignResponse(this.signResponse);
        tempAttributeRequester.setSignAssertion(this.signAssertion);
        tempAttributeRequester.setEncryptAssertion(this.encryptAssertion);
        tempAttributeRequester.setRequireSignedAttributeQuery(this.requireSignedAttributeQuery);
        tempAttributeRequester.setRequireEncryptedNameId(this.requireEncryptedNameId);
        return true;
    }

    @Override
    public void reset() {
        this.signResponse = false;
        this.signAssertion = false;
        this.encryptAssertion = false;
        this.requireSignedAttributeQuery = false;
        this.requireEncryptedNameId = false;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Sign_response"), Boolean.toString(this.signResponse), this));
        summaryList.add(new SummaryInfo(this.getMessage("Sign_assertion"), Boolean.toString(this.signAssertion), this));
        summaryList.add(new SummaryInfo(this.getMessage("Encrypt_assertion"), Boolean.toString(this.encryptAssertion), this));
        summaryList.add(new SummaryInfo(this.getMessage("Require_signed_attribute_query"), Boolean.toString(this.requireSignedAttributeQuery), this));
        summaryList.add(new SummaryInfo(this.getMessage("Require_encrypted_name_id"), Boolean.toString(this.requireEncryptedNameId), this));
    }

    public boolean isEncryptAssertion() {
        return this.encryptAssertion;
    }

    public void setEncryptAssertion(boolean encryptAssertion) {
        this.encryptAssertion = encryptAssertion;
    }

    public boolean isRequireEncryptedNameId() {
        return this.requireEncryptedNameId;
    }

    public void setRequireEncryptedNameId(boolean requireEncryptedNameId) {
        this.requireEncryptedNameId = requireEncryptedNameId;
    }

    public boolean isRequireSignedAttributeQuery() {
        return this.requireSignedAttributeQuery;
    }

    public void setRequireSignedAttributeQuery(boolean requireSignedAttributeQuery) {
        this.requireSignedAttributeQuery = requireSignedAttributeQuery;
    }

    public boolean isSignAssertion() {
        return this.signAssertion;
    }

    public void setSignAssertion(boolean signAssertion) {
        this.signAssertion = signAssertion;
    }

    public boolean isSignResponse() {
        return this.signResponse;
    }

    public void setSignResponse(boolean signResponse) {
        this.signResponse = signResponse;
    }

    public boolean disableXmlEncryption() {
        return this.disableXmlEncryption;
    }

    public void setDisableXmlEncryption(boolean disableXmlEncryption) {
        this.disableXmlEncryption = disableXmlEncryption;
    }
}

