/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.CheckboxModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DNtoIdPMappings;
import org.sourceid.saml20.domain.DNtoIdpMap;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.DNtoIdPMappingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.Protocol;

public class AttributeRequesterMappingState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private DNtoIdPMappings idpMappings;
    private CheckboxModel issuerCbModel;
    private CheckboxModel subjectCbModel;
    private StringPairPropertySelectionModel connectionListModel;
    private ConnectionManager connManager = MgmtFactory.getConnectionManager();

    public AttributeRequesterMappingState(Tasklet parent) {
        super(parent);
        this.setMenuName("Attribute Requester Mapping");
        this.issuerCbModel = new CheckboxModel();
        this.subjectCbModel = new CheckboxModel();
    }

    @Override
    public void populate(Object dataFromDisk) {
        DNtoIdPMappingsManager idpMappingsMgr = MgmtFactory.getDNtoIdPMappingsManager();
        this.idpMappings = idpMappingsMgr.get(false);
        this.issuerCbModel.add("reset", false, true);
        this.subjectCbModel.add("reset", false, true);
        this.connectionListModel = new StringPairPropertySelectionModel(false);
        for (ConnectionBase connectionBase : this.getConnections()) {
            this.connectionListModel.add(connectionBase.getName(), connectionBase.getEntityId());
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        DNtoIdPMappingsManager idpMappingsMgr = MgmtFactory.getDNtoIdPMappingsManager();
        idpMappingsMgr.save(this.idpMappings);
        return true;
    }

    @Override
    public void reset() {
        this.populate(null);
    }

    private Collection<IdpConnection> getConnections() {
        ArrayList<IdpConnection> conns = new ArrayList<IdpConnection>();
        for (IdpConnection conn : this.connManager.getFilteredSamlIdpConnections()) {
            if (conn.getProtocol() != Protocol.SAML20 || conn.getAttributeAuthority() == null || !conn.isActive()) continue;
            conns.add(conn);
        }
        Collections.sort(conns, ConnectionBase.COMPARE_BY_ENTITY_ID);
        return conns;
    }

    public StringPairPropertySelectionModel getConnectionListModel() {
        return this.connectionListModel;
    }

    public List<DNtoIdpMap> getIssuerList() {
        return this.idpMappings.getIssuerDNMapList();
    }

    public void setIssuerList(List<DNtoIdpMap> newList) {
        this.idpMappings.setIssuerDNMapList(newList);
    }

    public List<DNtoIdpMap> getSubjectList() {
        return this.idpMappings.getSubjectDNMapList();
    }

    public void setSubjectList(List<DNtoIdpMap> newList) {
        this.idpMappings.setSubjectDNMapList(newList);
    }

    public String getDefaultIdp() {
        return this.idpMappings.getDefaultIdp();
    }

    public void setDefaultIdp(String defaultIdp) {
        this.idpMappings.setDefaultIdp(defaultIdp);
    }

    public CheckboxModel getIssuerCbModel() {
        return this.issuerCbModel;
    }

    public void setIssuerCbModel(CheckboxModel issuerCbModel) {
        this.issuerCbModel = issuerCbModel;
    }

    public CheckboxModel getSubjectCbModel() {
        return this.subjectCbModel;
    }

    public void setSubjectCbModel(CheckboxModel subjectCbModel) {
        this.subjectCbModel = subjectCbModel;
    }
}

