/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;

public class AttributeSourceApiTaskletListState
extends TaskletListState {
    private static final long serialVersionUID = 2L;
    private boolean requireOne = true;

    public AttributeSourceApiTaskletListState(IWizard owner) {
        super(owner);
    }

    public void setRequireOne(boolean requireOne) {
        this.requireOne = requireOne;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.requireOne && !this.doesOneExist()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("One_required"), ValidationConstraint.REQUIRED);
        } else {
            this.removeDeletedTasklets();
            for (Tasklet tasklet : this.getTasklets()) {
                tasklet.appendErrors(delegate, component, fastFail);
            }
        }
    }

    protected void removeDeletedTasklets() {
        List<Tasklet> taskletsToRemove = this.getTaskletsToRemove();
        List<Tasklet> tasklets = this.getTasklets();
        for (Tasklet t : taskletsToRemove) {
            if (!tasklets.contains(t)) continue;
            tasklets.remove(t);
        }
    }

    protected List<Tasklet> getTaskletsToRemove() {
        List<Tasklet> tasklets = this.getTasklets();
        ArrayList<Tasklet> taskletsToRemove = new ArrayList<Tasklet>();
        for (Tasklet t : tasklets) {
            if (t.isDraft() || !t.isItDeleted()) continue;
            taskletsToRemove.add(t);
        }
        return taskletsToRemove;
    }

    public Tasklet getTaskletFromList(String identifier) {
        for (Tasklet tasklet : this.getTasklets()) {
            AttributeSourceApi t = (AttributeSourceApi)((Object)tasklet);
            if (!t.getDescription().equals(identifier)) continue;
            tasklet.initialize();
            return tasklet;
        }
        return null;
    }

    public boolean hasMapping(String desc) {
        for (Tasklet tasklet : this.getTasklets()) {
            AttributeSourceApi t = (AttributeSourceApi)((Object)tasklet);
            if (!t.getDescription().equals(desc)) continue;
            return true;
        }
        return false;
    }

    public void delete(String mappingToDelete) {
        for (Tasklet tasklet : this.getTasklets()) {
            AttributeSourceApi t = (AttributeSourceApi)((Object)tasklet);
            if (!t.getDescription().equals(mappingToDelete)) continue;
            tasklet.setItDeleted(true);
            return;
        }
    }

    public void undelete(String mappingToDelete) {
        for (Tasklet tasklet : this.getTasklets()) {
            AttributeSourceApi t = (AttributeSourceApi)((Object)tasklet);
            if (!t.getDescription().equals(mappingToDelete)) continue;
            tasklet.setItDeleted(false);
            return;
        }
    }

    @Override
    public void cancel(Object newData) {
        if (!this.isViewOnly()) {
            for (Tasklet t : this.getTasklets()) {
                t.setItDeleted(false);
            }
            super.cancel(newData);
        }
    }

    private boolean doesOneExist() {
        for (Tasklet t : this.getTasklets()) {
            if (t.isItDeleted()) continue;
            return true;
        }
        return false;
    }
}

