/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.AuthenticationApiApplicationSettingsValidator;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.AuthnApiApplicationItem;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.AuthenticationApplicationTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.AuthnApiSettings;
import org.sourceid.saml20.domain.mgmt.AuthnApiManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;

public class AuthenticationApplicationsState
extends TaskletListState {
    private static final long serialVersionUID = 6L;
    private boolean onStateActivated;
    private boolean sortApplicationNameUp;
    private static final AuthnApiManager authnApiManager = MgmtFactory.getAuthnApiManager();
    private AuthnApiSettings settings;
    private boolean enableApiDescriptions = true;
    private String defaultApplicationId;
    private List<AuthnApiApplicationItem> authnAppItemsList;
    private StringPairPropertySelectionModel authnApiApplicationList;
    private boolean enableAuthnApi;
    private boolean restrictAccessToRedirectlessMode;
    private boolean includeRequestContext;

    public List<AuthnApiApplicationItem> getAuthnApps() {
        return this.authnAppItemsList;
    }

    @Override
    public void reset() {
        this.authnAppItemsList = new ArrayList<AuthnApiApplicationItem>();
    }

    public AuthenticationApplicationsState(IWizard owner, String cardName) {
        super(owner, cardName);
        this.setMenuName("Authentication API Applications");
    }

    public AuthenticationApplicationsState(IWizard owner) {
        super(owner);
        this.setMenuName("Authentication API Applications");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.settings = MgmtFactory.getAuthnApiManager().getSettings();
        this.enableAuthnApi = this.settings.isApiEnabled();
        this.defaultApplicationId = this.settings.getDefaultApplicationId();
        this.enableApiDescriptions = this.settings.isEnableApiDescriptions() == null ? Boolean.TRUE.booleanValue() : this.settings.isEnableApiDescriptions().booleanValue();
        this.restrictAccessToRedirectlessMode = this.settings.isRestrictAccessToRedirectlessMode();
        this.includeRequestContext = this.settings.isIncludeRequestContext();
        this.deleteAllTasklets();
        Collection authenticationApiApplications = MgmtFactory.getAuthnApiManager().getApiApplications();
        for (AuthnApiApplication apiApplication : authenticationApiApplications) {
            AuthenticationApplicationTasklet authenticationApplicationTasklet = this.createTasklet(AuthenticationApplicationTasklet.class);
            authenticationApplicationTasklet.setMode(Mode.edit);
            authenticationApplicationTasklet.populate(apiApplication);
            this.addTasklet(authenticationApplicationTasklet);
        }
        this.createAuthnApiApplicationsList();
        this.sortAndFilter();
    }

    @Override
    public boolean save(Object dataToDisk) {
        this.settings.setApiEnabled(this.enableAuthnApi);
        this.settings.setEnableApiDescriptions(Boolean.valueOf(this.enableApiDescriptions));
        this.settings.setDefaultApplicationId(this.defaultApplicationId);
        this.settings.setRestrictAccessToRedirectlessMode(this.restrictAccessToRedirectlessMode);
        this.settings.setIncludeRequestContext(this.includeRequestContext);
        authnApiManager.saveSettings(this.settings);
        return true;
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
    }

    private List<AuthnApiApplication> getApplications() {
        return this.getTasklets().stream().filter(t -> !t.isItDeleted()).map(t -> ((AuthenticationApplicationTasklet)t).getApplication()).collect(Collectors.toList());
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        AuthenticationApiApplicationSettingsValidator settingsValidator = new AuthenticationApiApplicationSettingsValidator(this.getDefaultApplication());
        settingsValidator.validate();
        this.recordErrors(settingsValidator.getErrors(), delegate);
    }

    public void delete(String policyToDelete) {
        for (Tasklet tasklet : this.getTasklets()) {
            AuthenticationApplicationTasklet t = (AuthenticationApplicationTasklet)tasklet;
            if (!StringUtils.equals((String)t.getApplicationId(), (String)policyToDelete)) continue;
            t.setItDeleted(true);
            authnApiManager.deleteApiApplication(t.getApplicationId());
            return;
        }
    }

    public Tasklet getTaskletFromList(String policyId) {
        for (Tasklet tasklet : this.getTasklets()) {
            AuthenticationApplicationTasklet t = (AuthenticationApplicationTasklet)tasklet;
            if (!StringUtils.equals((String)t.getApplicationId(), (String)policyId)) continue;
            return tasklet;
        }
        return null;
    }

    @Override
    public void onStateActivated() {
        this.onStateActivated = true;
    }

    public boolean isOnStateActivated() {
        return this.onStateActivated;
    }

    public void setOnStateActivated(boolean onStateActivated) {
        this.onStateActivated = onStateActivated;
    }

    public void setDefaultApplication(String defaultApplicationId) {
        this.defaultApplicationId = defaultApplicationId;
    }

    public String getDefaultApplication() {
        return this.defaultApplicationId;
    }

    public boolean isApplicationInUse(String appId) {
        return InUseDetectionUtil.getInstance().isAuthnApiApplicationUsed(appId, this.defaultApplicationId);
    }

    public void setSortApplicationNameUp(boolean sortClientNameUp) {
        this.sortApplicationNameUp = sortClientNameUp;
    }

    public boolean isSortApplicationNameUp() {
        return this.sortApplicationNameUp;
    }

    public List<AuthnApiApplicationItem> sortAndFilter() {
        Comparator<AuthnApiApplicationItem> comparator = Comparator.comparing(i -> i.getApplication().getName());
        if (this.sortApplicationNameUp) {
            comparator = comparator.reversed();
        }
        this.authnAppItemsList = this.getTasklets().stream().map(t -> {
            AuthnApiApplication application = ((AuthenticationApplicationTasklet)t).getApplication();
            return new AuthnApiApplicationItem(application, application.getId().equals(this.defaultApplicationId), t.isItDeleted(), this.isApplicationInUse(application.getId()));
        }).sorted(comparator).collect(Collectors.toList());
        return this.authnAppItemsList;
    }

    public boolean isEnableAuthnApi() {
        return this.enableAuthnApi;
    }

    public void setEnableAuthnApi(boolean authnApiEnabled) {
        this.enableAuthnApi = authnApiEnabled;
    }

    public boolean isEnableApiDescriptions() {
        return this.enableApiDescriptions;
    }

    public void setEnableApiDescriptions(boolean enableApiDescriptions) {
        this.enableApiDescriptions = enableApiDescriptions;
    }

    public boolean isRestrictAccessToRedirectlessMode() {
        return this.restrictAccessToRedirectlessMode;
    }

    public void setRestrictAccessToRedirectlessMode(boolean restrictAccessToRedirectlessMode) {
        this.restrictAccessToRedirectlessMode = restrictAccessToRedirectlessMode;
    }

    public boolean isIncludeRequestContext() {
        return this.includeRequestContext;
    }

    public void setIncludeRequestContext(boolean includeRequestContext) {
        this.includeRequestContext = includeRequestContext;
    }

    public void createAuthnApiApplicationsList() {
        this.authnApiApplicationList = new StringPairPropertySelectionModel(true);
        for (AuthnApiApplication instance : this.getApplications()) {
            this.authnApiApplicationList.add(instance.getName(), instance.getId());
        }
    }

    public StringPairPropertySelectionModel getAuthnApiApplicationList() {
        this.createAuthnApiApplicationsList();
        return this.authnApiApplicationList;
    }

    public void setAuthnApiApplicationList(StringPairPropertySelectionModel authnApiApplicationList) {
        this.authnApiApplicationList = authnApiApplicationList;
    }
}

