/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.sessions.SessionQuotaPaths;
import com.pingidentity.admin.api.validator.ApplicationSessionPolicyValidator;
import com.pingidentity.admin.api.validator.AuthenticationSessionPolicyValidator;
import com.pingidentity.admin.api.validator.GlobalAuthenticationSessionPolicyValidator;
import com.pingidentity.admin.api.validator.SessionRevocationLifetimeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.sessions.SessionQuotaValidator;
import com.pingidentity.component.common.FieldItem;
import com.pingidentity.component.common.SelectedOption;
import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableEditor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.pf.common.api.ApiMessageEnum;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.session.quotas.SessionQuotaBehavior;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.domain.ApplicationSessionPolicy;
import org.sourceid.saml20.domain.AuthnSessionPolicy;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.GlobalAuthnSessionPolicy;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SessionTimeUnit;
import org.sourceid.saml20.domain.UserDeviceType;
import org.sourceid.saml20.domain.mgmt.AuthnSessionPolicyManager;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.sessions.QuotaPolicy;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.state.SessionSettings;
import org.sourceid.saml20.state.SessionSettingsManager;

public class AuthenticationSessionPoliciesConfigurationState
extends TaskletState
implements TableEditor.TableEditorListener {
    private static final long serialVersionUID = 1L;
    private boolean enableSessions;
    private boolean persistentSessions;
    private boolean hashUniqueUserKeyAttribute;
    private boolean enableSessionQuotas;
    private String quotaBehavior;
    private String activeSessionLimit;
    private String maxTimeout;
    private String maxTimeoutDisplayUnit;
    private String idleTimeout;
    private String idleTimeoutDisplayUnit;
    private final StringPairPropertySelectionModel timeoutDisplayUnitSelectionModel = new StringPairPropertySelectionModel(false);
    private final StringPairPropertySelectionModel userDeviceTypeSelectionModel = new StringPairPropertySelectionModel(false);
    private final StringPairPropertySelectionModel quotaBehaviorSelectionModel = new StringPairPropertySelectionModel(false);
    private String applicationMaxTimeout;
    private String applicationIdleTimeout;
    private boolean trackAdapterSessionsForLogout;
    private boolean trackRevokedSessionsOnLogout;
    private String sessionRevocationLifetimeMins;
    private List<TableRow> policylist = new ArrayList<TableRow>();
    private transient Object componentState;
    private boolean isSpEnabled = false;
    private boolean isIdpEnabled = false;
    private final transient IdpAdapterManager idpAdapterManager = MgmtFactory.getIdpAdapterManager();
    private final transient ConnectionManager connManager = MgmtFactory.getConnectionManager();
    private final SimpleFieldDescriptor ADAPTER_CONN_NAME = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.SELECTION_FILTER_LIST, "Authentication Source", 200);
    private final SimpleFieldDescriptor ENABLE_SESSIONS = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.CHECKBOX, "Enable Sessions", 100, false, true);
    private final SimpleFieldDescriptor PERSISTENT = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.CHECKBOX, "Persistent", 100, false, false);
    private final SimpleFieldDescriptor USER_DEVICE_TYPE = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.DROPDOWN, "User Device Type", 100);
    private final SimpleFieldDescriptor OVERRIDE_TIMEOUTS = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.CHECKBOX, "Override Timeouts", 100, false, true);
    private final SimpleFieldDescriptor IDLE_TIMEOUT = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Idle Timeout", 100);
    private final SimpleFieldDescriptor MAX_TIMEOUT = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Max Timeout", 100);
    private final SimpleFieldDescriptor TIMEOUT_DISPLAY_UNIT = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.DROPDOWN, "Units", 100);
    private final SimpleFieldDescriptor AUTHN_CONTEXT_SENSITIVE = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.CHECKBOX, "Authentication Context Sensitive", 100);
    private final SimpleFieldDescriptor ID_DESCRIPTOR = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "id", 100){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isHidden() {
            return true;
        }
    };
    private final transient AuthnSessionPolicyManager sessionPolicyMgr = MgmtFactory.getAuthnSessionPolicyManager();
    private final transient SessionSettingsManager sessionSettingsMgr = MgmtFactory.getSessionSettingsManager();
    private List<SimpleFieldDescriptor> POLICYLIST_COLUMN_DESCRIPTORS;
    TreeMap<String, String> adapterMap;
    TreeMap<String, String> connMap;
    private Map<String, AuthnSourceKey.AuthnSourceType> typeMap = new HashMap<String, AuthnSourceKey.AuthnSourceType>();
    private static final int searchableFilterListIndex = 0;
    private static final int checkboxListIndex = 2;
    private int MIN_TIMEOUT_MINS = 1;
    private int MAX_TIMEOUT_DAYS = MgmtFactory.getAuthnSessionPolicyManager().getTimeoutCapDays();
    private int MAX_TIMEOUT_MINS = this.MAX_TIMEOUT_DAYS * 24 * 60;

    public AuthenticationSessionPoliciesConfigurationState(Tasklet value) {
        super(value);
        this.setMenuName("Sessions");
        this.isIdpEnabled = MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableIdP();
        this.isSpEnabled = MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableSP();
        this.adapterMap = this.getSortedAdapterModelNameIds();
        this.connMap = this.getSortedConnModelNameIds();
        this.ADAPTER_CONN_NAME.setModelValues(this.getAllNameModelValues());
        this.PERSISTENT.setEnabled(false);
        this.USER_DEVICE_TYPE.setEnabled(false);
        this.USER_DEVICE_TYPE.setModelValues(this.userDeviceTypeSelectionModel);
        this.USER_DEVICE_TYPE.setInitialValue(UserDeviceType.PRIVATE.name());
        this.IDLE_TIMEOUT.setEnabled(false);
        this.MAX_TIMEOUT.setEnabled(false);
        this.TIMEOUT_DISPLAY_UNIT.setEnabled(false);
        this.TIMEOUT_DISPLAY_UNIT.setModelValues(this.timeoutDisplayUnitSelectionModel);
        this.TIMEOUT_DISPLAY_UNIT.setInitialValue(SessionTimeUnit.MINUTES.name());
        this.OVERRIDE_TIMEOUTS.setEnabled(false);
        this.AUTHN_CONTEXT_SENSITIVE.setEnabled(false);
        this.timeoutDisplayUnitSelectionModel.add(SessionTimeUnit.MINUTES.getDisplayName(), SessionTimeUnit.MINUTES.name());
        this.timeoutDisplayUnitSelectionModel.add(SessionTimeUnit.HOURS.getDisplayName(), SessionTimeUnit.HOURS.name());
        this.timeoutDisplayUnitSelectionModel.add(SessionTimeUnit.DAYS.getDisplayName(), SessionTimeUnit.DAYS.name());
        this.userDeviceTypeSelectionModel.add(UserDeviceType.PRIVATE.getDisplayName(), UserDeviceType.PRIVATE.name());
        this.userDeviceTypeSelectionModel.add(UserDeviceType.SHARED.getDisplayName(), UserDeviceType.SHARED.name());
        this.userDeviceTypeSelectionModel.add(UserDeviceType.ANY.getDisplayName(), UserDeviceType.ANY.name());
        this.quotaBehaviorSelectionModel.add(SessionQuotaBehavior.DENY_ACCESS.getDisplayName(), SessionQuotaBehavior.DENY_ACCESS.name());
        this.quotaBehaviorSelectionModel.add(SessionQuotaBehavior.DESTROY_IDLEST_SESSION.getDisplayName(), SessionQuotaBehavior.DESTROY_IDLEST_SESSION.name());
        this.quotaBehaviorSelectionModel.add(SessionQuotaBehavior.DESTROY_OLD_SESSIONS.getDisplayName(), SessionQuotaBehavior.DESTROY_OLD_SESSIONS.name());
        this.quotaBehavior = QuotaPolicy.DEFAULT_QUOTA_LIMIT_BEHAVIOR.name();
        this.activeSessionLimit = QuotaPolicy.DEFAULT_ACTIVE_SESSION_LIMIT.toString();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.policylist.clear();
        this.typeMap.clear();
        GlobalAuthnSessionPolicy globalPolicy = this.sessionPolicyMgr.getGlobalPolicy();
        this.enableSessions = globalPolicy.isEnableSessions();
        this.persistentSessions = globalPolicy.isPersistentSessions();
        this.hashUniqueUserKeyAttribute = globalPolicy.isHashUniqueUserKeyAttribute();
        this.maxTimeout = this.getTimeoutStringForUI(globalPolicy.getMaxTimeoutMins(), globalPolicy.getMaxTimeoutDisplayUnit());
        this.maxTimeoutDisplayUnit = globalPolicy.getMaxTimeoutDisplayUnit().name();
        this.idleTimeout = this.getTimeoutStringForUI(globalPolicy.getIdleTimeoutMins(), globalPolicy.getIdleTimeoutDisplayUnit());
        this.idleTimeoutDisplayUnit = globalPolicy.getIdleTimeoutDisplayUnit().name();
        ApplicationSessionPolicy applicationPolicy = this.sessionPolicyMgr.getApplicationPolicy();
        this.applicationMaxTimeout = this.getTimeoutStringForUI(applicationPolicy.getMaxTimeoutMins(), SessionTimeUnit.MINUTES);
        this.applicationIdleTimeout = this.getTimeoutStringForUI(applicationPolicy.getIdleTimeoutMins(), SessionTimeUnit.MINUTES);
        SessionSettings sessionSettings = this.sessionSettingsMgr.getSessionSettings();
        this.trackAdapterSessionsForLogout = sessionSettings.isTrackAdapterSessionsForLogout();
        this.trackRevokedSessionsOnLogout = sessionSettings.isRevokeUserSessionOnLogout();
        this.sessionRevocationLifetimeMins = Integer.toString(sessionSettings.getSessionRevocationLifetime());
        QuotaPolicy quotaPolicy = this.sessionPolicyMgr.getQuotaPolicy();
        this.enableSessionQuotas = quotaPolicy.isEnableSessionQuotas();
        if (this.enableSessionQuotas) {
            this.activeSessionLimit = Integer.toString(quotaPolicy.getActiveSessionLimit());
            this.quotaBehavior = quotaPolicy.getQuotaLimitBehavior() != null ? quotaPolicy.getQuotaLimitBehavior().name() : QuotaPolicy.DEFAULT_QUOTA_LIMIT_BEHAVIOR.name();
        }
        this.adapterMap = this.getSortedAdapterModelNameIds();
        this.connMap = this.getSortedConnModelNameIds();
        Collection policies = this.sessionPolicyMgr.getEnabledSourcePolicies();
        for (AuthnSessionPolicy policy : policies) {
            this.policylist.add(this.makeRowFromEntry(policy, globalPolicy));
        }
        this.buildActionModel();
    }

    protected TableRow makeRowFromEntry(AuthnSessionPolicy entry, GlobalAuthnSessionPolicy globalPolicy) {
        FieldItem authnSourceField;
        ArrayList<FieldItem> fields = new ArrayList<FieldItem>();
        if (AuthnSourceKey.AuthnSourceType.IDP_CONN == entry.getAuthnSourceType()) {
            ConnectionManager connManager = MgmtFactory.getConnectionManager();
            IdpConnection conn = connManager.getIdpConnectionBySystemId(entry.getAuthnSourceId());
            authnSourceField = new FieldItem(this.ADAPTER_CONN_NAME, conn.getEntityId());
            String typeAndId = new SelectedOption(FilterableSelectionFieldDescriptor.SearchableType.IDP_CONNECTION, conn.getEntityId()).toString();
            authnSourceField.setDisplayName(conn.getName());
            authnSourceField.setTypeAndId(typeAndId);
        } else {
            String typeAndId = new SelectedOption(FilterableSelectionFieldDescriptor.SearchableType.IDP_ADAPTER, entry.getAuthnSourceId()).toString();
            authnSourceField = new FieldItem(this.ADAPTER_CONN_NAME, entry.getAuthnSourceId());
            String name = ((IdpAuthnAdapterInstance)this.idpAdapterManager.getInstance(entry.getAuthnSourceId())).getName();
            authnSourceField.setDisplayName(name);
            authnSourceField.setTypeAndId(typeAndId);
        }
        fields.add(authnSourceField);
        fields.add(new FieldItem(this.ENABLE_SESSIONS, Boolean.toString(entry.isEnableSessions())));
        fields.add(new FieldItem(this.USER_DEVICE_TYPE, entry.getUserDeviceType().name()));
        fields.add(new FieldItem(this.PERSISTENT, Boolean.toString(entry.isPersistent())));
        fields.add(new FieldItem(this.OVERRIDE_TIMEOUTS, entry.getIdleTimeoutMins() != null || entry.getMaxTimeoutMins() != null ? Boolean.TRUE.toString() : Boolean.FALSE.toString()));
        fields.add(new FieldItem(this.IDLE_TIMEOUT, this.getTimeoutStringForUI(entry.getIdleTimeoutMins(), entry.getTimeoutDisplayUnit())));
        fields.add(new FieldItem(this.MAX_TIMEOUT, this.getTimeoutStringForUI(entry.getMaxTimeoutMins(), entry.getTimeoutDisplayUnit())));
        fields.add(new FieldItem(this.TIMEOUT_DISPLAY_UNIT, entry.getTimeoutDisplayUnit().name()));
        fields.add(new FieldItem(this.AUTHN_CONTEXT_SENSITIVE, String.valueOf(entry.isAuthnContextSensitive())));
        fields.add(new FieldItem(this.ID_DESCRIPTOR, entry.getId()));
        return new TableRow(fields);
    }

    private String getTimeoutStringForUI(Integer timeout, SessionTimeUnit timeUnit) {
        if (timeout == null || timeout == -1) {
            return "";
        }
        return String.valueOf(timeUnit.fromMinutes(timeout.intValue()));
    }

    private void buildActionModel() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        for (Map.Entry<String, String> entry : this.adapterMap.entrySet()) {
            model.add(entry.getKey(), entry.getValue());
            this.typeMap.put(entry.getValue(), AuthnSourceKey.AuthnSourceType.ADAPTER);
        }
        for (Map.Entry<String, String> entry : this.connMap.entrySet()) {
            model.add(entry.getKey(), entry.getValue());
            this.typeMap.put(entry.getValue(), AuthnSourceKey.AuthnSourceType.IDP_CONN);
        }
        this.ADAPTER_CONN_NAME.setModelValues(model);
    }

    private TreeMap<String, String> getSortedConnModelNameIds() {
        TreeMap<String, String> connMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        if (this.isSpEnabled) {
            for (IdpConnection idpConn : this.connManager.getFilteredIdpConnections()) {
                if (!idpConn.getEnabledProfiles().isIdpInitiatedSSOEnabled() && !idpConn.getEnabledProfiles().isSpInitiatedSSOEnabled()) continue;
                if (idpConn.isActive()) {
                    connMap.put(idpConn.getName() + " - (IdP Connection)", idpConn.getEntityId());
                    continue;
                }
                connMap.put(idpConn.getName() + " - (IdP Connection -- Inactive)", idpConn.getEntityId());
            }
        }
        return connMap;
    }

    private TreeMap<String, String> getSortedAdapterModelNameIds() {
        TreeMap<String, String> adapterMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        if (this.isIdpEnabled) {
            for (ConfigurablePluginInstance instance : this.idpAdapterManager.getNonConnectionBasedInstances()) {
                adapterMap.put(instance.getName() + " - (Adapter)", instance.getId());
            }
        }
        return adapterMap;
    }

    public boolean isShowPersistentSessionsCheckbox() {
        return this.isEnableSessions();
    }

    public boolean isTrackRevokedSessionsOnLogout() {
        return this.trackRevokedSessionsOnLogout;
    }

    public void setTrackRevokedSessionsOnLogout(boolean track) {
        this.trackRevokedSessionsOnLogout = track;
    }

    public String getSessionRevocationLifetimeMins() {
        return this.sessionRevocationLifetimeMins;
    }

    public void setSessionRevocationLifetimeMins(String mins) {
        this.sessionRevocationLifetimeMins = mins;
    }

    public boolean isEnableSessions() {
        return this.enableSessions;
    }

    public void setEnableSessions(boolean enableSessions) {
        this.enableSessions = enableSessions;
    }

    public boolean isEnableSessionQuotas() {
        return this.enableSessionQuotas;
    }

    public void setEnableSessionQuotas(boolean enableSessionQuotas) {
        this.enableSessionQuotas = enableSessionQuotas;
    }

    public String getQuotaBehavior() {
        return this.quotaBehavior;
    }

    public void setQuotaBehavior(String quotaBehavior) {
        this.quotaBehavior = quotaBehavior;
    }

    public String getActiveSessionLimit() {
        return this.activeSessionLimit;
    }

    public void setActiveSessionLimit(String activeSessionLimit) {
        this.activeSessionLimit = activeSessionLimit;
    }

    public boolean isPersistentSessions() {
        return this.persistentSessions;
    }

    public void setPersistentSessions(boolean persistentByDefault) {
        this.persistentSessions = persistentByDefault;
    }

    public boolean isHashUniqueUserKeyAttribute() {
        return this.hashUniqueUserKeyAttribute;
    }

    public void setHashUniqueUserKeyAttribute(boolean hashUniqueUserKeyAttribute) {
        this.hashUniqueUserKeyAttribute = hashUniqueUserKeyAttribute;
    }

    public boolean isTrackAdapterSessionsForLogout() {
        return this.trackAdapterSessionsForLogout;
    }

    public void setTrackAdapterSessionsForLogout(boolean trackAdapterSessionsForLogout) {
        this.trackAdapterSessionsForLogout = trackAdapterSessionsForLogout;
    }

    public String getMaxTimeout() {
        return this.maxTimeout;
    }

    public void setMaxTimeout(String maxTimeout) {
        this.maxTimeout = maxTimeout;
    }

    public String getApplicationMaxTimeout() {
        return this.applicationMaxTimeout;
    }

    public void setApplicationMaxTimeout(String applicationMaxTimeout) {
        this.applicationMaxTimeout = applicationMaxTimeout;
    }

    public String getApplicationIdleTimeout() {
        return this.applicationIdleTimeout;
    }

    public void setApplicationIdleTimeout(String applicationIdleTimeout) {
        this.applicationIdleTimeout = applicationIdleTimeout;
    }

    public String getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(String idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public String getMaxTimeoutDisplayUnit() {
        return this.maxTimeoutDisplayUnit;
    }

    public void setMaxTimeoutDisplayUnit(String maxTimeoutDisplayUnit) {
        this.maxTimeoutDisplayUnit = maxTimeoutDisplayUnit;
    }

    public SessionTimeUnit getMaxTimeoutDisplayUnitEnum() {
        return SessionTimeUnit.valueOf((String)this.maxTimeoutDisplayUnit);
    }

    public String getIdleTimeoutDisplayUnit() {
        return this.idleTimeoutDisplayUnit;
    }

    public void setIdleTimeoutDisplayUnit(String idleTimeoutDisplayUnit) {
        this.idleTimeoutDisplayUnit = idleTimeoutDisplayUnit;
    }

    public SessionTimeUnit getIdleTimeoutDisplayUnitEnum() {
        return SessionTimeUnit.valueOf((String)this.idleTimeoutDisplayUnit);
    }

    public StringPairPropertySelectionModel getTimeoutDisplayUnitSelectionModel() {
        return this.timeoutDisplayUnitSelectionModel;
    }

    public StringPairPropertySelectionModel getQuotaBehaviorSelectionModel() {
        return this.quotaBehaviorSelectionModel;
    }

    public List<TableRow> getPolicylist() {
        return this.policylist;
    }

    public void setPolicylist(List<TableRow> policylist) {
        this.policylist = policylist;
    }

    @Override
    public List<String> validate(TableRow updatedRow, TableRow originalRow, List<TableRow> rowList, TableEditor owner) {
        AuthenticationSessionPolicyValidator validator = new AuthenticationSessionPolicyValidator(null, this.getAuthnSourceType(updatedRow), this.getAuthSourceId(updatedRow), Boolean.valueOf(this.getEnableSessions(updatedRow)), this.getUserDevice(updatedRow), this.getIdleTimeoutMins(updatedRow), this.getMaxTimeoutMins(updatedRow), this.getTimeoutDisplayUnit(updatedRow), this.getAuthnContextSensitive(updatedRow).booleanValue(), new ValidatorContext());
        validator.validate();
        List<String> errors = this.convertErrorMessages(validator.getErrors());
        if (this.validateEnableSessions(errors, updatedRow, originalRow, rowList) && rowList.size() > 0) {
            UserDeviceType updatedUserDevice = UserDeviceType.valueOf((String)updatedRow.getField(this.USER_DEVICE_TYPE).getValue());
            Set<UserDeviceType> existingUserDevices = this.getEnabledDeviceTypesByAuthnSource(rowList, originalRow, updatedRow);
            for (UserDeviceType existingUserDevice : existingUserDevices) {
                if (existingUserDevice == updatedUserDevice) {
                    errors.add("The user device type '" + existingUserDevice.getDisplayName() + "' for source '" + updatedRow.getField(this.ADAPTER_CONN_NAME).getLabel() + "' has already been added. Please select a different user device type.");
                    continue;
                }
                if (existingUserDevice != UserDeviceType.ANY && updatedUserDevice != UserDeviceType.ANY) continue;
                errors.add("The user device type '" + existingUserDevice.getDisplayName() + "' for source '" + updatedRow.getField(this.ADAPTER_CONN_NAME).getLabel() + "' has already been added, so you cannot add the user device type '" + updatedUserDevice.getDisplayName() + "'.");
            }
        }
        return errors;
    }

    private boolean validateEnableSessions(List<String> errors, TableRow updatedRow, TableRow originalRow, List<TableRow> rowList) {
        List filteredList = rowList.stream().filter(row -> !row.equals(originalRow) && row.getField(this.ADAPTER_CONN_NAME).getValue().equals(updatedRow.getField(this.ADAPTER_CONN_NAME).getValue())).collect(Collectors.toList());
        if (!Boolean.parseBoolean(updatedRow.getField(this.ENABLE_SESSIONS).getValue()) && filteredList.stream().anyMatch(row -> row.getField(this.ENABLE_SESSIONS).getValue().equals(updatedRow.getField(this.ENABLE_SESSIONS).getValue()))) {
            errors.add("The authentication session for source '" + updatedRow.getField(this.ADAPTER_CONN_NAME).getLabel() + "' has already been disabled. Please select a different source.");
            return false;
        }
        if (filteredList.stream().anyMatch(row -> !row.getField(this.ENABLE_SESSIONS).getValue().equals(updatedRow.getField(this.ENABLE_SESSIONS).getValue()))) {
            errors.add("The authentication session for source '" + updatedRow.getField(this.ADAPTER_CONN_NAME).getLabel() + "' need to be either enabled or disabled, not both. ");
            return false;
        }
        return true;
    }

    private Set<UserDeviceType> getEnabledDeviceTypesByAuthnSource(List<TableRow> tableRows, TableRow originalRow, TableRow newRow) {
        HashSet<UserDeviceType> deviceTypes = new HashSet<UserDeviceType>();
        for (TableRow curRow : tableRows) {
            if (curRow.equals(originalRow) || !newRow.getField(this.ADAPTER_CONN_NAME).getValue().equals(curRow.getField(this.ADAPTER_CONN_NAME).getValue())) continue;
            FieldItem fieldItem = curRow.getField(this.USER_DEVICE_TYPE);
            String deviceTypeName = fieldItem.getValue();
            deviceTypes.add(UserDeviceType.valueOf((String)deviceTypeName));
        }
        return deviceTypes;
    }

    @Override
    public void onAddItem(TableEditor owner, TableRow newRow) {
    }

    @Override
    public void onUpdateItem(TableEditor AuthenticationSessionPoliciesConfigurationStateowner, TableRow originalRow, TableRow newRow) {
        if (!this.getOverridesFlag(newRow).booleanValue()) {
            newRow.getField(this.IDLE_TIMEOUT).setValue("");
            newRow.getField(this.MAX_TIMEOUT).setValue("");
        }
    }

    @Override
    public void onEditItem(TableEditor AuthenticationSessionPoliciesConfigurationStateowner, TableRow originalRow, TableRow newRow) {
        this.toggleSessionEnabled(newRow);
    }

    @Override
    public void onUpdateState(TableEditor AuthenticationSessionPoliciesConfigurationStateowner, TableRow originalRow, TableRow newRow) {
        this.toggleSessionEnabled(newRow);
    }

    @Override
    public boolean isNewRowEditable(TableEditor AuthenticationSessionPoliciesConfigurationStateowner) {
        return !AuthenticationSessionPoliciesConfigurationStateowner.isEditMode();
    }

    @Override
    public void onUpdateSearchFilterList(TableEditor AuthenticationSessionPoliciesConfigurationStateowner, TableRow originalRow, TableRow newRow) {
        this.toggleSessionEnabled(newRow);
    }

    private void toggleSessionEnabled(TableRow updateRow) {
        boolean enabled = Boolean.parseBoolean(updateRow.getField(this.ENABLE_SESSIONS).getValue());
        updateRow.getField(this.USER_DEVICE_TYPE).setEnabled(enabled);
        updateRow.getField(this.PERSISTENT).setEnabled(enabled);
        updateRow.getField(this.OVERRIDE_TIMEOUTS).setEnabled(enabled);
        updateRow.getField(this.AUTHN_CONTEXT_SENSITIVE).setEnabled(enabled);
        if (!enabled) {
            updateRow.getField(this.USER_DEVICE_TYPE).setEnabled(false);
            updateRow.getField(this.IDLE_TIMEOUT).setEnabled(false);
            updateRow.getField(this.MAX_TIMEOUT).setEnabled(false);
            updateRow.getField(this.TIMEOUT_DISPLAY_UNIT).setEnabled(false);
            updateRow.getField(this.PERSISTENT).setValue(Boolean.FALSE.toString());
        } else {
            this.toggleEnableField(updateRow);
        }
    }

    private void toggleEnableField(TableRow editRow) {
        boolean enabled = Boolean.valueOf(editRow.getField(this.OVERRIDE_TIMEOUTS).getValue());
        editRow.getField(this.IDLE_TIMEOUT).setEnabled(enabled);
        editRow.getField(this.MAX_TIMEOUT).setEnabled(enabled);
        editRow.getField(this.TIMEOUT_DISPLAY_UNIT).setEnabled(enabled);
    }

    public List<SimpleFieldDescriptor> getAuthnResultCachingColumnDescriptors() {
        ArrayList<SimpleFieldDescriptor> tableList = new ArrayList<SimpleFieldDescriptor>();
        tableList.add(this.ADAPTER_CONN_NAME);
        tableList.add(this.ENABLE_SESSIONS);
        tableList.add(this.USER_DEVICE_TYPE);
        tableList.add(this.PERSISTENT);
        tableList.add(this.OVERRIDE_TIMEOUTS);
        tableList.add(this.IDLE_TIMEOUT);
        tableList.add(this.MAX_TIMEOUT);
        tableList.add(this.TIMEOUT_DISPLAY_UNIT);
        tableList.add(this.AUTHN_CONTEXT_SENSITIVE);
        this.POLICYLIST_COLUMN_DESCRIPTORS = tableList;
        return this.POLICYLIST_COLUMN_DESCRIPTORS;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (this.delegate.getHasErrors()) {
            return false;
        }
        SessionSettings sessionSettings = this.sessionSettingsMgr.getSessionSettings();
        sessionSettings.setTrackAdapterSessionsForLogout(this.trackAdapterSessionsForLogout);
        sessionSettings.setRevokeUserSessionOnLogout(this.trackRevokedSessionsOnLogout);
        sessionSettings.setSessionRevocationLifetime(Integer.parseInt(this.sessionRevocationLifetimeMins));
        this.sessionSettingsMgr.saveSessionSettings(sessionSettings);
        GlobalAuthnSessionPolicy globalAuthnSessionPolicy = this.sessionPolicyMgr.getGlobalPolicy();
        globalAuthnSessionPolicy.setEnableSessions(this.enableSessions);
        globalAuthnSessionPolicy.setPersistentSessions(this.persistentSessions);
        globalAuthnSessionPolicy.setHashUniqueUserKeyAttribute(this.hashUniqueUserKeyAttribute);
        globalAuthnSessionPolicy.setIdleTimeoutMins(Integer.parseInt(this.convertTimeoutToMinutes(this.idleTimeout, this.getIdleTimeoutDisplayUnitEnum())));
        globalAuthnSessionPolicy.setMaxTimeoutMins(Integer.parseInt(this.convertTimeoutToMinutes(this.maxTimeout, this.getMaxTimeoutDisplayUnitEnum())));
        globalAuthnSessionPolicy.setIdleTimeoutDisplayUnit(this.getIdleTimeoutDisplayUnitEnum());
        globalAuthnSessionPolicy.setMaxTimeoutDisplayUnit(this.getMaxTimeoutDisplayUnitEnum());
        this.sessionPolicyMgr.saveGlobalPolicy(globalAuthnSessionPolicy);
        ApplicationSessionPolicy applicationSessionPolicy = this.sessionPolicyMgr.getApplicationPolicy();
        applicationSessionPolicy.setIdleTimeoutMins(Integer.parseInt(this.convertTimeoutToMinutes(this.applicationIdleTimeout, SessionTimeUnit.MINUTES)));
        applicationSessionPolicy.setMaxTimeoutMins(Integer.parseInt(this.convertTimeoutToMinutes(this.applicationMaxTimeout, SessionTimeUnit.MINUTES)));
        this.sessionPolicyMgr.saveApplicationPolicy(applicationSessionPolicy);
        QuotaPolicy quotaPolicy = this.sessionPolicyMgr.getQuotaPolicy();
        quotaPolicy.setEnableSessionQuotas(this.enableSessionQuotas);
        quotaPolicy.setActiveSessionLimit(this.enableSessionQuotas ? Integer.parseInt(this.activeSessionLimit) : QuotaPolicy.DEFAULT_ACTIVE_SESSION_LIMIT);
        quotaPolicy.setQuotaLimitBehavior(this.enableSessionQuotas ? SessionQuotaBehavior.valueOf((String)this.getQuotaBehavior()) : QuotaPolicy.DEFAULT_QUOTA_LIMIT_BEHAVIOR);
        this.sessionPolicyMgr.saveQuotaPolicy(quotaPolicy);
        ArrayList<AuthnSessionPolicy> policies = new ArrayList<AuthnSessionPolicy>();
        for (TableRow row : this.policylist) {
            String maxStr;
            if (row.isMarkedForDelete()) continue;
            AuthnSessionPolicy domainPolicy = new AuthnSessionPolicy();
            domainPolicy.setId(this.getId(row));
            domainPolicy.setAuthnContextSensitive(this.getAuthnContextSensitive(row).booleanValue());
            domainPolicy.setAuthnSourceId(this.getAuthSourceId(row));
            domainPolicy.setAuthnSourceType(this.getAuthnSourceType(row));
            domainPolicy.setEnableSessions(this.getEnableSessions(row));
            domainPolicy.setPersistent(this.getPersistent(row));
            domainPolicy.setUserDeviceType(this.getUserDevice(row));
            Integer idle = null;
            Integer max = null;
            String idleStr = this.getIdleTimeoutMins(row);
            if (idleStr != null) {
                idle = Integer.parseInt(idleStr);
            }
            if ((maxStr = this.getMaxTimeoutMins(row)) != null) {
                max = Integer.parseInt(maxStr);
            }
            domainPolicy.setIdleTimeoutMins(idle);
            domainPolicy.setMaxTimeoutMins(max);
            domainPolicy.setTimeoutDisplayUnit(this.getTimeoutDisplayUnit(row));
            policies.add(domainPolicy);
        }
        this.sessionPolicyMgr.saveAllSourcePolicies(policies);
        return true;
    }

    protected Boolean getAuthnContextSensitive(TableRow row) {
        return Boolean.valueOf(row.getField(this.AUTHN_CONTEXT_SENSITIVE).getValue());
    }

    protected Boolean getOverridesFlag(TableRow row) {
        return Boolean.valueOf(row.getField(this.OVERRIDE_TIMEOUTS).getValue());
    }

    protected String getId(TableRow row) {
        FieldItem item = row.getField(this.ID_DESCRIPTOR);
        if (item == null) {
            return null;
        }
        return item.getValue();
    }

    protected String getAuthSourceId(TableRow row) {
        String itemId = row.getField(this.ADAPTER_CONN_NAME).getValue();
        AuthnSourceKey.AuthnSourceType sourceType = this.getAuthnSourceType(row);
        if (StringUtils.isNotEmpty((String)itemId) && AuthnSourceKey.AuthnSourceType.IDP_CONN == sourceType) {
            return this.connManager.getIdpConnection(itemId).getId();
        }
        return itemId;
    }

    protected boolean getEnableSessions(TableRow row) {
        return Boolean.valueOf(row.getField(this.ENABLE_SESSIONS).getValue());
    }

    protected boolean getPersistent(TableRow row) {
        return Boolean.valueOf(row.getField(this.PERSISTENT).getValue());
    }

    protected String getIdleTimeoutMins(TableRow row) {
        if (!this.getOverridesFlag(row).booleanValue()) {
            return null;
        }
        return this.convertTimeoutToMinutes(row.getField(this.IDLE_TIMEOUT).getValue(), this.getTimeoutDisplayUnit(row));
    }

    protected String getMaxTimeoutMins(TableRow row) {
        if (!this.getOverridesFlag(row).booleanValue()) {
            return null;
        }
        return this.convertTimeoutToMinutes(row.getField(this.MAX_TIMEOUT).getValue(), this.getTimeoutDisplayUnit(row));
    }

    protected SessionTimeUnit getTimeoutDisplayUnit(TableRow row) {
        String timeoutDisplayUnitStr = row.getField(this.TIMEOUT_DISPLAY_UNIT).getValue();
        return SessionTimeUnit.valueOf((String)timeoutDisplayUnitStr);
    }

    protected UserDeviceType getUserDevice(TableRow row) {
        String userDeviceStr = row.getField(this.USER_DEVICE_TYPE).getValue();
        return UserDeviceType.valueOf((String)userDeviceStr);
    }

    protected AuthnSourceKey.AuthnSourceType getAuthnSourceType(TableRow row) {
        String key = row.getField(this.ADAPTER_CONN_NAME).getValue();
        IPropertySelectionModel modelValues = this.getAllNameModelValues();
        if (modelValues != null) {
            for (int i = 0; i < modelValues.getOptionCount(); ++i) {
                String option = (String)modelValues.getOption(i);
                if (option == null || key == null || !key.equals(option)) continue;
                return this.typeMap.get(option);
            }
        }
        if (this.idpAdapterManager.getInstance(key) != null) {
            return AuthnSourceKey.AuthnSourceType.ADAPTER;
        }
        if (this.connManager.getIdpConnectionBySystemId(key) != null) {
            return AuthnSourceKey.AuthnSourceType.IDP_CONN;
        }
        return null;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        SessionQuotaValidator quotaValidator;
        ApplicationSessionPolicyValidator appValidator;
        SessionRevocationLifetimeValidator srlValidator = new SessionRevocationLifetimeValidator(this.sessionRevocationLifetimeMins, null);
        if (!srlValidator.validate()) {
            this.recordErrors(srlValidator.getErrors(), delegate);
        }
        SessionTimeUnit idleTimeoutDisplayUnitEnum = this.getIdleTimeoutDisplayUnitEnum();
        SessionTimeUnit maxTimeoutDisplayUnitEnum = this.getMaxTimeoutDisplayUnitEnum();
        GlobalAuthenticationSessionPolicyValidator validator = new GlobalAuthenticationSessionPolicyValidator(Boolean.valueOf(this.enableSessions), this.convertTimeoutToMinutes(this.idleTimeout, idleTimeoutDisplayUnitEnum), idleTimeoutDisplayUnitEnum, this.convertTimeoutToMinutes(this.maxTimeout, maxTimeoutDisplayUnitEnum), maxTimeoutDisplayUnitEnum);
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
        if (!(appValidator = new ApplicationSessionPolicyValidator(this.convertTimeoutToMinutes(this.applicationIdleTimeout, SessionTimeUnit.MINUTES), this.convertTimeoutToMinutes(this.applicationMaxTimeout, SessionTimeUnit.MINUTES))).validate()) {
            this.recordErrors(appValidator.getErrors(), delegate);
        }
        Integer activeSessionLimitValue = null;
        SessionQuotaBehavior quotaBehaviorEnum = null;
        if (this.enableSessionQuotas) {
            try {
                activeSessionLimitValue = Integer.parseInt(this.activeSessionLimit);
            }
            catch (NumberFormatException e) {
                ValidationError error = ValidationErrorFactory.getInstance().create((ApiMessageEnum)ApiMessageKey.session_quota_invalid_active_session_limit, SessionQuotaPaths.activeSessionLimit(), new Object[]{this.activeSessionLimit, Integer.MAX_VALUE});
                this.recordErrors(Collections.singletonList(error), delegate);
                return;
            }
            try {
                quotaBehaviorEnum = SessionQuotaBehavior.valueOf((String)this.quotaBehavior);
            }
            catch (IllegalArgumentException e) {
                ValidationError error = ValidationErrorFactory.getInstance().create((ApiMessageEnum)ApiMessageKey.session_quota_invalid_quota_limit_behavior, SessionQuotaPaths.quotaLimitBehavior(), new Object[]{this.quotaBehavior, SessionQuotaBehavior.values()});
                this.recordErrors(Collections.singletonList(error), delegate);
                return;
            }
        }
        if (!(quotaValidator = new SessionQuotaValidator.Builder().setQuotaLimitBehavior(quotaBehaviorEnum).setEnabled(Boolean.valueOf(this.enableSessionQuotas)).setActiveSessionLimit(activeSessionLimitValue).build()).validate()) {
            this.recordErrors(quotaValidator.getErrors(), delegate);
        }
    }

    private String convertTimeoutToMinutes(String value, SessionTimeUnit timeUnit) {
        if (StringUtils.isBlank((String)value)) {
            return "-1";
        }
        try {
            int intValue = Integer.parseInt(value);
            if (intValue == -1) {
                return "-2";
            }
            if (intValue < -1) {
                return value;
            }
            return String.valueOf(timeUnit.toMinutes(intValue));
        }
        catch (NumberFormatException numberFormatException) {
            return value;
        }
    }

    public IPropertySelectionModel getAllNameModelValues() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        for (Map.Entry<String, String> entry : this.adapterMap.entrySet()) {
            model.add(entry.getKey(), entry.getValue());
            this.typeMap.put(entry.getValue(), AuthnSourceKey.AuthnSourceType.ADAPTER);
        }
        for (Map.Entry<String, String> entry : this.connMap.entrySet()) {
            model.add(entry.getKey(), entry.getValue());
            this.typeMap.put(entry.getValue(), AuthnSourceKey.AuthnSourceType.IDP_CONN);
        }
        return model;
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypes() {
        ArrayList<FilterableSelectionFieldDescriptor.SearchableTypeConfig> types = new ArrayList<FilterableSelectionFieldDescriptor.SearchableTypeConfig>();
        if (this.isIdpEnabled) {
            types.add(FilterableSelectionFieldDescriptor.SearchableTypeConfig.IDP_ADAPTER);
        }
        if (this.isSpEnabled) {
            List<FilterableSelectionFieldDescriptor.QueryParam> queryParams = List.of(new FilterableSelectionFieldDescriptor.QueryParam("idpOrSpInitSSO", "true"));
            types.add(new FilterableSelectionFieldDescriptor.SearchableTypeConfig(FilterableSelectionFieldDescriptor.SearchableType.IDP_CONNECTION, queryParams));
        }
        return types;
    }

    public int getSearchableFilterListIndex() {
        return 0;
    }

    public int getCheckboxListIndex() {
        return 2;
    }
}

