/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorManager;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.AbstractPoliciesState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.AuthnPolicyTasklet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.mgmt.AuthnSelectionConfigManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AuthnPoliciesState
extends AbstractPoliciesState {
    private static final long serialVersionUID = 12389L;
    private boolean enableIdpAuthnSelection = false;
    private boolean enableSpAuthnSelection = false;
    private boolean failIfNoSelection = false;

    public AuthnPoliciesState(IWizard owner) {
        super(owner);
        this.setMenuName("Policies");
    }

    @Override
    protected Tasklet initializeNewTasklet() {
        AuthnPolicyTasklet tasklet = this.createTaskletToLoad(AuthnPolicyTasklet.class);
        tasklet.setParentPoliciesState(this);
        tasklet.setMode(Mode.create);
        tasklet.initialize();
        return tasklet;
    }

    @Override
    public boolean save(Object dataToDisk) {
        ArrayList<AuthnSelectionTree> domainTrees = new ArrayList<AuthnSelectionTree>(this.getUndeletedTasklets().size());
        for (Tasklet tasklet : this.getUndeletedTasklets()) {
            AuthnPolicyTasklet policyTasklet = (AuthnPolicyTasklet)tasklet;
            AuthnSelectionTree domainTree = policyTasklet.getDomainPolicy();
            domainTrees.add(domainTree);
            policyTasklet.save(null);
        }
        AuthnSelectionConfigManager authnSelectionConfigManager = MgmtFactory.getAuthnSelectionConfigManager();
        authnSelectionConfigManager.setAuthnSelectionTrees(domainTrees);
        authnSelectionConfigManager.setEnableIdpAuthnSelection(this.enableIdpAuthnSelection);
        authnSelectionConfigManager.setEnableSpAuthnSelection(this.enableSpAuthnSelection);
        authnSelectionConfigManager.setFailIfNoSelection(this.failIfNoSelection);
        DependencyErrorManager dependencyErrorManager = MgmtFactory.getDependencyErrorManager();
        dependencyErrorManager.remove(AffectedItemType.AUTHN_POLICIES.name(), AffectedItemType.AUTHN_POLICIES);
        return true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        AuthnSelectionConfigManager authnSelectionMgr = MgmtFactory.getAuthnSelectionConfigManager();
        List usedNames = authnSelectionMgr.getAuthnSelectionTrees().stream().map(AuthnSelectionTree::getName).collect(Collectors.toList());
        Counter counter = new Counter();
        String unusedName = "Policy " + counter.getAndIncrement();
        this.deleteAllTasklets();
        for (AuthnSelectionTree tree : authnSelectionMgr.getAuthnSelectionTrees()) {
            AuthnSelectionTree copiedTree = AuthnSelectionTree.copyTree((AuthnSelectionTree)tree);
            AuthnPolicyTasklet tasklet = new AuthnPolicyTasklet(this.getVisit());
            tasklet.setMode(Mode.edit);
            tasklet.setParentTasklet(this.getParent());
            tasklet.setParentPoliciesState(this);
            if (StringUtils.isBlank((String)copiedTree.getName())) {
                while (usedNames.contains(unusedName)) {
                    unusedName = "Policy " + counter.getAndIncrement();
                }
                copiedTree.setName(unusedName);
                usedNames.add(unusedName);
            }
            tasklet.populate(copiedTree);
            this.addTasklet(tasklet);
        }
        this.enableIdpAuthnSelection = authnSelectionMgr.isEnableIdpAuthnSelection();
        this.enableSpAuthnSelection = authnSelectionMgr.isEnableSpAuthnSelection();
        this.failIfNoSelection = authnSelectionMgr.isFailIfNoSelection();
    }

    public void moveUp(int index) {
        if (index > 0) {
            Tasklet item = this.getTasklets().get(index);
            this.getTasklets().set(index, this.getTasklets().get(index - 1));
            this.getTasklets().set(index - 1, item);
        }
    }

    public void moveDown(int index) {
        if (index < this.getTasklets().size() - 1) {
            Tasklet item = this.getTasklets().get(index);
            this.getTasklets().set(index, this.getTasklets().get(index + 1));
            this.getTasklets().set(index + 1, item);
        }
    }

    public void showAdapterLongList(int index) {
        Tasklet item = this.getTasklets().get(index);
        ((AuthnPolicyTasklet)item).getPolicyState().setShowAdapterShortList(false);
    }

    public void hideAdapterLongList(int index) {
        Tasklet item = this.getTasklets().get(index);
        ((AuthnPolicyTasklet)item).getPolicyState().setShowAdapterShortList(true);
    }

    public void showContractLongList(int index) {
        Tasklet item = this.getTasklets().get(index);
        ((AuthnPolicyTasklet)item).getPolicyState().setShowContractsShortList(false);
    }

    public void hideContractLongList(int index) {
        Tasklet item = this.getTasklets().get(index);
        ((AuthnPolicyTasklet)item).getPolicyState().setShowContractsShortList(true);
    }

    public void showFragmentLongList(int index) {
        Tasklet item = this.getTasklets().get(index);
        ((AuthnPolicyTasklet)item).getPolicyState().setShowFragmentShortList(false);
    }

    public void hideFragmentLongList(int index) {
        Tasklet item = this.getTasklets().get(index);
        ((AuthnPolicyTasklet)item).getPolicyState().setShowFragmentShortList(true);
    }

    public void showSelectorLongList(int index) {
        Tasklet item = this.getTasklets().get(index);
        ((AuthnPolicyTasklet)item).getPolicyState().setShowSelectorShortList(false);
    }

    public void hideSelectorLongList(int index) {
        Tasklet item = this.getTasklets().get(index);
        ((AuthnPolicyTasklet)item).getPolicyState().setShowSelectorShortList(true);
    }

    public boolean isEnableIdpAuthnSelection() {
        return this.enableIdpAuthnSelection;
    }

    public void setEnableIdpAuthnSelection(boolean enableIdpAuthnSelection) {
        this.enableIdpAuthnSelection = enableIdpAuthnSelection;
    }

    public boolean isEnableSpAuthnSelection() {
        return this.enableSpAuthnSelection;
    }

    public void setEnableSpAuthnSelection(boolean enableSpAuthnSelection) {
        this.enableSpAuthnSelection = enableSpAuthnSelection;
    }

    public boolean isFailIfNoSelection() {
        return this.failIfNoSelection;
    }

    public void setFailIfNoSelection(boolean failIfNoSelection) {
        this.failIfNoSelection = failIfNoSelection;
    }

    public boolean showIdpAuthnSelectionCheckbox() {
        return MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableIdP();
    }

    public boolean showSpAuthnSelectionCheckbox() {
        return MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableSP();
    }

    @Override
    public void setTaskletToEdit(Tasklet taskletToEdit) {
        if (taskletToEdit.isCancelled() && taskletToEdit.isModeCreate() && !taskletToEdit.isCompleted()) {
            this.getTasklets().remove(taskletToEdit);
        }
        if (taskletToEdit.isCompleted() && taskletToEdit instanceof AuthnPolicyTasklet) {
            taskletToEdit.setPopulateData(((AuthnPolicyTasklet)taskletToEdit).getDomainPolicy());
        }
        this.refreshState();
    }

    @Override
    public void refreshState() {
        this.setDelegate(this.getParent().getDelegate(this.getParent().getCycle()));
        this.appendErrors((IValidationDelegate)this.getDelegate(), null, false);
    }

    @Override
    public void loadTasklet(Tasklet tasklet) {
        super.loadTasklet(tasklet);
        if (tasklet.isModeCreate()) {
            this.addTasklet(tasklet);
        }
    }

    private static class Counter {
        int i = 1;

        private Counter() {
        }

        int getAndIncrement() {
            int retVal = this.i++;
            return retVal;
        }
    }
}

