/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.api.SamlProfilesApi;
import com.pingidentity.fsm.tasklet.api.WebSsoApi;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.InboundArtifactBindingConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.OutboundArtifactBindingConfigTasklet;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.websso.Protocol;

public class BackChannelAuthenticationState
extends TaskletListState
implements Serializable {
    private static final long serialVersionUID = 20050515L;

    public BackChannelAuthenticationState(Tasklet value) {
        super(value);
        this.setMenuName("Back-Channel Authentication");
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase connection = (ConnectionBase)dataFromDisk;
        if (this.isInboundArtifactSelected()) {
            InboundArtifactBindingConfigTasklet inboundTasklet = this.getInboundArtifactBindingConfigTasklet();
            if (connection != null) {
                inboundTasklet.setMode(Mode.edit);
                inboundTasklet.populate(connection);
            }
        }
        if (this.isOutboundArtifactSelected()) {
            OutboundArtifactBindingConfigTasklet outboundTasklet = this.getOutboundArtifactBindingConfigTasklet();
            if (connection != null) {
                outboundTasklet.setMode(Mode.edit);
                outboundTasklet.populate(connection);
            }
        }
    }

    @Override
    public boolean populateAllStates(Object data) {
        InboundArtifactBindingConfigTasklet inboundTasklet = this.getInboundArtifactBindingConfigTasklet();
        if (data != null) {
            inboundTasklet.populateAllStates(data);
        }
        OutboundArtifactBindingConfigTasklet outboundTasklet = this.getOutboundArtifactBindingConfigTasklet();
        if (data != null) {
            outboundTasklet.populateAllStates(data);
        }
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (this.isInboundArtifactSelected()) {
            InboundArtifactBindingConfigTasklet inboundTasklet = this.getInboundArtifactBindingConfigTasklet();
            inboundTasklet.save(dataToDisk);
        }
        if (this.isOutboundArtifactSelected()) {
            OutboundArtifactBindingConfigTasklet outboundTasklet = this.getOutboundArtifactBindingConfigTasklet();
            outboundTasklet.save(dataToDisk);
        }
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.isInboundArtifactSelected() && !this.isInboundConfigured()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Inbound_Artifact_binding_required"), ValidationConstraint.REQUIRED);
        }
        if (this.isOutboundArtifactSelected() && !this.isOutboundConfigured()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Outbound_Artifact_binding_required"), ValidationConstraint.REQUIRED);
        }
    }

    public boolean isConfigured() {
        return (!this.isInboundArtifactSelected() || this.isInboundArtifactSelected() && this.isInboundConfigured()) && (!this.isOutboundArtifactSelected() || this.isOutboundArtifactSelected() && this.isOutboundConfigured());
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.isInboundArtifactSelected() && this.isInboundConfigured()) {
            this.getInboundArtifactBindingConfigTasklet().getSummary(summaryList);
        }
        if (this.isOutboundArtifactSelected() && this.isOutboundConfigured()) {
            this.getOutboundArtifactBindingConfigTasklet().getSummary(summaryList);
        }
    }

    public boolean isInboundArtifactSelected() {
        boolean selected = false;
        WebSsoApi wsa = this.findParent(WebSsoApi.class);
        selected = wsa.isInboundArtifact();
        selected |= wsa.isSoapSlo();
        if (this.findParent(ConnectionTasklet.class).getConnectionType() == ConnectionType.IDP) {
            selected |= this.isAttributeQuerySelected();
        }
        return selected;
    }

    public boolean isOutboundArtifactSelected() {
        boolean selected = false;
        WebSsoApi wsa = this.findParent(WebSsoApi.class);
        selected = wsa.isArtifactSsoSlo();
        selected |= wsa.isInboundSoap();
        ConnectionTasklet connectionTasklet = this.findParent(ConnectionTasklet.class);
        if (connectionTasklet.getConnectionType() == ConnectionType.SP) {
            selected |= this.isAttributeQuerySelected();
        }
        if (connectionTasklet.getConnectionType() == ConnectionType.IDP) {
            selected |= ((IdpConnectionConfigTasklet)connectionTasklet).isInboundProvisioningEnabled();
        }
        return selected;
    }

    public boolean outboundArtifactUsesNone() {
        if (this.isOutboundConfigured()) {
            return this.getOutboundArtifactBindingConfigTasklet().usesNone();
        }
        return false;
    }

    public boolean outboundArtifactUsesSSLCert() {
        if (this.isOutboundConfigured()) {
            return this.getOutboundArtifactBindingConfigTasklet().usesSSLCert();
        }
        return false;
    }

    public boolean inboundArtifactUsesDsigAuth() {
        return this.isInboundArtifactSelected() && this.isInboundConfigured() && this.getInboundArtifactBindingConfigTasklet().usesDsigAuth();
    }

    public boolean inboundArtifactUsesSSLCert() {
        return this.isInboundArtifactSelected() && this.isInboundConfigured() && this.getInboundArtifactBindingConfigTasklet().usesSSLCert();
    }

    public boolean inboundArtifactUsesNone() {
        if (this.isInboundConfigured()) {
            return this.getInboundArtifactBindingConfigTasklet().usesNone();
        }
        return false;
    }

    public boolean inboundArtifactUsesBasic() {
        return this.isInboundArtifactSelected() && this.isInboundConfigured() && this.getInboundArtifactBindingConfigTasklet().isBasic();
    }

    public boolean outboundArtifactUsesDsigAuth() {
        return this.isOutboundArtifactSelected() && this.isOutboundConfigured() ? this.getOutboundArtifactBindingConfigTasklet().usesDsigAuth() : this.isConnectionProtocol1x() && this.getOutboundArtifactBindingConfigTasklet().usesDsigAuth();
    }

    public boolean isConnectionProtocol1x() {
        Tasklet t = this.getParent();
        Protocol protocol = t.getProtocolTypeEnum();
        return Protocol.SAML10.equals((Object)protocol) || Protocol.SAML11.equals((Object)protocol);
    }

    public boolean outboundArtifactUsesBasic() {
        return this.isOutboundArtifactSelected() && this.isOutboundConfigured() && this.getOutboundArtifactBindingConfigTasklet().isBasic();
    }

    public String getLine1Text() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Send to your partner:<UL>");
        WebSsoApi wsa = this.findParent(WebSsoApi.class);
        if (wsa.isSoapSlo()) {
            buffer.append("<LI>SOAP SLO messages");
        }
        if (wsa.isInboundArtifact()) {
            buffer.append("<LI>Artifact resolution requests");
        }
        if (this.findParent(ConnectionTasklet.class).getConnectionType() == ConnectionType.IDP && this.isAttributeQuerySelected()) {
            buffer.append("<LI>Attribute Query requests</UL>");
        }
        buffer.append("</UL>");
        return buffer.toString();
    }

    public String getLine2Text() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Receive from your partner:<UL>");
        WebSsoApi wsa = this.findParent(WebSsoApi.class);
        if (wsa.isInboundSoap()) {
            buffer.append("<LI>SOAP messages");
        }
        if (wsa.isArtifactSsoSlo()) {
            buffer.append("<LI>Artifact resolution requests");
        }
        if (this.findParent(ConnectionTasklet.class).getConnectionType() == ConnectionType.SP && this.isAttributeQuerySelected()) {
            buffer.append("<LI>Attribute Query requests</UL>");
        }
        if (this.findParent(ConnectionTasklet.class).getConnectionType() == ConnectionType.IDP && this.isInboundProvisioningSelected()) {
            buffer.append("<LI>Provisioning requests</UL>");
        }
        buffer.append("</UL>");
        return buffer.toString();
    }

    public boolean isInboundConfigured() {
        return this.isTaskletConfigured(this.getInboundArtifactBindingConfigTasklet());
    }

    public boolean isOutboundConfigured() {
        return this.isTaskletConfigured(this.getOutboundArtifactBindingConfigTasklet());
    }

    protected boolean isTaskletConfigured(Tasklet tasklet) {
        SummaryInfoPFValidationDelegate delegate = new SummaryInfoPFValidationDelegate();
        tasklet.appendErrors((IValidationDelegate)delegate, null, false);
        return tasklet.areAllStatesClicked() && !delegate.getHasErrors();
    }

    public void loadInboundTasklet(IRequestCycle cycle) {
        InboundArtifactBindingConfigTasklet tasklet = this.getInboundArtifactBindingConfigTasklet();
        tasklet.resetCurrentStateToSourceState();
        tasklet.markProtocolImgAvailable(this.getParent().isProtocolImgAvailable());
        this.loadTasklet(tasklet);
        if (tasklet.areAllStatesClicked()) {
            tasklet.gotoSummaryState(cycle);
        }
    }

    public void loadOutboundTasklet(IRequestCycle cycle) {
        OutboundArtifactBindingConfigTasklet tasklet = this.getOutboundArtifactBindingConfigTasklet();
        tasklet.resetCurrentStateToSourceState();
        tasklet.markProtocolImgAvailable(this.getParent().isProtocolImgAvailable());
        this.loadTasklet(tasklet);
        if (tasklet.areAllStatesClicked()) {
            tasklet.gotoSummaryState(cycle);
        }
    }

    private InboundArtifactBindingConfigTasklet getInboundArtifactBindingConfigTasklet() {
        InboundArtifactBindingConfigTasklet inboundTasklet = null;
        for (Tasklet tasklet : this.getTasklets()) {
            if (!(tasklet instanceof InboundArtifactBindingConfigTasklet)) continue;
            inboundTasklet = (InboundArtifactBindingConfigTasklet)tasklet;
            break;
        }
        if (inboundTasklet == null) {
            inboundTasklet = this.createTasklet(InboundArtifactBindingConfigTasklet.class);
            this.addTasklet(inboundTasklet);
        }
        return inboundTasklet;
    }

    private OutboundArtifactBindingConfigTasklet getOutboundArtifactBindingConfigTasklet() {
        OutboundArtifactBindingConfigTasklet outboundTasklet = null;
        for (Tasklet tasklet : this.getTasklets()) {
            if (!(tasklet instanceof OutboundArtifactBindingConfigTasklet)) continue;
            outboundTasklet = (OutboundArtifactBindingConfigTasklet)tasklet;
            break;
        }
        if (outboundTasklet == null) {
            outboundTasklet = this.createTasklet(OutboundArtifactBindingConfigTasklet.class);
            this.addTasklet(outboundTasklet);
        }
        return outboundTasklet;
    }

    @Override
    public void reset() {
        for (Tasklet t : this.getTasklets()) {
            t.resetAllStates();
        }
    }

    @Override
    public String getNoteKey() {
        if (this.findParent(ConnectionTasklet.class).isConnectionProtocol1x()) {
            return super.getNoteKey() + "_1x";
        }
        return super.getNoteKey();
    }

    private boolean isAttributeQuerySelected() {
        return this.findParent(SamlProfilesApi.class).isAttributeQuerySelected();
    }

    private boolean isInboundProvisioningSelected() {
        IdpConnectionConfigTasklet tasklet = this.findParent(IdpConnectionConfigTasklet.class);
        return tasklet != null && tasklet.isInboundProvisioningEnabled();
    }
}

