/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.state.impl.SelectDataSourceState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.fsm.tasklet.impl.SpAttributeSourceTasklet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.mgmt.AttributeSourceFactory;

public abstract class BaseConfigAttributeSourcesState
extends TaskletListState {
    private static final long serialVersionUID = 1L;
    private Object dataFromDisk;

    public BaseConfigAttributeSourcesState(IWizard owner) {
        super(owner);
        this.setMenuName("Attribute Sources & User Lookup");
    }

    public BaseConfigAttributeSourcesState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Attribute Sources & User Lookup");
    }

    protected abstract void createSpAttributeSourceTasklets(Object var1);

    protected abstract List<AttributeSource> getAttributeSourcesFromDisk();

    protected abstract boolean save(Object var1, List<AttributeMapping> var2);

    @Override
    public void populate(Object dataFromDisk) {
        this.dataFromDisk = dataFromDisk;
        this.deleteAllTasklets();
        this.createSpAttributeSourceTasklets(dataFromDisk);
    }

    @Override
    public boolean save(Object dataToDisk) {
        ArrayList<AttributeMapping> mappings = new ArrayList<AttributeMapping>();
        for (Tasklet t : this.getTasklets()) {
            if (t.isItDeleted()) continue;
            AttributeMapping mapping = new AttributeMapping();
            t.save(mapping);
            mappings.add(mapping);
        }
        return this.save(dataToDisk, mappings);
    }

    protected void createSpAttributeSourceTasklet(AttributeMapping mapping) {
        this.createSpAttributeSourceTasklet(this.getAttributeSourceTaskletClass(), mapping);
    }

    private void createSpAttributeSourceTasklet(Class<? extends SpAttributeSourceTasklet> taskletClass, AttributeMapping mapping) {
        SpAttributeSourceTasklet tasklet = this.createTasklet(taskletClass);
        MappingTasklet mappingTasklet = this.findParent(MappingTasklet.class);
        tasklet.addNoteKeySuffixToStates(mappingTasklet.getNoteKeySuffix());
        tasklet.populate(mapping);
        this.addTasklet(tasklet);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!this.hasAttributeSources()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("One_attribute_source_required"), ValidationConstraint.REQUIRED);
        } else {
            for (Tasklet tasklet : this.getTasklets()) {
                tasklet.appendErrors(delegate, component, fastFail);
            }
        }
    }

    protected boolean hasAttributeSources() {
        for (Tasklet t : this.getTasklets()) {
            if (t.isItDeleted()) continue;
            return true;
        }
        return false;
    }

    public Tasklet getTaskletFromList(String identifier) {
        for (Tasklet tasklet : this.getTasklets()) {
            SpAttributeSourceTasklet spAttributeSourceTasklet = (SpAttributeSourceTasklet)tasklet;
            if (!spAttributeSourceTasklet.getDesc().equals(identifier)) continue;
            return spAttributeSourceTasklet;
        }
        return null;
    }

    public void delete(String connToDelete) {
        for (Tasklet tasklet : this.getTasklets()) {
            SpAttributeSourceTasklet t = (SpAttributeSourceTasklet)tasklet;
            if (!t.getDescription().equals(connToDelete)) continue;
            t.setItDeleted(true);
            return;
        }
    }

    public void undelete(String mappingToDelete) {
        for (Tasklet tasklet : this.getTasklets()) {
            SpAttributeSourceTasklet t = (SpAttributeSourceTasklet)tasklet;
            if (!t.getDescription().equals(mappingToDelete)) continue;
            t.setItDeleted(false);
            return;
        }
    }

    public void moveUp(int index) {
        if (index > 0) {
            List<Tasklet> tasklets = this.getTasklets();
            Tasklet item = tasklets.get(index);
            tasklets.set(index, tasklets.get(index - 1));
            tasklets.set(index - 1, item);
        }
    }

    public void moveDown(int index) {
        List<Tasklet> tasklets = this.getTasklets();
        if (index < tasklets.size() - 1) {
            Tasklet item = tasklets.get(index);
            tasklets.set(index, tasklets.get(index + 1));
            tasklets.set(index + 1, item);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.getTasklets().isEmpty()) {
            summaryList.add(new SummaryInfo(this.getMessage("DataSources"), "(None)", this));
        }
        for (Tasklet tasklet : this.getTasklets()) {
            SpAttributeSourceTasklet attrSourceTasklet = (SpAttributeSourceTasklet)tasklet;
            StringBuilder sb = new StringBuilder();
            sb.append(attrSourceTasklet.getDescription()).append(" (").append(attrSourceTasklet.getDataSourceType()).append(")");
            summaryList.add(new SummaryInfo(this.getMessage("Data_store"), sb.toString(), this));
        }
    }

    public boolean checkForDuplicateDescriptions(String descToCheck, Tasklet excludeTasklet) {
        for (Tasklet tasklet : this.getTasklets()) {
            SpAttributeSourceTasklet t;
            if (tasklet == excludeTasklet || !(t = (SpAttributeSourceTasklet)tasklet).getDescription().equals(descToCheck)) continue;
            return true;
        }
        return false;
    }

    public boolean checkForDuplicateIds(String idToCheck, Tasklet excludeTasklet) {
        if (idToCheck != null) {
            for (Tasklet tasklet : this.getTasklets()) {
                SpAttributeSourceTasklet t;
                if (tasklet == excludeTasklet || !idToCheck.equals((t = (SpAttributeSourceTasklet)tasklet).getId())) continue;
                return true;
            }
        }
        return false;
    }

    public Map<AttributeSource, IPropertySelectionModel> getIPropertySelectionModelsForAttributeSources() {
        HashMap<AttributeSource, IPropertySelectionModel> models = new HashMap<AttributeSource, IPropertySelectionModel>();
        for (Tasklet tasklet : this.getTasklets()) {
            SelectDataSourceState dataSourceState;
            IWizardState sourceState;
            SpAttributeSourceTasklet spAttributeSourceTasklet;
            IPropertySelectionModel model;
            if (tasklet.isItDeleted() || (model = (spAttributeSourceTasklet = (SpAttributeSourceTasklet)tasklet).getIPropertySelectionModel()) == null || !((sourceState = tasklet.getSourceState()) instanceof SelectDataSourceState) || (dataSourceState = (SelectDataSourceState)sourceState).getSelectedDataSource() == null) continue;
            AttributeSource attributeSource = AttributeSourceFactory.getAttributeSource((String)dataSourceState.getSelectedDataSource().getDataSourceType(), (String)dataSourceState.getAttrSourceDesc(), (String)dataSourceState.getSelectedDataSource().getId(), (String)dataSourceState.generateAttributeSourceId());
            models.put(attributeSource, model);
        }
        return models;
    }

    public boolean isUseOtherValuesWithOneMapping() {
        MappingTasklet tasklet = this.findParent(MappingTasklet.class);
        return tasklet != null && tasklet.isUseOtherValuesWithOneMapping();
    }

    public Set<String> getReferencesInAllAttributeSourceFiltersFromDisk() {
        List<AttributeSource> attributeSourcesFromDisk;
        HashSet<String> references = new HashSet<String>();
        if (this.isUseOtherValuesWithOneMapping() && (attributeSourcesFromDisk = this.getAttributeSourcesFromDisk()) != null) {
            for (AttributeSource attrSourceFromDisk : attributeSourcesFromDisk) {
                references.addAll(attrSourceFromDisk.getFilterAttributeReferences());
            }
        }
        return references;
    }

    protected Object getPopulateData() {
        return this.dataFromDisk;
    }

    public Class<? extends SpAttributeSourceTasklet> getAttributeSourceTaskletClass() {
        return SpAttributeSourceTasklet.class;
    }
}

