/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.PasswordValidator;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.UserMgmtState;
import com.pingidentity.fsm.tasklet.impl.WsTrustStsSystemAuthTasklet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.wstrust.mgmt.WsTrustBasicAuthManager;

public class BasicAuthUserMgmtState
extends UserMgmtState {
    private static final long serialVersionUID = 2L;
    private List<AdministrativeUser> users;
    private WsTrustBasicAuthManager authnManager = (WsTrustBasicAuthManager)GlobalRegistry.getService(WsTrustBasicAuthManager.class);

    public BasicAuthUserMgmtState(IWizard owner, String value) {
        super(owner, value);
        this.setMenuName("User Account");
    }

    @Override
    public void populate(Object dataFromDisk) {
        AdministrativeUser user = (AdministrativeUser)dataFromDisk;
        this.setUserName(user.getUserName());
    }

    @Override
    public void onStateActivated() {
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.getParent().isModeCreate()) {
            WsTrustStsSystemAuthTasklet tasklet = this.findParent(WsTrustStsSystemAuthTasklet.class);
            if (StringUtils.isBlank((String)this.getUserName())) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Username_required"), ValidationConstraint.REQUIRED);
            } else if (tasklet.doesUserExist(this.getUserName())) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Username_already_exists"), ValidationConstraint.REQUIRED);
            }
        }
        if (this.getParent().isModeEdit()) {
            if (StringUtils.isBlank((String)this.getCurrentPassword())) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Current_password_required"), ValidationConstraint.REQUIRED);
            } else if (!this.authnManager.authenticate(this.getUserName(), this.getCurrentPassword())) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Current_password_invalid"), ValidationConstraint.REQUIRED);
            } else if (this.authnManager.authenticate(this.getUserName(), this.getNewPassword())) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Password_must_change"), ValidationConstraint.REQUIRED);
            }
        }
        PasswordValidator passwordValidator = new PasswordValidator(this.getNewPassword());
        if (StringUtils.isBlank((String)this.getNewPassword().trim())) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Password_required"), ValidationConstraint.REQUIRED);
        } else if (!passwordValidator.validate()) {
            delegate.setFormComponent(null);
            this.recordErrors(passwordValidator.getErrors(), delegate);
        } else if (!this.getNewPassword().equals(this.getNewPasswordConfirm())) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Passwords_dont_match"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        return true;
    }

    public void getUserChanges(AdministrativeUser user) {
        user.setUserName(this.getUserName());
        user.setNewPassword(this.getNewPassword());
    }

    @Override
    public boolean displayCurrentPassword() {
        return this.getParent().isModeEdit();
    }

    @Override
    public boolean displayUsernameTextField() {
        return this.getParent().isModeCreate();
    }

    public List<AdministrativeUser> getUsers() {
        return this.users;
    }

    public void setUsers(List<AdministrativeUser> users) {
        this.users = users;
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }
}

