/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.PasswordValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class BasicSoapAuthInboundState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String username = "";
    private String password = null;
    private String confirmPassword = null;
    private String existingEncodedPassword;

    public BasicSoapAuthInboundState(Tasklet value, String name) {
        super(value, name);
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase connectionBase = (ConnectionBase)dataFromDisk;
        SoapAuthInfo soapAuthIn = connectionBase.getSoapAuthIn();
        if (soapAuthIn.isHasBasicEntry()) {
            SoapAuthInfo.BasicAuthInfo basicAuthInfo = soapAuthIn.getBasicAuthInfo();
            this.username = basicAuthInfo.getUsername();
            this.existingEncodedPassword = basicAuthInfo.getEncodedPassword();
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase conn = (ConnectionBase)dataToDisk;
        SoapAuthInfo info = conn.getSoapAuthIn();
        SoapAuthInfo.IncomingBasicAuthInfo incomingBasicAuth = new SoapAuthInfo.IncomingBasicAuthInfo(this.username, this.existingEncodedPassword);
        incomingBasicAuth.setNewPassword(this.password);
        info.setBasicAuthInfo((SoapAuthInfo.BasicAuthInfo)incomingBasicAuth);
        return true;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String userName) {
        this.username = userName;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        ConnectionTasklet connTasklet;
        ConnectionBase conn;
        String ctxId;
        ConnectionManager connMgr;
        String usedBy;
        if (component != null) {
            if (StringUtils.isBlank((String)this.username)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("User_name_required"), ValidationConstraint.REQUIRED);
            } else if (this.username.contains(":")) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("No_colons"), ValidationConstraint.REQUIRED);
            }
            if (!this.hasExistingPassword()) {
                if (StringUtils.isBlank((String)this.password)) {
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("Password_required"), ValidationConstraint.REQUIRED);
                }
                if (StringUtils.isBlank((String)this.confirmPassword)) {
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("Confirm_password_required"), ValidationConstraint.REQUIRED);
                }
            }
        }
        if (this.password != null && this.confirmPassword != null) {
            PasswordValidator passwordValidator = new PasswordValidator(this.password);
            if (!this.password.equals(this.confirmPassword)) {
                delegate.record(this.getMessage("Passwords_dont_match"), ValidationConstraint.REQUIRED);
                this.confirmPassword = "";
                this.password = "";
            } else if (!passwordValidator.validate()) {
                this.recordErrors(passwordValidator.getErrors(), delegate);
            }
        } else if (!this.hasExistingPassword() && delegate instanceof SummaryInfoPFValidationDelegate) {
            delegate.record(this.getMessage("Both_passwords_required"), ValidationConstraint.REQUIRED);
        }
        if (delegate != null && !delegate.getHasErrors() && (usedBy = (connMgr = MgmtFactory.getConnectionManager()).basicAuthInUserNameUsedBy(this.username, ctxId = (conn = (connTasklet = this.findParent(ConnectionTasklet.class)).getBase()) == null ? null : conn.getId())) != null) {
            IFormComponent ic = null;
            if (component != null) {
                ic = (IFormComponent)component.getComponent("username");
            }
            delegate.setFormComponent(ic);
            Object[] params = new String[]{usedBy};
            delegate.record(this.getMessage("Username_in_use", params), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Username", this.getUserName(), this));
    }

    @Override
    public void reset() {
        this.username = "";
        this.password = "";
        this.confirmPassword = null;
    }

    public boolean hasExistingPassword() {
        return this.existingEncodedPassword != null;
    }
}

