/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.saml20.domain.ConnectionBase;

public class BasicSoapAuthOutboundState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String username = "";
    private String password = "";
    private String confirmPassword;
    private boolean hasExistingPass = false;

    public BasicSoapAuthOutboundState(Tasklet value, String name) {
        super(value, name);
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase conn = (ConnectionBase)dataFromDisk;
        SoapAuthInfo soapAuthOut = conn.getSoapAuthOut();
        if (soapAuthOut.isHasBasicEntry()) {
            SoapAuthInfo.OutgoingBasicAuthInfo info = (SoapAuthInfo.OutgoingBasicAuthInfo)soapAuthOut.getBasicAuthInfo();
            this.username = info.getUsername();
            this.confirmPassword = this.password = info.getPassword();
            this.hasExistingPass = true;
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase conn = (ConnectionBase)dataToDisk;
        SoapAuthInfo info = conn.getSoapAuthOut();
        info.setBasicAuthInfo((SoapAuthInfo.BasicAuthInfo)SoapAuthInfo.OutgoingBasicAuthInfo.fromClearPassword((String)this.username, (String)this.password));
        return true;
    }

    @Override
    public void reset() {
        this.password = "";
        this.username = "";
        this.confirmPassword = null;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String userName) {
        this.username = userName;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (component != null) {
            if (StringUtils.isBlank((String)this.username)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("User_name_required"), ValidationConstraint.REQUIRED);
            } else if (this.username.contains(":")) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("No_colons"), ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.password)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Password_required"), ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.confirmPassword)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Confirm_password_required"), ValidationConstraint.REQUIRED);
            }
        }
        if (!StringUtils.isBlank((String)this.password) && !StringUtils.isBlank((String)this.confirmPassword)) {
            if (!this.getPassword().equals(this.confirmPassword)) {
                delegate.record(this.getMessage("Passwords_dont_match"), ValidationConstraint.REQUIRED);
                this.confirmPassword = "";
                this.password = "";
            }
        } else if (delegate instanceof SummaryInfoPFValidationDelegate) {
            delegate.record(this.getMessage("Both_passwords_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Username"), this.username, this));
    }

    public boolean hasExistingPassword() {
        return this.hasExistingPass;
    }
}

