/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.fsm.state.impl.CertListState;
import com.pingidentity.fsm.state.impl.WsTrustRestrictByCertState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.CertApi;
import com.pingidentity.fsm.tasklet.api.InUseCertsApi;
import com.pingidentity.fsm.tasklet.data.CertItem;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.WsTrustListUIEntry;
import com.pingidentity.fsm.tasklet.impl.CertificateExpiryWarningManagementTasklet;
import com.pingidentity.fsm.tasklet.impl.DSignRotationTasklet;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.AdminSslServerPkCertManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.saml20.domain.mgmt.SslServerPkCertManager;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;

public class CertManagementState
extends TaskletState
implements CertListState,
CertificateTypes {
    private static final long serialVersionUID = 20050515L;
    private List<CertItem> certs = new ArrayList<CertItem>();
    private CertificateTypes.ValidTypes certType;
    private Cert selectedCert;
    private Cert secondarySelectedCert;
    private ConnectionCerts dsigVerificationCerts;
    private Set<Cert> sslVerificationCerts;
    private CertItem currentCert;
    private boolean useDefaultSelectedCertFunctionality = true;
    private String certificateFeatureName;
    private LinkedHashSet<Cert> activeCerts = new LinkedHashSet();
    private Set<Cert> inactiveCerts = new LinkedHashSet<Cert>();
    private Set<Cert> activeAdminCerts = new HashSet<Cert>();
    private CertItem defaultActiveRuntime;
    private CertItem defaultActiveAdmin;

    public CertManagementState(Tasklet value, String name) {
        super(value, name);
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.certs = new ArrayList<CertItem>();
        switch (this.certType) {
            case dsigVerificationCert: 
            case ocspDsigVerificationCert: 
            case wsTrustDsigVerificationCert: {
                InUseCertsApi iuca = this.findParent(InUseCertsApi.class);
                Set<Cert> inUseCerts = iuca.getInUseXmlEncryptionCerts();
                this.dsigVerificationCerts = iuca.getDsigConnectionCerts();
                if (this.getActiveCerts() != null) {
                    this.getActiveCerts().forEach(activeCert -> {
                        CertItem item = new CertItem((Cert)activeCert);
                        item.setAlreadyInUse(inUseCerts.contains(activeCert));
                        item.setActive(true);
                        this.certs.add(item);
                    });
                }
                if (this.getInactiveCerts() != null) {
                    this.getInactiveCerts().forEach(inactiveCert -> {
                        CertItem item = new CertItem((Cert)inactiveCert);
                        item.setAlreadyInUse(inUseCerts.contains(inactiveCert));
                        item.setActive(false);
                        this.certs.add(item);
                    });
                }
                this.setMenuName("Manage Digital Verification Certificates");
                break;
            }
            case xmlEncryptionCert: {
                InUseCertsApi iuca = this.findParent(InUseCertsApi.class);
                if (iuca != null) {
                    LinkedHashSet<Cert> inUseCerts = iuca.getInUseVerificationCerts();
                    this.dsigVerificationCerts = iuca.getDsigConnectionCerts();
                    Set encryptionCerts = this.dsigVerificationCerts.getAllVerificationCerts();
                    for (Cert cert : encryptionCerts) {
                        CertItem item = this.createNewCertItem(cert);
                        if (inUseCerts.contains(cert)) {
                            item.setAlreadyInUse(true);
                        }
                        this.certs.add(item);
                    }
                } else {
                    PkCertAndConnectionCertManager certManager = (PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager();
                    Set encryptionCerts = certManager.getCertsForFeature(this.getCertificateFeatureName());
                    if (encryptionCerts != null) {
                        for (Cert cert : encryptionCerts) {
                            CertItem item = this.createNewCertItem(cert);
                            this.certs.add(item);
                        }
                    }
                }
                this.setMenuName("Manage XML Encryption Certificates");
                break;
            }
            case sslCertAuth: {
                PkCertManager sslPcm = MgmtFactory.getSslAuthPkCertManager();
                Set sslAuthPkCerts = sslPcm.getPkCerts();
                for (Cert cert : sslAuthPkCerts) {
                    CertItem item = this.createNewCertItem(cert);
                    this.certs.add(item);
                }
                this.setMenuName("Manage SSL Auth Private Keys and Certificates");
                break;
            }
            case dsigSigningCert: 
            case xmlDecryptionCert: {
                PkCertManager dsigPcm = MgmtFactory.getDsigPkCertManager();
                Set dsigCerts = dsigPcm.getPkCerts();
                for (Cert cert : dsigCerts) {
                    CertItem item = this.createNewCertItem(cert);
                    this.certs.add(item);
                }
                this.setMenuName("Manage Digital Signing Certificates");
                break;
            }
            case sslCertVerification: {
                this.sslVerificationCerts = (Set)dataFromDisk;
                if (this.sslVerificationCerts != null) {
                    for (Cert cert : this.sslVerificationCerts) {
                        this.certs.add(this.createNewCertItem(cert));
                    }
                }
                this.setMenuName("Manage Verification Certificates");
                break;
            }
            case trustedCAs: {
                TrustedCAsManager tcm = MgmtFactory.getTrustedCAsManager();
                Set trustedCerts = tcm.getTrustedCAs();
                for (Cert cert : trustedCerts) {
                    CertItem item = new CertItem(cert);
                    this.certs.add(item);
                }
                this.setMenuName("Manage Trusted CAs");
                break;
            }
            case sslServerCerts: {
                SslServerPkCertManager sslServerPcm = MgmtFactory.getSslServerPkCertManager();
                Set sslServerCerts = sslServerPcm.getPkCerts();
                Set activeCertAliases = sslServerPcm.getActiveServerPkCerts().stream().map(Cert::getAlias).collect(Collectors.toSet());
                AdminSslServerPkCertManager adminSslServerPcm = MgmtFactory.getAdminSslServerPkCertManager();
                Set activeAdminCertAliases = adminSslServerPcm.getActiveServerPkCerts().stream().map(Cert::getAlias).collect(Collectors.toSet());
                PkCert defaultRuntimeSslCert = sslServerPcm.getDefaultActiveServerPkCert();
                PkCert defaultAdminSslCert = adminSslServerPcm.getDefaultActiveServerPkCert();
                for (PkCert cert : sslServerCerts) {
                    CertItem item = this.createNewCertItem((Cert)cert);
                    if (activeCertAliases.contains(cert.getAlias())) {
                        item.setActive(true);
                        this.activateRuntimeCert((Cert)cert);
                    }
                    if (activeAdminCertAliases.contains(cert.getAlias())) {
                        item.setActiveAdminSslCert(true);
                        this.activateAdminCert((Cert)cert);
                    }
                    if (cert.getAlias().equals(defaultRuntimeSslCert.getAlias())) {
                        item.setDefaultSslServerRuntime(true);
                        this.defaultActiveRuntime = item;
                    }
                    if (cert.getAlias().equals(defaultAdminSslCert.getAlias())) {
                        item.setDefaultSslServerAdmin(true);
                        this.defaultActiveAdmin = item;
                    }
                    this.certs.add(item);
                }
                this.setMenuName("Manage SSL Server Certificates");
            }
        }
    }

    private CertItem createNewCertItem(Cert cert) {
        CertItem certItem = new CertItem(cert);
        if (!(this.getParent().getParentTasklet() instanceof CertificateExpiryWarningManagementTasklet) && this.selectedCert != null && this.selectedCert.equals((Object)cert)) {
            certItem.setActive(true);
        }
        if (this.secondarySelectedCert != null && this.secondarySelectedCert.equals((Object)cert)) {
            certItem.setActiveSecondary(true);
        }
        if (this.defaultActiveAdmin != null && this.defaultActiveAdmin.getCert().equals((Object)cert)) {
            certItem.setDefaultSslServerAdmin(true);
        }
        if (this.defaultActiveRuntime != null && this.defaultActiveRuntime.getCert().equals((Object)cert)) {
            certItem.setDefaultSslServerRuntime(true);
        }
        return certItem;
    }

    /*
     * Unable to fully structure code
     */
    public void save() {
        this.selectedCert = null;
        this.secondarySelectedCert = null;
        try {
            auditLoggerScope = new AuditLoggerScope();
            try {
                switch (1.$SwitchMap$com$pingidentity$fsm$tasklet$data$CertificateTypes$ValidTypes[this.certType.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        connectionCerts = new ConnectionCerts();
                        connectionCerts.setVerificationCerts(new ArrayList<Cert>(this.getActiveCerts()), this.getInactiveCerts());
                        this.dsigVerificationCerts = connectionCerts;
                        iuca = this.findParent(InUseCertsApi.class);
                        if (iuca != null) {
                            iuca.setDsigConnectionCerts(this.dsigVerificationCerts);
                        }
                        this.selectedCert = this.dsigVerificationCerts.getActiveVerificationCert();
                        ** break;
lbl16:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        iuca = this.findParent(InUseCertsApi.class);
                        if (iuca != null) {
                            xmlEncryptionCerts = new ConnectionCerts();
                            otherXmlEncryptionCerts = new HashSet<Cert>();
                            for (CertItem item : this.certs) {
                                if (item.isItDeleted()) continue;
                                if (item.isActive()) {
                                    this.selectedCert = item.getCert();
                                    otherXmlEncryptionCerts.add(this.selectedCert);
                                    continue;
                                }
                                otherXmlEncryptionCerts.add(item.getCert());
                            }
                            xmlEncryptionCerts.setVerificationCerts(new ArrayList<Cert>(Collections.singletonList(this.selectedCert)), otherXmlEncryptionCerts);
                            this.dsigVerificationCerts = xmlEncryptionCerts;
                            ** break;
lbl35:
                            // 1 sources

                        } else {
                            certManager = (PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager();
                            encCerts = new HashSet<Cert>();
                            for (CertItem item : this.certs) {
                                if (item.isItDeleted()) continue;
                                encCerts.add(item.getCert());
                                if (!item.isActive()) continue;
                                this.selectedCert = item.getCert();
                            }
                            certManager.saveCertsForFeature(encCerts, this.getCertificateFeatureName());
                            ** break;
                        }
lbl47:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        sslPcm = MgmtFactory.getSslAuthPkCertManager();
                        sslCerts = new HashSet<PkCert>();
                        for (CertItem item : this.certs) {
                            if (item.isItDeleted()) continue;
                            sslCerts.add((PkCert)item.getCert());
                            if (!item.isActive()) continue;
                            this.selectedCert = item.getCert();
                        }
                        sslPcm.savePkCerts(sslCerts);
                        this.logAllCertChanges(this.getMessage("Ssl_cert_auth"), auditLoggerScope);
                        ** break;
lbl61:
                        // 1 sources

                        break;
                    }
                    case 6: 
                    case 7: {
                        dsigPcm = MgmtFactory.getDsigPkCertManager();
                        dsigCerts = new HashSet<PkCert>();
                        for (CertItem item : this.certs) {
                            if (item.isItDeleted()) continue;
                            dsigCerts.add((PkCert)item.getCert());
                            if (item.isActive()) {
                                this.selectedCert = item.getCert();
                            }
                            if (!item.isActiveSecondary()) continue;
                            this.secondarySelectedCert = item.getCert();
                        }
                        dsigPcm.savePkCerts(dsigCerts);
                        this.logAllCertChanges(this.getMessage("Dsig_cert"), auditLoggerScope);
                        ** break;
lbl77:
                        // 1 sources

                        break;
                    }
                    case 8: {
                        otherCerts = new HashSet<Cert>();
                        for (CertItem item : this.certs) {
                            if (item.isItDeleted()) continue;
                            if (item.isActive()) {
                                this.selectedCert = item.getCert();
                                otherCerts.add(this.selectedCert);
                                continue;
                            }
                            otherCerts.add(item.getCert());
                        }
                        this.sslVerificationCerts = otherCerts;
                        ** break;
lbl92:
                        // 1 sources

                        break;
                    }
                    case 9: {
                        tcm = MgmtFactory.getTrustedCAsManager();
                        trustedCerts = new HashSet<Cert>();
                        for (CertItem item : this.certs) {
                            if (item.isItDeleted()) continue;
                            trustedCerts.add(item.getCert());
                        }
                        tcm.saveTrustedCAs(trustedCerts);
                        this.logAllCertChanges(this.getMessage("Ca_cert"), auditLoggerScope);
                        ** break;
lbl104:
                        // 1 sources

                        break;
                    }
                    case 10: {
                        activeRuntimeCerts = new HashSet<PkCert>();
                        activeAdminCerts = new HashSet<PkCert>();
                        sslServerPcm = MgmtFactory.getSslServerPkCertManager();
                        sslServerCerts = new HashSet<PkCert>();
                        for (CertItem item : this.certs) {
                            if (item.isItDeleted()) continue;
                            if (item.isActive()) {
                                activeRuntimeCerts.add((PkCert)item.getCert());
                            }
                            if (item.isActiveAdminSslCert()) {
                                activeAdminCerts.add((PkCert)item.getCert());
                            }
                            sslServerCerts.add((PkCert)item.getCert());
                        }
                        sslServerPcm.savePkCerts(sslServerCerts);
                        sslServerPcm.setDefaultActiveServerPkCert((PkCert)this.defaultActiveRuntime.getCert());
                        sslServerPcm.setActiveServerPkCerts(activeRuntimeCerts);
                        adminSslServerPcm = MgmtFactory.getAdminSslServerPkCertManager();
                        if (!activeAdminCerts.isEmpty()) {
                            adminSslServerPcm.setDefaultActiveServerPkCert((PkCert)this.defaultActiveAdmin.getCert());
                            adminSslServerPcm.setActiveServerPkCerts(activeAdminCerts);
                        } else {
                            adminSslServerPcm.setDefaultActiveServerPkCert((PkCert)this.defaultActiveRuntime.getCert());
                            adminSslServerPcm.setActiveServerPkCerts(activeRuntimeCerts);
                        }
                        if (MgmtFactory.getJCEManager().retrieveCertOnSign()) {
                            activeRuntimeCerts = sslServerPcm.getActiveServerPkCerts();
                            activeAdminCerts = adminSslServerPcm.getActiveServerPkCerts();
                        }
                        this.logAllCertChanges(this.getMessage("Ssl_server_cert"), auditLoggerScope);
                        this.certs = new ArrayList<CertItem>();
                        tmpSslServerCerts = sslServerPcm.getPkCerts();
                        defaultActiveRuntime = sslServerPcm.getDefaultActiveServerPkCert();
                        defaultActiveAdmin = adminSslServerPcm.getDefaultActiveServerPkCert();
                        for (PkCert cert : tmpSslServerCerts) {
                            item = this.createNewCertItem((Cert)cert);
                            if (activeRuntimeCerts.stream().anyMatch((Predicate<PkCert>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$save$2(com.pingidentity.crypto.PkCert com.pingidentity.crypto.PkCert ), (Lcom/pingidentity/crypto/PkCert;)Z)((PkCert)cert))) {
                                item.setActive(true);
                                auditLoggerScope.log(AdminAuditLogger.Component.CERTIFICATE, AdminAuditLogger.Event.ACTIVATE, this.getMessage("Ssl_server_cert") + " - Runtime - " + item.getCert().getX509Certificate().getSubjectDN().getName());
                            }
                            if (activeAdminCerts.stream().anyMatch((Predicate<PkCert>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$save$3(com.pingidentity.crypto.PkCert com.pingidentity.crypto.PkCert ), (Lcom/pingidentity/crypto/PkCert;)Z)((PkCert)cert))) {
                                item.setActiveAdminSslCert(true);
                                auditLoggerScope.log(AdminAuditLogger.Component.CERTIFICATE, AdminAuditLogger.Event.ACTIVATE, this.getMessage("Ssl_server_cert") + " - Admin Console - " + item.getCert().getX509Certificate().getSubjectDN().getName());
                            }
                            if (cert.getAlias().equals(defaultActiveRuntime.getAlias())) {
                                this.defaultActiveRuntime = item;
                                auditLoggerScope.log(AdminAuditLogger.Component.CERTIFICATE, AdminAuditLogger.Event.ACTIVATE, this.getMessage("Ssl_server_cert") + " - Default Runtime - " + item.getCert().getX509Certificate().getSubjectDN().getName());
                            }
                            if (cert.getAlias().equals(defaultActiveAdmin.getAlias())) {
                                this.defaultActiveAdmin = item;
                                auditLoggerScope.log(AdminAuditLogger.Component.CERTIFICATE, AdminAuditLogger.Event.ACTIVATE, this.getMessage("Ssl_server_cert") + " - Default Admin Console - " + item.getCert().getX509Certificate().getSubjectDN().getName());
                            }
                            this.certs.add(item);
                        }
                        break;
                    }
                    ** default:
lbl158:
                    // 1 sources

                    break;
                }
            }
            finally {
                auditLoggerScope.close();
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Exception while attempting to save certs.", (Throwable)e);
            delegate = this.getParent().getDelegate();
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Save_failed", new Object[]{e.getMessage()}), ValidationConstraint.REQUIRED);
            this.populate(null);
        }
    }

    private void logAllCertChanges(String message, AuditLoggerScope auditLoggerScope) {
        for (CertItem item : this.certs) {
            this.logCertChange(item, message, auditLoggerScope);
        }
    }

    private void logCertChange(CertItem item, String certType, AuditLoggerScope auditLoggerScope) {
        if (!item.isItDeleted()) {
            Cert cert;
            if (item.isNewCert()) {
                auditLoggerScope.log(AdminAuditLogger.Component.CERTIFICATE, AdminAuditLogger.Event.CREATE, certType + " - " + item.getCert().getX509Certificate().getSubjectDN().getName());
                item.setNewCert(false);
            }
            if ((cert = item.getCert()) instanceof PkCert && ((PkCert)(cert = (PkCert)cert)).isNewlySigned()) {
                auditLoggerScope.log(AdminAuditLogger.Component.CERTIFICATE, AdminAuditLogger.Event.SIGNED, certType + " - " + item.getCert().getX509Certificate().getSubjectDN().getName());
            }
        } else if (!item.isNewCert()) {
            auditLoggerScope.log(AdminAuditLogger.Component.CERTIFICATE, AdminAuditLogger.Event.DELETE, certType + " - " + item.getCert().getX509Certificate().getSubjectDN().getName());
        }
    }

    public String getFinishLabel() {
        String finishLabel = null;
        switch (this.certType) {
            case dsigVerificationCert: 
            case ocspDsigVerificationCert: 
            case wsTrustDsigVerificationCert: 
            case xmlEncryptionCert: 
            case sslCertVerification: {
                finishLabel = "Done";
                break;
            }
            case sslCertAuth: 
            case dsigSigningCert: 
            case xmlDecryptionCert: 
            case trustedCAs: 
            case sslServerCerts: {
                finishLabel = "Save";
            }
        }
        return finishLabel;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        boolean activeCert = false;
        if (this.getCertType() == CertificateTypes.ValidTypes.sslServerCerts) {
            for (CertItem item : this.certs) {
                activeCert = activeCert || item.isActive();
            }
            if (!activeCert) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Must_specify_active_cert"), ValidationConstraint.REQUIRED);
            }
        }
    }

    private boolean hasSameDisplayName(Cert existingCert, Cert newCert) {
        return existingCert.getDescriptionForDisplay(35).equals(newCert.getDescriptionForDisplay(35));
    }

    private boolean hasSameFingerPrint(Cert existingCert, Cert newCert) {
        return existingCert.getFingerPrint(HashAlgorithm.SHA256).equals(newCert.getFingerPrint(HashAlgorithm.SHA256));
    }

    public boolean doesCertAlreadyExist(Cert certToTest) {
        return this.certs.stream().anyMatch(certItem -> this.hasSameDisplayName(certItem.getCert(), certToTest) || this.hasSameFingerPrint(certItem.getCert(), certToTest));
    }

    @Override
    public void setTaskletToEdit(Tasklet taskletToEdit) {
        if (this.isAuthorizedForAction()) {
            CertApi certTasklet;
            CertItem newCertItem;
            if (!taskletToEdit.isCancelled() && !(taskletToEdit instanceof DSignRotationTasklet) && (newCertItem = (certTasklet = (CertApi)((Object)taskletToEdit)).getCertItem()) != null) {
                if (this.useDefaultSelectedCertFunctionality) {
                    if (newCertItem.isActive()) {
                        this.selectedCert = newCertItem.getCert();
                        if ((this.getCertType() != CertificateTypes.ValidTypes.dsigVerificationCert || this.getCertType() != CertificateTypes.ValidTypes.ocspDsigVerificationCert || this.getCertType() != CertificateTypes.ValidTypes.wsTrustDsigVerificationCert) && this.getCertType() != CertificateTypes.ValidTypes.sslServerCerts) {
                            for (CertItem certItem : this.certs) {
                                certItem.setActive(false);
                            }
                        }
                        this.activateRuntimeCert(newCertItem.getCert());
                    }
                    if (newCertItem.isActiveAdminSslCert()) {
                        this.activateAdminCert(newCertItem.getCert());
                    }
                } else {
                    newCertItem.setActive(false);
                    this.selectedCert = null;
                }
                this.certs.add(newCertItem);
                if (this.getCertType() == CertificateTypes.ValidTypes.dsigVerificationCert || this.getCertType() == CertificateTypes.ValidTypes.ocspDsigVerificationCert || this.getCertType() == CertificateTypes.ValidTypes.wsTrustDsigVerificationCert) {
                    if (newCertItem.isActive()) {
                        this.setPrimaryVerificationCert(newCertItem.getCert());
                    } else {
                        this.inactiveCerts.add(newCertItem.getCert());
                    }
                }
            }
        } else {
            this.delegate.setFormComponent(null);
            this.delegate.record("Not_authorized_create_new", ValidationConstraint.REQUIRED);
        }
    }

    public void activate(Integer certToActivate) {
        if (this.getCertType() == CertificateTypes.ValidTypes.sslServerCerts) {
            CertItem item = this.certs.get(certToActivate);
            item.setActive(true);
            this.activateRuntimeCert(item.getCert());
        } else {
            for (CertItem item : this.certs) {
                item.setActive(false);
            }
            CertItem item = this.certs.get(certToActivate);
            item.setActive(true);
        }
        this.save();
    }

    public void activateDefaultRuntime(Integer certToActivate) {
        this.defaultActiveRuntime.setDefaultSslServerRuntime(false);
        CertItem item = this.certs.get(certToActivate);
        item.setDefaultSslServerRuntime(true);
        this.defaultActiveRuntime = item;
        this.save();
    }

    public void activateDefaultAdmin(Integer certToActivate) {
        this.defaultActiveAdmin.setDefaultSslServerAdmin(false);
        CertItem item = this.certs.get(certToActivate);
        item.setDefaultSslServerAdmin(true);
        this.defaultActiveAdmin = item;
        this.save();
    }

    public void deactivate(Integer cert) {
        CertItem item = this.certs.get(cert);
        item.setActive(false);
        this.deactivateRuntimeCert(item.getCert());
        this.save();
    }

    public boolean isEnableDeactivateRuntimeCert() {
        return this.activeCerts.size() > 1;
    }

    private void setPrimaryVerificationCert(Cert cert) {
        LinkedHashSet<Cert> newActiveVerificationCerts = new LinkedHashSet<Cert>();
        newActiveVerificationCerts.add(cert);
        newActiveVerificationCerts.addAll(this.activeCerts);
        this.activeCerts = newActiveVerificationCerts;
        this.inactiveCerts.remove(cert);
    }

    public void activateVerificationCert(Integer certIndex) {
        CertItem item = this.certs.get(certIndex);
        if (!this.activeCerts.contains(item.getCert())) {
            item.setActive(true);
            this.setPrimaryVerificationCert(item.getCert());
        }
        this.save();
    }

    public void deactivateVerificationCert(Integer certIndex) {
        CertItem item = this.certs.get(certIndex);
        if (this.activeCerts.contains(item.getCert())) {
            item.setActive(false);
            this.activeCerts.remove(item.getCert());
            this.inactiveCerts.add(item.getCert());
        }
        this.save();
    }

    public void activateOcspVerificationCert(Integer certToActivate) {
        LinkedHashSet<Cert> activeCerts = new LinkedHashSet<Cert>();
        LinkedHashSet<Cert> inactiveCerts = new LinkedHashSet<Cert>();
        for (int index = 0; index < this.certs.size(); ++index) {
            CertItem certItem = this.certs.get(index);
            if (index == certToActivate) {
                certItem.setActive(true);
                activeCerts.add(certItem.getCert());
                continue;
            }
            certItem.setActive(false);
            inactiveCerts.add(certItem.getCert());
        }
        this.setActiveCerts(activeCerts);
        this.setInactiveCerts(inactiveCerts);
        this.save();
    }

    public void deactivateOcspVerificationCert(Integer certToActivate) {
        LinkedHashSet<Cert> inactiveCerts = new LinkedHashSet<Cert>();
        for (CertItem certItem : this.certs) {
            certItem.setActive(false);
            inactiveCerts.add(certItem.getCert());
        }
        this.setActiveCerts(new LinkedHashSet<Cert>());
        this.setInactiveCerts(inactiveCerts);
        this.save();
    }

    public void activateWsTrustDsigVerificationCert(Integer certToActivate) {
        CertItem certItem = this.getCertByIndex(certToActivate);
        if (certItem != null) {
            certItem.setActive(true);
            this.getActiveCerts().add(certItem.getCert());
            this.getInactiveCerts().remove(certItem.getCert());
            WsTrustListUIEntry newEntry = new WsTrustListUIEntry();
            newEntry.setEntry(certItem.getCert().getDescriptionForDisplay(35));
            newEntry.setCert(certItem.getCert());
            ((WsTrustRestrictByCertState)this.getParent().getParentTasklet().getCurrentState()).getListEntries().add(newEntry);
        }
    }

    public void deactivateWsTrustDsigVerificationCert(Integer certToDeactivate) {
        CertItem certItem = this.getCertByIndex(certToDeactivate);
        if (certItem != null) {
            certItem.setActive(false);
            certItem.setAlreadyInUse(false);
            this.getActiveCerts().remove(certItem.getCert());
            this.getInactiveCerts().add(certItem.getCert());
            ((WsTrustRestrictByCertState)this.getParent().getParentTasklet().getCurrentState()).getListEntries().removeIf(certificate -> certificate.getCert().equals((Object)certItem.getCert()));
        }
    }

    public void activateAdminSslCert(Integer certToActivate) {
        CertItem item = this.certs.get(certToActivate);
        item.setActiveAdminSslCert(true);
        this.activateAdminCert(item.getCert());
        this.save();
    }

    public void deactivateAdminSslCert(Integer cert) {
        CertItem item = this.certs.get(cert);
        item.setActiveAdminSslCert(false);
        this.deactivateAdminCert(item.getCert());
        this.save();
    }

    private void activateRuntimeCert(Cert item) {
        this.toggleSslCertStatus(true, this.activeCerts, item);
    }

    private void activateAdminCert(Cert item) {
        this.toggleSslCertStatus(true, this.activeAdminCerts, item);
    }

    private void deactivateRuntimeCert(Cert item) {
        this.toggleSslCertStatus(false, this.activeCerts, item);
    }

    private void deactivateAdminCert(Cert item) {
        this.toggleSslCertStatus(false, this.activeAdminCerts, item);
    }

    private void toggleSslCertStatus(boolean active, Set<Cert> set, Cert cert) {
        if (this.getCertType() == CertificateTypes.ValidTypes.sslServerCerts) {
            if (active) {
                set.add(cert);
            } else {
                set.remove(cert);
            }
        }
    }

    public boolean isEnableDeactivateAdminSslCert() {
        return this.activeAdminCerts.size() > 1;
    }

    public void delete(Integer certToDelete) {
        CertItem item;
        item.setItDeleted(!(item = this.certs.get(certToDelete)).isItDeleted());
        if (this.activeCerts != null && this.activeCerts.contains(item.getCert())) {
            this.activeCerts.remove(item.getCert());
        }
        if (this.inactiveCerts != null && this.inactiveCerts.contains(item.getCert())) {
            this.inactiveCerts.remove(item.getCert());
        }
        this.deactivateRuntimeCert(item.getCert());
        this.deactivateAdminCert(item.getCert());
        this.save();
    }

    public boolean isCertInUse(Integer certIndex) {
        boolean inUse;
        CertItem item = this.certs.get(certIndex);
        if (item == null) {
            return false;
        }
        switch (this.certType) {
            case trustedCAs: {
                TrustedCAsManager trustedCAsManager = MgmtFactory.getTrustedCAsManager();
                inUse = trustedCAsManager.isInUse(item.getCert().getX509Certificate());
                break;
            }
            case dsigSigningCert: 
            case xmlDecryptionCert: {
                PkCertManager dsigPcm = MgmtFactory.getDsigPkCertManager();
                inUse = dsigPcm.isInUse((PkCert)item.getCert());
                break;
            }
            case sslCertAuth: {
                inUse = item.isInUseAsAuthCert();
                break;
            }
            case sslServerCerts: {
                inUse = item.isActiveAdminSslCert() || item.isDefaultSslServerRuntime();
                break;
            }
            default: {
                inUse = item.isActive();
            }
        }
        return inUse;
    }

    @Override
    public boolean isAuthorizedForAction() {
        return this.getCurrentUser().isCryptoManager() || this.getCurrentUser().isAdmin();
    }

    public List<CertItem> getCerts() {
        return this.certs;
    }

    public void setCerts(ArrayList<CertItem> certs) {
        this.certs = certs;
    }

    public CertItem getCertByIndex(Integer index) {
        return this.certs.get(index);
    }

    @Override
    public Cert getCert(int index) {
        return this.certs.get(index).getCert();
    }

    public CertificateTypes.ValidTypes getCertType() {
        return this.certType;
    }

    public void setCertType(CertificateTypes.ValidTypes certType) {
        this.certType = certType;
    }

    public Cert getSelectedCert() {
        return this.selectedCert;
    }

    public void setSelectedCert(Cert selectedCert) {
        this.selectedCert = selectedCert;
    }

    public Cert getSecondarySelectedCert() {
        return this.secondarySelectedCert;
    }

    public void setSecondarySelectedCert(Cert secondarySelectedCert) {
        this.secondarySelectedCert = secondarySelectedCert;
    }

    public ConnectionCerts getDsigVerificationCerts() {
        return this.dsigVerificationCerts;
    }

    public void setDsigVerificationCerts(ConnectionCerts dsigVerificationCerts) {
        this.dsigVerificationCerts = dsigVerificationCerts;
    }

    public Set<Cert> getSslVerificationCerts() {
        return this.sslVerificationCerts;
    }

    public void setSslVerificationCerts(Set<Cert> sslVerificationCerts) {
        this.sslVerificationCerts = sslVerificationCerts;
    }

    public void setCurrentCert(CertItem ci) {
        this.currentCert = ci;
    }

    public boolean getUseDefaultSelectedCertFunctionality() {
        return this.useDefaultSelectedCertFunctionality;
    }

    public void setUseDefaultSelectedCertFunctionality(boolean useDefaultSelectedCertFunctionality) {
        this.useDefaultSelectedCertFunctionality = useDefaultSelectedCertFunctionality;
    }

    public String getCertificateFeatureName() {
        return this.certificateFeatureName;
    }

    public void setCertificateFeatureName(String name) {
        this.certificateFeatureName = name;
    }

    public boolean showCheckUsageLink() {
        switch (this.certType) {
            case dsigVerificationCert: 
            case ocspDsigVerificationCert: 
            case wsTrustDsigVerificationCert: 
            case xmlEncryptionCert: 
            case sslCertVerification: 
            case sslServerCerts: {
                return false;
            }
        }
        return true;
    }

    public String getKeyDetails() {
        String keySize = this.currentCert.getCert().getPublicKeySize() == null ? "" : this.currentCert.getCert().getPublicKeySize().toString();
        return this.currentCert.getCert().getPublicKeyAlgorithm() + " " + keySize;
    }

    public String getProvider() {
        if (this.currentCert.isStoredOnHSM()) {
            return "HSM";
        }
        return "Local";
    }

    public LinkedHashSet<Cert> getActiveCerts() {
        return this.activeCerts;
    }

    public void setActiveCerts(LinkedHashSet<Cert> activeCerts) {
        this.activeCerts = activeCerts;
    }

    public Set<Cert> getInactiveCerts() {
        return this.inactiveCerts;
    }

    public void setInactiveCerts(Set<Cert> inactiveCerts) {
        this.inactiveCerts = inactiveCerts;
    }

    public void activateSecondary(Integer certToActivate) {
        CertItem item = this.certs.get(certToActivate);
        for (CertItem certItem : this.certs) {
            certItem.setActiveSecondary(false);
        }
        item.setActiveSecondary(true);
        this.secondarySelectedCert = item.getCert();
        this.save();
    }

    public void deactivateSecondary(Integer certToActivate) {
        CertItem item = this.certs.get(certToActivate);
        item.setActiveSecondary(false);
        this.secondarySelectedCert = null;
        this.save();
    }

    public void clearDeleteCerts() {
        this.certs = this.certs.stream().filter(cert -> !cert.isItDeleted()).collect(Collectors.toList());
    }

    private static /* synthetic */ boolean lambda$save$3(PkCert cert, PkCert activeCert) {
        return activeCert.getAlias().equals(cert.getAlias());
    }

    private static /* synthetic */ boolean lambda$save$2(PkCert cert, PkCert activeCert) {
        return activeCert.getAlias().equals(cert.getAlias());
    }
}

