/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.CertApi;
import com.pingidentity.fsm.tasklet.data.CertItem;
import com.pingidentity.fsm.tasklet.impl.CertManagementTasklet;
import com.pingidentity.fsm.tasklet.impl.ExportCertTasklet;
import com.pingidentity.fsm.tasklet.impl.ImportCertTasklet;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.log.AdminAuditLogger;

public class CertSummaryState
extends SummaryCardState {
    private static final long serialVersionUID = 20050515L;
    private boolean active = true;
    private boolean activeAdminSslCert = true;
    private boolean downloadButtonVisible;

    public CertSummaryState(Tasklet value) {
        super(value);
        this.setMenuName("Summary");
    }

    @Override
    public String getNoteKey() {
        if (((CertApi)((Object)this.getParent())).isActivatable()) {
            boolean isVertCertImport = this.getParent() instanceof ImportCertTasklet && ((ImportCertTasklet)this.getParent()).isVerificationCertImport();
            return super.getNoteKey() + "_Activatable" + (isVertCertImport ? "_Vert_Cert" : "");
        }
        return super.getNoteKey();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Tasklet parentTasklet = this.getParent();
        if (parentTasklet instanceof ImportCertTasklet) {
            ImportCertTasklet importCertTasklet = (ImportCertTasklet)parentTasklet;
            CertItem certItem = importCertTasklet.getCertItem();
            CertManagementTasklet t = this.findParent(CertManagementTasklet.class);
            if (t != null && t.doesCertAlreadyExist(certItem.getCert())) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Cannot_import_duplicate_cert_exists"), ValidationConstraint.REQUIRED);
            }
        }
        if (parentTasklet instanceof ExportCertTasklet) {
            ExportCertTasklet tasklet = (ExportCertTasklet)parentTasklet;
            if (this.downloadButtonVisible && !tasklet.isExported()) {
                this.recordErrorMsg(this.getMessage("Common", "Export_not_clicked"));
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActiveAdminSslCert() {
        return this.activeAdminSslCert;
    }

    public void setActiveAdminSslCert(boolean activeAdminSslCert) {
        this.activeAdminSslCert = activeAdminSslCert;
    }

    public boolean isDownloadButtonVisible() {
        return this.downloadButtonVisible;
    }

    public void setDownloadButtonVisible(boolean downloadButtonVisible) {
        this.downloadButtonVisible = downloadButtonVisible;
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    public AdminAuditLogger.Component getAuditLoggerComponent() {
        return AdminAuditLogger.Component.CERTIFICATE;
    }
}

