/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.CibaRequestHandlingPolicyValidator;
import com.pingidentity.component.common.FieldItem;
import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableEditor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.impl.Wizard;
import com.pingidentity.fsm.state.impl.CibaPoliciesManagementState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.xmlbeans.XmlCalendar;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.saml20.domain.OOBAuthPluginInstance;
import org.sourceid.saml20.domain.PasswordCredentialValidatorInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.profiles.sp.UrlMatchingServiceOneStarImpl;

public class CibaPolicyManagementState
extends TaskletState
implements TableEditor.TableEditorListener,
Serializable {
    private static final long serialVersionUID = 20130222L;
    private String id;
    private String name;
    private String pluginId;
    private String pcvId;
    private boolean allowUnsignedLoginHintToken;
    private boolean requireHintToken;
    private String transactionLifeInSeconds = "120";
    private StringPairPropertySelectionModel pluginIdList;
    private StringPairPropertySelectionModel pcvIdList;
    private List<TableRow> jwksTable = new ArrayList<TableRow>();
    private transient Object componentState;
    private List<SimpleFieldDescriptor> ALT_HINT_TOKEN_ISSUERS_COLUMN_DESCRIPTORS;
    private final SimpleFieldDescriptor ISSUER_DESC = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Issuer", 200);
    private final SimpleFieldDescriptor JWKS_URL_DESC = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "JWKS URL", 275);
    private final SimpleFieldDescriptor JWKS_DESC = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "JWKS", 275);

    public CibaPolicyManagementState(IWizard owner, String name) {
        super(owner, name);
        this.setMenuName("Manage Policy");
        this.createPluginIdList();
        this.createPcvIdList();
    }

    public CibaPolicyManagementState(IWizard owner) {
        super(owner);
        this.setMenuName("Manage Policy");
        this.createPluginIdList();
        this.createPcvIdList();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.jwksTable = new ArrayList<TableRow>();
        if (dataFromDisk != null) {
            CibaServerPolicy.RequestHandlingPolicy policy = (CibaServerPolicy.RequestHandlingPolicy)dataFromDisk;
            this.id = policy.getId();
            this.name = policy.getName();
            this.pluginId = policy.getPluginId();
            this.pcvId = policy.getUserCodePcvId();
            this.allowUnsignedLoginHintToken = policy.isAllowUnsignedLoginHintToken();
            this.requireHintToken = policy.isRequireTokenForHint();
            this.transactionLifeInSeconds = String.valueOf(policy.getTransactionLifeInSeconds());
            for (CibaServerPolicy.RequestHandlingPolicy.AlternativeLoginHintTokenIssuer persistedJwks : policy.getAlternativeLoginHintTokenIssuers()) {
                this.jwksTable.add(this.makeRowFromEntry(persistedJwks.getIssuer(), persistedJwks.isJwksDataReference() ? persistedJwks.getJwksData() : "", !persistedJwks.isJwksDataReference() ? persistedJwks.getJwksData() : ""));
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        CibaServerPolicy.RequestHandlingPolicy policy = (CibaServerPolicy.RequestHandlingPolicy)dataToDisk;
        this.fillDomain(policy);
        CibaPoliciesManagementState cibaPoliciesManagementState = Optional.of(this.getParent()).map(Tasklet::getParentTasklet).map(Wizard::getCurrentState).filter(iWizardState -> iWizardState instanceof CibaPoliciesManagementState).map(iWizardState -> (CibaPoliciesManagementState)iWizardState).orElse(null);
        if (cibaPoliciesManagementState != null && (StringUtils.isBlank((String)cibaPoliciesManagementState.getDefaultPolicyId()) || cibaPoliciesManagementState.getTaskletFromList(cibaPoliciesManagementState.getDefaultPolicyId()).isItDeleted())) {
            cibaPoliciesManagementState.setDefaultPolicy(policy.getId());
        }
        return true;
    }

    private void fillDomain(CibaServerPolicy.RequestHandlingPolicy policy) {
        policy.setId(this.id);
        policy.setName(this.name);
        policy.setPluginId(this.pluginId);
        policy.setUserCodePcvId(this.pcvId);
        policy.setAllowUnsignedLoginHintToken(this.allowUnsignedLoginHintToken);
        policy.setRequireTokenForHint(this.requireHintToken);
        try {
            policy.setTransactionLifeInSeconds(Integer.parseInt(this.transactionLifeInSeconds));
        }
        catch (NumberFormatException e) {
            this.transactionLifeInSeconds = "120";
            policy.setTransactionLifeInSeconds(Integer.parseInt(this.transactionLifeInSeconds));
        }
        ArrayList<CibaServerPolicy.RequestHandlingPolicy.AlternativeLoginHintTokenIssuer> altLoginHintTokenIssuerList = new ArrayList<CibaServerPolicy.RequestHandlingPolicy.AlternativeLoginHintTokenIssuer>();
        for (TableRow row : this.jwksTable) {
            if (row.isMarkedForDelete()) continue;
            String jwksData = StringUtils.isNotEmpty((String)this.getJwksUrlDesc(row)) ? this.getJwksUrlDesc(row) : this.getJwksDesc(row);
            boolean isJwksDataReferenceDesc = StringUtils.isNotEmpty((String)this.getJwksUrlDesc(row));
            CibaServerPolicy.RequestHandlingPolicy.AlternativeLoginHintTokenIssuer alternativeLoginHintTokenIssuer = new CibaServerPolicy.RequestHandlingPolicy.AlternativeLoginHintTokenIssuer(this.getIssuerDesc(row), jwksData, isJwksDataReferenceDesc);
            altLoginHintTokenIssuerList.add(alternativeLoginHintTokenIssuer);
        }
        policy.setAlternativeLoginHintTokenIssuers(altLoginHintTokenIssuerList);
        policy.setLastModified((Calendar)new XmlCalendar(new Date()));
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        this.validate(delegate);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Policy ID", this.getId(), this));
        summaryList.add(new SummaryInfo("Policy Name", this.getName(), this));
        summaryList.add(new SummaryInfo("Authenticator", this.getOOBPluginName(), this));
        summaryList.add(new SummaryInfo("User Code PCV", this.getPcvName(), this));
        summaryList.add(new SummaryInfo("Transaction Lifetime (seconds)", this.getTransactionLifeInSeconds(), this));
        summaryList.add(new SummaryInfo("Allow Unsigned Login Hint Token", Boolean.toString(this.isAllowUnsignedLoginHintToken()), this));
        summaryList.add(new SummaryInfo("Require Token for Identity Hint", Boolean.toString(this.isRequireHintToken()), this));
        if (this.jwksTable == null || this.jwksTable.isEmpty()) {
            summaryList.add(new SummaryInfo("Alternative Login Hint Token Issuers", "", this));
        } else if (!this.jwksTable.isEmpty()) {
            for (TableRow tableRow : this.jwksTable) {
                StringBuilder rowValue = new StringBuilder();
                ArrayList<String> displayList = new ArrayList<String>();
                if (tableRow.isMarkedForDelete()) continue;
                for (FieldItem fieldItem : tableRow.getFields()) {
                    String displayItem = fieldItem.getValue();
                    if (StringUtils.isBlank((String)displayItem)) continue;
                    displayList.add(displayItem);
                }
                for (int i = 0; i < displayList.size(); ++i) {
                    rowValue.append((String)displayList.get(i));
                    if (i >= displayList.size() - 1) continue;
                    rowValue.append(", ");
                }
                summaryList.add(new SummaryInfo("Alternative Login Hint Token Issuers", rowValue.toString(), this));
            }
        }
    }

    public boolean isCreateMode() {
        Tasklet t = this.getParent();
        return t.getMode() == Mode.create;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id.trim();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getOOBPluginName() {
        return ((OOBAuthPluginInstance)MgmtFactory.getOOBAuthPluginManager().getInstance(this.pluginId)).getName();
    }

    public String getPcvId() {
        return this.pcvId;
    }

    public void setPcvId(String pcvId) {
        this.pcvId = pcvId;
    }

    public String getPcvName() {
        return StringUtils.isEmpty((String)this.pcvId) ? "" : ((PasswordCredentialValidatorInstance)MgmtFactory.getCredentialValidatorManager().getInstance(this.pcvId)).getName();
    }

    public boolean isAllowUnsignedLoginHintToken() {
        return this.allowUnsignedLoginHintToken;
    }

    public void setAllowUnsignedLoginHintToken(boolean allowUnsignedLoginHintToken) {
        this.allowUnsignedLoginHintToken = allowUnsignedLoginHintToken;
    }

    public boolean isRequireHintToken() {
        return this.requireHintToken;
    }

    public void setRequireHintToken(boolean requireHintToken) {
        this.requireHintToken = requireHintToken;
    }

    public String getTransactionLifeInSeconds() {
        return this.transactionLifeInSeconds;
    }

    public void setTransactionLifeInSeconds(String transactionLifeInSeconds) {
        this.transactionLifeInSeconds = transactionLifeInSeconds;
    }

    public StringPairPropertySelectionModel getPluginIdList() {
        return this.pluginIdList;
    }

    public void setPluginIdList(StringPairPropertySelectionModel pluginIdList) {
        this.pluginIdList = pluginIdList;
    }

    public StringPairPropertySelectionModel getPcvIdList() {
        return this.pcvIdList;
    }

    public void setPcvIdList(StringPairPropertySelectionModel pcvIdList) {
        this.pcvIdList = pcvIdList;
    }

    private void createPluginIdList() {
        this.pluginIdList = new StringPairPropertySelectionModel(true);
        Collection oobAuthPluginInstanceCollection = MgmtFactory.getOOBAuthPluginManager().getInstances();
        for (OOBAuthPluginInstance oobAuthPluginInstance : oobAuthPluginInstanceCollection) {
            this.pluginIdList.add(oobAuthPluginInstance.getName(), oobAuthPluginInstance.getId());
        }
        this.pluginIdList.sort();
    }

    private void createPcvIdList() {
        this.pcvIdList = new StringPairPropertySelectionModel(true);
        Collection pcvInstanceCollection = MgmtFactory.getCredentialValidatorManager().getInstances();
        for (PasswordCredentialValidatorInstance passwordCredentialValidatorInstance : pcvInstanceCollection) {
            this.pcvIdList.add(passwordCredentialValidatorInstance.getName(), passwordCredentialValidatorInstance.getId());
        }
        this.pcvIdList.sort();
    }

    public boolean isShowPasswordCredentialValidatorButton() {
        return true;
    }

    public boolean isShowOOBAuthenticatorsButton() {
        return true;
    }

    public List<SimpleFieldDescriptor> getAlternativeLoginHintTokenIssuersColumnDescriptors() {
        ArrayList<SimpleFieldDescriptor> tableList = new ArrayList<SimpleFieldDescriptor>();
        tableList.add(this.ISSUER_DESC);
        tableList.add(this.JWKS_URL_DESC);
        tableList.add(this.JWKS_DESC);
        this.ALT_HINT_TOKEN_ISSUERS_COLUMN_DESCRIPTORS = tableList;
        return this.ALT_HINT_TOKEN_ISSUERS_COLUMN_DESCRIPTORS;
    }

    protected TableRow makeRowFromEntry(String issuer, String jwksURL, String jwks) {
        ArrayList<FieldItem> fields = new ArrayList<FieldItem>();
        fields.add(new FieldItem(this.ISSUER_DESC, issuer));
        fields.add(new FieldItem(this.JWKS_URL_DESC, jwksURL));
        fields.add(new FieldItem(this.JWKS_DESC, jwks));
        return new TableRow(fields);
    }

    protected String getIssuerDesc(TableRow row) {
        return row.getFields().get(0).getValue().trim();
    }

    protected String getJwksUrlDesc(TableRow row) {
        return row.getFields().get(1).getValue().trim();
    }

    protected String getJwksDesc(TableRow row) {
        return row.getFields().get(2).getValue().trim();
    }

    public List<TableRow> getJwksTable() {
        return this.jwksTable;
    }

    public void setJwksTable(List<TableRow> jwksTable) {
        this.jwksTable = jwksTable;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    private void validate(IValidationDelegate delegate) {
        CibaRequestHandlingPolicyValidator validator = new CibaRequestHandlingPolicyValidator.Builder().setId(this.id).setName(this.name).setPluginId(this.pluginId).setPcvId(this.pcvId).setTransactionLifeInSeconds(this.transactionLifeInSeconds).setIsCreateMode(this.isCreateMode()).build();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    private boolean hasErrorBeenCaughtByValidator(ApiMessageKey errorId, CibaRequestHandlingPolicyValidator validator) {
        boolean isErrorPartOfValidationErrors = false;
        if (!validator.getErrors().isEmpty()) {
            for (ValidationError validationError : validator.getErrors()) {
                if (!validationError.getErrorId().equals(errorId.getMsgKey())) continue;
                isErrorPartOfValidationErrors = true;
            }
        }
        return isErrorPartOfValidationErrors;
    }

    @Override
    public void onStateActivated() {
        this.createPluginIdList();
        this.createPcvIdList();
    }

    @Override
    public List<String> validate(TableRow row, TableRow originalRow, List<TableRow> list, TableEditor owner) {
        ArrayList<String> errors = new ArrayList<String>();
        String issuerBeingUpdated = this.getIssuerDesc(row);
        if (StringUtils.isBlank((String)issuerBeingUpdated)) {
            errors.add("Issuer is required.");
        } else if (originalRow == null || !this.getIssuerDesc(originalRow).equals(issuerBeingUpdated)) {
            for (TableRow tableRow : list) {
                if (!issuerBeingUpdated.equals(this.getIssuerDesc(tableRow))) continue;
                errors.add("Duplicate issuer '" + issuerBeingUpdated + "'.");
            }
        }
        if (StringUtils.isBlank((String)this.getJwksUrlDesc(row)) && StringUtils.isBlank((String)this.getJwksDesc(row))) {
            errors.add("Either 'JWKS URL' or 'JWKS' is required. Provide one of the two.");
        } else if (StringUtils.isNotBlank((String)this.getJwksUrlDesc(row)) && StringUtils.isBlank((String)this.getJwksDesc(row))) {
            UrlMatchingServiceOneStarImpl urlMatcher = new UrlMatchingServiceOneStarImpl();
            if (!urlMatcher.isValidUrlPattern(this.getJwksUrlDesc(row))) {
                errors.add("The JWKS URL '" + this.getJwksUrlDesc(row) + "' is malformed. Please verify correct syntax for the protocol--for example, use square brackets around IPv6 addresses.");
            }
        } else if (StringUtils.isBlank((String)this.getJwksUrlDesc(row)) && StringUtils.isNotBlank((String)this.getJwksDesc(row))) {
            try {
                JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(this.getJwksDesc(row));
                List keys = jsonWebKeySet.getJsonWebKeys();
                if (keys == null || keys.isEmpty()) {
                    errors.add("Invalid JWKS.");
                }
            }
            catch (ClassCastException | JoseException e) {
                errors.add("Invalid JWKS.");
            }
        }
        if (StringUtils.isNotBlank((String)this.getJwksUrlDesc(row)) && StringUtils.isNotBlank((String)this.getJwksDesc(row))) {
            errors.add("Either 'JWKS URL' or 'JWKS' is allowed.");
        }
        return errors;
    }

    @Override
    public void onAddItem(TableEditor owner, TableRow newRow) {
    }

    @Override
    public void onUpdateItem(TableEditor owner, TableRow originalRow, TableRow updatedRow) {
    }

    @Override
    public void refreshState() {
        this.createPluginIdList();
        this.createPcvIdList();
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        this.createPluginIdList();
        this.createPcvIdList();
    }

    @Override
    public void cancel(Object newData) {
        super.cancel(newData);
        this.setComponentState(null);
    }
}

