/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.DataMap;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.BaseConfigAttributeSourcesState;
import com.pingidentity.fsm.state.impl.CibaPolicyAttributeSourcesState;
import com.pingidentity.fsm.state.impl.CibaPolicyContractFulfillmentState;
import com.pingidentity.fsm.state.impl.CibaPolicyEnhanceRequestHintContractMappingState;
import com.pingidentity.fsm.state.impl.CibaPolicyManagementState;
import com.pingidentity.fsm.state.impl.CibaPolicyRequestHintContractState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.issuancecriteria.impl.CibaPolicyIssuanceCriteriaState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.util.SAML2MappingModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.openid.ciba.domain.CibaServerPolicyManager;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.OOBAuthPluginInstance;
import org.sourceid.saml20.domain.PasswordCredentialValidatorInstance;
import org.sourceid.saml20.domain.PersistentGrantAttribute;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class CibaPolicyManagementTasklet
extends MappingTasklet
implements AttributeNamesApi,
Serializable {
    private Operation operation = Operation.NONE;
    private CibaPolicyManagementState cibaPolicyManagementState;
    private CibaPolicyRequestHintContractState cibaPolicyRequestHintContractState;
    private CibaPolicyEnhanceRequestHintContractMappingState cibaPolicyEnhanceRequestHintContractMappingState;
    private CibaPolicyContractFulfillmentState cibaPolicyContractFulfillmentState;
    private CibaPolicyIssuanceCriteriaState cibaPolicyIssuanceCriteriaState;
    private SummaryCardState summaryCardState;

    public CibaPolicyManagementTasklet(Visit visit) {
        super("CibaPolicyManagementTasklet", "CIBA Policy");
        this.setSystemVisit(visit);
        this.cibaPolicyManagementState = new CibaPolicyManagementState(this);
        this.cibaPolicyRequestHintContractState = new CibaPolicyRequestHintContractState(this);
        this.cibaPolicyEnhanceRequestHintContractMappingState = new CibaPolicyEnhanceRequestHintContractMappingState(this);
        this.cibaPolicyContractFulfillmentState = new CibaPolicyContractFulfillmentState(this, "cibaPolicyContractFulfillment");
        this.cibaPolicyIssuanceCriteriaState = new CibaPolicyIssuanceCriteriaState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.cibaPolicyManagementState.addOutgoingTransition(this, this.cibaPolicyRequestHintContractState);
        this.cibaPolicyRequestHintContractState.addOutgoingTransition(this, this.cibaPolicyEnhanceRequestHintContractMappingState);
        this.cibaPolicyEnhanceRequestHintContractMappingState.addOutgoingTransition(this, this.configAttributeSourcesState);
        this.configAttributeSourcesState.addOutgoingTransition(this, this.cibaPolicyContractFulfillmentState);
        this.cibaPolicyContractFulfillmentState.addOutgoingTransition(this, this.cibaPolicyIssuanceCriteriaState);
        this.cibaPolicyIssuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
        this.setInitialState(this.cibaPolicyManagementState);
        this.setCancelAvailable(true);
    }

    public LinkedHashSet<String> getAllAttributeNames() {
        LinkedHashSet<String> attributes = new LinkedHashSet<String>();
        attributes.add("USER_KEY");
        attributes.addAll(this.getSelectedOOBAuthPluginInstance().getAttributeContract().getAllAttributeNames());
        if (this.getSelectedPCV() != null) {
            attributes.add("USER_CODE_USER_NAME");
        }
        List persistentGrantAttributes = MgmtFactory.getAuthzServerManager().getPersistentGrantExtendedAttributes();
        for (PersistentGrantAttribute persistentGrantAttribute : persistentGrantAttributes) {
            attributes.add(persistentGrantAttribute.getName());
        }
        return attributes;
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        ArrayList<String> attributes = new ArrayList<String>(this.getAllAttributeNames());
        Collections.sort(attributes, String.CASE_INSENSITIVE_ORDER);
        return attributes;
    }

    public Set<String> getAllRequestHintAttributeNames() {
        return this.cibaPolicyRequestHintContractState.getContract().getAllAttributeNames();
    }

    public List<String> getAllRequestHintAttrNamesSorted() {
        ArrayList<String> attributes = new ArrayList<String>(this.cibaPolicyRequestHintContractState.getContract().getAllAttributeNames());
        Collections.sort(attributes, String.CASE_INSENSITIVE_ORDER);
        return attributes;
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        return null;
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        return null;
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return null;
    }

    private OOBAuthPluginInstance getSelectedOOBAuthPluginInstance() {
        return (OOBAuthPluginInstance)MgmtFactory.getOOBAuthPluginManager().getInstance(this.cibaPolicyManagementState.getPluginId());
    }

    private PasswordCredentialValidatorInstance getSelectedPCV() {
        return this.cibaPolicyManagementState.getPcvId() != null ? (PasswordCredentialValidatorInstance)MgmtFactory.getCredentialValidatorManager().getInstance(this.cibaPolicyManagementState.getPcvId()) : null;
    }

    @Override
    public String getMappingSourceForDisplay() {
        return null;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    protected CibaServerPolicy.RequestHandlingPolicy getCibaPolicy() {
        CibaServerPolicy.RequestHandlingPolicy cibaPolicy = new CibaServerPolicy.RequestHandlingPolicy();
        this.save(cibaPolicy);
        return cibaPolicy;
    }

    public String getPolicyId() {
        return this.cibaPolicyManagementState.getId();
    }

    @Override
    public BaseConfigAttributeSourcesState constructConfigAttributeSourcesState() {
        return new CibaPolicyAttributeSourcesState(this, "configAttributeSources");
    }

    protected List<SourceContextType> getContextMappingTypes() {
        return SourceContextType.getContextTypesForCibaRequestMappings();
    }

    public String getName() {
        return this.cibaPolicyManagementState.getName();
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public String getNoteKeySuffix() {
        return "CIBA";
    }

    @Override
    public SAML2MappingModel getMappingModel() {
        return this.cibaPolicyContractFulfillmentState.getModel();
    }

    @Override
    public List<? extends TokenAuthorizationIssuanceCriterion> getIssuanceCriterion() {
        return this.cibaPolicyIssuanceCriteriaState.getIssuanceCriteriaList();
    }

    public void cleanAttributeMappings(Set<String> attributeContract) {
        this.cibaPolicyContractFulfillmentState.getModel().cleanMappings(attributeContract);
    }

    public void addStandardSourcesToPropertySelectionSources(DataMap.Sources sources) {
        StringPairPropertySelectionModel contextSelectionModel = new StringPairPropertySelectionModel(true);
        for (SourceContextType sct : this.getContextMappingTypes()) {
            contextSelectionModel.add(sct.getDescription(), sct.getId());
        }
        sources.addPropertySelectionSource("Context", contextSelectionModel);
    }

    public void addRequestHintToSources(DataMap.Sources sources) {
        Set<String> srcNames = this.cibaPolicyRequestHintContractState.getAllHintNames();
        sources.addPropertySelectionSource("Request", new StringPairPropertySelectionModel(true, srcNames));
    }

    @Override
    public void finish() {
        CibaServerPolicyManager cibaServerPolicyManager = (CibaServerPolicyManager)GlobalRegistry.getService(CibaServerPolicyManager.class);
        CibaServerPolicy cibaServerPolicy = cibaServerPolicyManager.getCibaServerPolicy();
        CibaServerPolicy.RequestHandlingPolicy newPolicy = this.getCibaPolicy();
        cibaServerPolicy.addRequestHandlingPolicy(newPolicy);
        cibaServerPolicyManager.saveCibaServerPolicy(cibaServerPolicy);
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        DependencyErrorUIValidatorImpl affectedItemValidator = new DependencyErrorUIValidatorImpl(this);
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)DependencyType.AUTH_SERVER_SETTINGS, DependencyType.OOB_AUTH_PLUGIN);
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)DependencyType.OOB_AUTH_PLUGIN, DependencyType.OOB_AUTH_PLUGIN);
        super.finish();
    }

    public Set<String> getTarget() {
        return this.cibaPolicyContractFulfillmentState.getTarget();
    }

    public String getDescription() {
        return this.cibaPolicyManagementState.getName();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public void cancel() {
        Object origData = this.getPopulateData();
        if (origData != null) {
            CibaServerPolicy.RequestHandlingPolicy policy = (CibaServerPolicy.RequestHandlingPolicy)origData;
            super.cancel();
            this.setPopulateData(policy);
        } else {
            super.cancel();
        }
    }

    @Override
    public Collection<String> getAdditionalInputAttributesForFilter() {
        return this.getAllRequestHintAttrNamesSorted();
    }

    public static enum Operation {
        INSERT,
        UPDATE,
        NONE;

    }
}

