/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.WsFedSpSettings;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class ConfigAssertionLifetimeState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String assertionValidityBeforeMinutes = String.valueOf(5);
    private String assertionValidityAfterMinutes = String.valueOf(5);

    public ConfigAssertionLifetimeState(Tasklet parent) {
        super(parent);
        this.updateKeyContext(false);
    }

    public void updateKeyContext(boolean isWsFedJwt) {
        if (isWsFedJwt) {
            this.setKeyContext("jwt");
        } else {
            this.setKeyContext("saml");
        }
        this.setMenuName(this.getMessage("menu_name"));
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof SpConnection) {
            SpConnection spConnectionBase = (SpConnection)dataFromDisk;
            this.assertionValidityAfterMinutes = Integer.valueOf(spConnectionBase.getAssertionValidityAfterMinutes()).toString();
            this.assertionValidityBeforeMinutes = Integer.valueOf(spConnectionBase.getAssertionValidityBeforeMinutes()).toString();
            WsFedSpSettings wsFedSettings = spConnectionBase.getWsFedSettings();
            this.updateKeyContext(wsFedSettings != null && wsFedSettings.getTokenType() == WsTrustTokenType.JWT);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase tempCon = (ConnectionBase)dataToDisk;
        if (tempCon instanceof SpConnection) {
            SpConnection spTempCon = (SpConnection)tempCon;
            spTempCon.setAssertionValidityAfterMinutes(Integer.parseInt(this.assertionValidityAfterMinutes));
            spTempCon.setAssertionValidityBeforeMinutes(Integer.parseInt(this.assertionValidityBeforeMinutes));
        }
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!StringUtils.isBlank((String)this.assertionValidityBeforeMinutes)) {
            if (!ValidationUtil.isValidPosUnsignedShortGreaterThanZero((String)this.assertionValidityBeforeMinutes)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Minutes_before_gte_0_lte_65535"), ValidationConstraint.REQUIRED);
            }
        } else {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Minutes_before_missing"), ValidationConstraint.REQUIRED);
        }
        if (!StringUtils.isBlank((String)this.assertionValidityAfterMinutes)) {
            if (!ValidationUtil.isValidPosUnsignedShortGreaterThanZero((String)this.assertionValidityAfterMinutes)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Minutes_after_gte_0_lte_65535"), ValidationConstraint.REQUIRED);
            }
        } else {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Minutes_after_missing"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("minutes_before"), this.assertionValidityBeforeMinutes, this));
        summaryList.add(new SummaryInfo(this.getMessage("minutes_after"), this.assertionValidityAfterMinutes, this));
    }

    public String getAssertionValidityAfterMinutes() {
        return this.assertionValidityAfterMinutes;
    }

    public void setAssertionValidityAfterMinutes(String assertionValidityAfterMinutes) {
        this.assertionValidityAfterMinutes = assertionValidityAfterMinutes;
    }

    public String getAssertionValidityBeforeMinutes() {
        return this.assertionValidityBeforeMinutes;
    }

    public void setAssertionValidityBeforeMinutes(String assertionValidityBeforeMinutes) {
        this.assertionValidityBeforeMinutes = assertionValidityBeforeMinutes;
    }

    @Override
    public void reset() {
        this.assertionValidityBeforeMinutes = String.valueOf(5);
        this.assertionValidityAfterMinutes = String.valueOf(5);
    }
}

