/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.BaseConfigAttributeSourcesState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.impl.SpAttributeSourceTasklet;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.AuthnSourceToAssertionMapping;

public class ConfigAttributeSourcesState
extends BaseConfigAttributeSourcesState {
    private static final long serialVersionUID = 20050515L;

    public ConfigAttributeSourcesState(Tasklet value) {
        super(value);
        this.setMenuName("Attribute Sources & User Lookup");
    }

    public ConfigAttributeSourcesState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Attribute Sources & User Lookup");
    }

    @Override
    protected void createSpAttributeSourceTasklets(Object dataFromDisk) {
        AuthnSourceToAssertionMapping adapterToAssertionMapping = (AuthnSourceToAssertionMapping)dataFromDisk;
        if (this.isUseOtherValuesWithOneMapping()) {
            AttributeMapping defaultMapping = adapterToAssertionMapping.getDefaultAttributeMapping();
            for (AttributeSource attrSource : defaultMapping.getAttributeSources()) {
                AttributeMapping dummyMapping = new AttributeMapping(defaultMapping);
                dummyMapping.setAttributeSource(attrSource);
                this.createSpAttributeSourceTasklet(dummyMapping);
            }
        } else {
            for (AttributeMapping mapping : adapterToAssertionMapping.getAttributeMappingList()) {
                this.createSpAttributeSourceTasklet(mapping);
            }
        }
    }

    @Override
    protected boolean save(Object dataToDisk, List<AttributeMapping> mappings) {
        AuthnSourceToAssertionMapping authnSourceToAssertionMapping = (AuthnSourceToAssertionMapping)dataToDisk;
        if (this.isUseOtherValuesWithOneMapping()) {
            AttributeMapping defaultAttributeMapping = authnSourceToAssertionMapping.getDefaultAttributeMapping();
            for (AttributeMapping mapping : mappings) {
                defaultAttributeMapping.addAttributeSource(mapping.getAttributeSource());
            }
        } else {
            authnSourceToAssertionMapping.setAttributeMappingList(mappings);
        }
        return true;
    }

    @Override
    protected List<AttributeSource> getAttributeSourcesFromDisk() {
        AuthnSourceToAssertionMapping adapterToAssertionMapping = (AuthnSourceToAssertionMapping)this.getPopulateData();
        return adapterToAssertionMapping != null ? adapterToAssertionMapping.getDefaultAttributeMapping().getAttributeSources() : null;
    }

    public void cleanAttributeMappings(Set<String> attributeContract) {
        for (Tasklet tasklet : this.getTasklets()) {
            SpAttributeSourceTasklet attributeSourceTasklet = (SpAttributeSourceTasklet)tasklet;
            attributeSourceTasklet.cleanAttributeMappings(attributeContract);
        }
    }
}

