/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.CommonDomainClient;
import org.sourceid.saml20.domain.IdpDiscovery;
import org.sourceid.saml20.domain.LocalSettings;

public class ConfigCommonDomainServiceState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String passPhrase;
    private String confirmPassPhrase;
    private String baseUrl;

    public ConfigCommonDomainServiceState(Tasklet value) {
        super(value);
        this.setMenuName("Common Domain Service");
    }

    @Override
    public void populate(Object dataFromDisk) {
        LocalSettings localSettings = (LocalSettings)dataFromDisk;
        IdpDiscovery idpDiscovery = localSettings.getIdpDiscovery();
        CommonDomainClient commonDomainClient = idpDiscovery.getCommonDomainClient();
        this.passPhrase = commonDomainClient.getPassPhrase();
        this.confirmPassPhrase = commonDomainClient.getPassPhrase();
        this.baseUrl = commonDomainClient.getCommonDomainServiceBaseUrl();
    }

    @Override
    public boolean save(Object dataToDisk) {
        LocalSettings localSettings = (LocalSettings)dataToDisk;
        IdpDiscovery idpDiscovery = localSettings.getIdpDiscovery();
        CommonDomainClient commonDomainClient = idpDiscovery.getCommonDomainClient();
        commonDomainClient.setPassPhrase(this.passPhrase);
        commonDomainClient.setCommonDomainServiceBaseUrl(this.baseUrl);
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!ValidationUtil.isValidHttpsWithoutQueryStr((String)this.baseUrl)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Invalid_url"), ValidationConstraint.REQUIRED);
        }
        if (!StringUtils.isBlank((String)this.passPhrase)) {
            if (StringUtils.isBlank((String)this.confirmPassPhrase)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Confirm_pass_invalid"), ValidationConstraint.REQUIRED);
            }
            if (!this.passPhrase.equals(this.confirmPassPhrase)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Passphrase_confirm_dont_match"), ValidationConstraint.REQUIRED);
            }
            if (this.passPhrase.length() < 6) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Passphrase_too_short"), ValidationConstraint.REQUIRED);
            }
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Base_url"), this.baseUrl, this));
    }

    public String getConfirmPassPhrase() {
        return this.confirmPassPhrase;
    }

    public void setConfirmPassPhrase(String confirmPassPhrase) {
        this.confirmPassPhrase = confirmPassPhrase;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

