/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.LdapNameValidator;
import com.pingidentity.common.util.OgnlHelper;
import com.pingidentity.common.util.Substituter;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConfigAdapterMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.fsm.tasklet.impl.SpAttributeSourceTasklet;
import com.pingidentity.util.SAML2MappingModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;

public class ConfigLdapDirSearchState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    protected LdapDataSource dataSource;
    protected String baseDN;
    protected String selectedSearchScope;
    protected String selectedRootClass;
    protected String selectedAvailableAttr;
    protected String attributeOption;
    protected String previouslySelectedRootClass;
    protected boolean memberOfWithNestedGroup;
    protected boolean selectedMemberOfWithNestedGroup;
    private boolean origMemberOfWithNestedGroup;
    protected transient StringPairPropertySelectionModel searchScopeList;
    protected transient StringPairPropertySelectionModel rootObjClassList;
    protected transient StringPairPropertySelectionModel availableAttrList;
    protected static final String SUBTREE = "Subtree";
    protected static final String ONE_LEVEL = "One Level";
    protected static final String OBJECT = "Object";
    protected static final String SUBJECT_DN = "Subject DN";
    protected List<String> selectedAttributes;
    protected List<String> availableAttributes;
    protected List<String> allAttributes;
    static final String NO_ATTRIBUTES_LIST = "<no attributes available>";
    static final String SHOW_ALL_ATTRIBUTES = "<Show All Attributes>";
    static final StringPairPropertySelectionModel NO_ATTRIBUTES_MODEL = new StringPairPropertySelectionModel();
    public static final String SHOW_ALL = "none";

    public ConfigLdapDirSearchState(Tasklet value) {
        super(value);
        this.setMenuName("LDAP Directory Search");
    }

    public ConfigLdapDirSearchState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("LDAP Directory Search");
    }

    @Override
    public void onStateActivated() {
        AttributeSourceApi attrSrcTasklet = (AttributeSourceApi)((Object)this.getWizard());
        LdapDataSource temp = (LdapDataSource)attrSrcTasklet.getSelectedDataSource();
        this.initDataSource(temp);
    }

    @Override
    public String getNoteKey() {
        return this.getIsOidc() && this.getClass().equals(ConfigLdapDirSearchState.class) ? super.getNoteKey() + "_Oidc" : super.getNoteKey();
    }

    public boolean getIsOidc() {
        ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
        if (connTasklet != null) {
            return connTasklet.isConnectionProtocolOIDC();
        }
        return false;
    }

    protected void initDataSource(LdapDataSource temp) {
        if (this.dataSource == null || temp != null && !temp.getId().equals(this.dataSource.getId())) {
            this.dataSource = temp;
            this.resetAllValues();
            this.populate();
        }
        if (!this.isViewOnly()) {
            if (this.searchScopeList == null) {
                this.initializeSearchScope();
            }
            if (this.availableAttrList == null && this.availableAttributes != null) {
                this.availableAttrList = this.createPairModel(this.availableAttributes);
            }
        }
    }

    protected void resetAllValues() {
        this.baseDN = "";
        this.selectedSearchScope = "";
        this.selectedRootClass = "";
        this.selectedAvailableAttr = "";
        this.attributeOption = "";
        this.previouslySelectedRootClass = "";
        this.selectedMemberOfWithNestedGroup = false;
        this.memberOfWithNestedGroup = false;
        this.searchScopeList = new StringPairPropertySelectionModel();
        this.rootObjClassList = new StringPairPropertySelectionModel();
        this.availableAttrList = new StringPairPropertySelectionModel();
        this.selectedAttributes = new ArrayList<String>();
        this.availableAttributes = new ArrayList<String>();
    }

    @Override
    public void populate(Object dataFromDisk) {
        AttributeMapping mapping = (AttributeMapping)dataFromDisk;
        AttributeSource source = mapping.getAttributeSource();
        this.dataSource = (LdapDataSource)source.getDataSource();
        this.baseDN = source.getParameter("search_base");
        this.selectedSearchScope = source.getParameter("search_scope");
        this.selectedAttributes = this.getSelectedAttributesList(mapping, source);
        this.populateMemberOf(source);
        this.populate();
    }

    protected void populateMemberOf(AttributeSource source) {
        this.memberOfWithNestedGroup = this.selectedMemberOfWithNestedGroup = Boolean.valueOf(source.getParameter("memberof_nested_group")).booleanValue();
        this.origMemberOfWithNestedGroup = this.selectedMemberOfWithNestedGroup;
    }

    public void populate() {
        if (!this.isViewOnly() && this.dataSource != null) {
            this.initializeSearchScope();
            this.selectedRootClass = "";
            this.insertSubjectDN();
            this.availableAttributes = this.getAvailableAttrs();
            this.cullAvailableAttributes();
            this.availableAttrList = this.createPairModel(this.availableAttributes);
        }
        if (StringUtils.isBlank((String)this.selectedAvailableAttr)) {
            this.selectedAvailableAttr = null;
        }
        this.attributeOption = "";
    }

    protected List<String> getAvailableAttrs() {
        List<String> attrs = StringUtils.isBlank((String)this.selectedRootClass) ? new LinkedList<String>() : (SHOW_ALL.equals(this.selectedRootClass) ? this.dataSource.getLDAPAttributeNameList() : this.dataSource.getLDAPAttributeNameList(this.selectedRootClass));
        return attrs;
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeMapping tempMapping = (AttributeMapping)dataToDisk;
        AttributeSource source = tempMapping.getAttributeSource();
        this.save(source);
        return true;
    }

    protected void save(AttributeSource source) {
        source.setParameter("search_base", this.baseDN);
        source.setParameter("search_scope", this.selectedSearchScope);
        StringJoiner joiner = new StringJoiner(",");
        this.selectedAttributes.forEach(joiner::add);
        source.setParameter("search_attributes", joiner.toString());
        this.saveMemberOfNestedGroup(source);
    }

    protected void saveMemberOfNestedGroup(AttributeSource source) {
        String saveMemberOfWithNestedGroup = Boolean.FALSE.toString();
        if (this.memberOfWithNestedGroup && this.isMemberOfMapped(source.getId())) {
            saveMemberOfWithNestedGroup = Boolean.TRUE.toString();
        }
        source.setParameter("memberof_nested_group", saveMemberOfWithNestedGroup);
    }

    @Override
    public void cancel(Object newData) {
        if (!this.isViewOnly()) {
            super.cancel(newData);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        LdapNameValidator baseDnValidator;
        if (this.baseDN != null && !(baseDnValidator = new LdapNameValidator(this.baseDN, this.getAvailableSubstitutionAttributes(), ApiMessageKey.ldap_attribute_source_base_dn_malformed, ApiMessageKey.ldap_attribute_source_base_dn_var_not_found, "")).validate()) {
            this.recordErrors(baseDnValidator.getErrors(), delegate);
        }
    }

    protected Collection<String> getAvailableSubstitutionAttributes() {
        return Collections.emptyList();
    }

    protected List<String> getSelectedAttributesList(AttributeMapping m, AttributeSource source) {
        String string;
        List issuanceCriteria;
        HashSet<String> t = new HashSet<String>();
        for (Object v : m.getAttributeMap().values()) {
            if (v.getType() == SourceType.LDAP_DATA_STORE) {
                if (v.getAttributeSourceId() != null && !v.getAttributeSourceId().equals(m.getAttributeSource().getId())) continue;
                t.add(v.getValue());
                continue;
            }
            if (v.getType() == SourceType.TEXT) {
                Set set = Substituter.parseReferences((String)v.getValue());
                for (String s : set) {
                    if (!s.startsWith(this.getPrefix())) continue;
                    t.add(s.substring(this.getPrefix().length()));
                }
                continue;
            }
            if (v.getType() != SourceType.EXPRESSION) continue;
            this.addAttributesFromExpression(v.getValue(), t);
        }
        Set<String> attributeSourceFilterReferences = this.getReferencesInAllAttributeSourceFiltersFromDisk();
        if (attributeSourceFilterReferences != null) {
            for (String string2 : attributeSourceFilterReferences) {
                if (!string2.startsWith(this.getPrefix())) continue;
                t.add(string2.substring(this.getPrefix().length()));
            }
        }
        if ((issuanceCriteria = m.getTokenAuthorizationIssuanceCriteria()) != null) {
            for (TokenAuthorizationIssuanceCriterion criterion : issuanceCriteria) {
                if (criterion.getAttrSourceType() == SourceType.LDAP_DATA_STORE) {
                    if (!StringUtils.isEmpty((String)criterion.getAttrSourceId()) && !criterion.getAttrSourceId().equals(m.getAttributeSource().getId())) continue;
                    t.add(criterion.getAttrName());
                    continue;
                }
                if (criterion.getAttrSourceType() != SourceType.EXPRESSION) continue;
                this.addAttributesFromExpression(criterion.getExpr(), t);
            }
        }
        if ((string = source.getParameter("search_attributes")) != null) {
            String[] attributes = string.split(",");
            t.addAll(Arrays.asList(attributes));
        }
        ArrayList<String> attrList = new ArrayList<String>(t);
        attrList.sort(String::compareToIgnoreCase);
        return attrList;
    }

    private void addAttributesFromExpression(String expression, Set<String> selectedAttrs) {
        try {
            Object parsedExpression = Ognl.parseExpression((String)expression);
            OgnlHelper oh = new OgnlHelper(this.getPrefix());
            oh.searchForDataColumns(parsedExpression);
            oh.addListToSet(selectedAttrs);
        }
        catch (OgnlException e) {
            this.log.debug((Object)e);
        }
    }

    public void addAttribute() {
        if (this.isAttributeOptionsSupported()) {
            this.addAttrToSelectedAttrList();
        } else {
            this.moveAttrFromSrcToTarget(this.selectedAvailableAttr, this.availableAttributes, this.selectedAttributes);
        }
        this.availableAttrList = this.createPairModel(this.availableAttributes);
        if ("memberOf".equals(this.selectedAvailableAttr)) {
            this.memberOfWithNestedGroup = this.selectedMemberOfWithNestedGroup;
            this.selectedMemberOfWithNestedGroup = false;
        }
        this.selectedAvailableAttr = "";
        this.attributeOption = "";
    }

    public void deleteAttribute(String attributeToRemove) {
        if (this.isAttributeOptionsSupported()) {
            this.selectedAttributes.remove(attributeToRemove);
        } else {
            this.moveAttrFromSrcToTarget(attributeToRemove, this.selectedAttributes, this.availableAttributes);
        }
        if (StringUtils.isNotBlank((String)this.selectedRootClass)) {
            this.availableAttrList = this.createPairModel(this.availableAttributes);
        }
        if ("memberOf".equals(attributeToRemove)) {
            this.selectedMemberOfWithNestedGroup = false;
            this.memberOfWithNestedGroup = false;
        }
        this.selectedAvailableAttr = "";
        this.attributeOption = "";
    }

    protected void moveAttrFromSrcToTarget(String attribute, List<String> sourceList, List<String> targetList) {
        if (sourceList.contains(attribute) && !targetList.contains(attribute)) {
            int index = sourceList.indexOf(attribute);
            targetList.add(sourceList.get(index));
            sourceList.remove(index);
            targetList.sort(String::compareToIgnoreCase);
        }
    }

    protected void addAttrToSelectedAttrList() {
        if (this.availableAttributes.contains(this.selectedAvailableAttr)) {
            Object attribute = StringUtils.isNotBlank((String)this.attributeOption) ? this.selectedAvailableAttr + ";" + StringUtils.trim((String)this.attributeOption) : this.selectedAvailableAttr;
            if (!this.selectedAttributes.contains(attribute)) {
                this.selectedAttributes.add((String)attribute);
                this.selectedAttributes.sort(String::compareToIgnoreCase);
            } else {
                this.recordErrorMsg(String.format("The attribute '%s' is already defined.", attribute));
            }
        }
    }

    protected void cullAvailableAttributes() {
        if (this.isAttributeOptionsSupported()) {
            return;
        }
        for (String attribute : this.selectedAttributes) {
            if (!this.availableAttributes.contains(attribute)) continue;
            this.availableAttributes.remove(attribute);
        }
    }

    protected void insertSubjectDN() {
        if (this.needsSubjectDn()) {
            this.selectedAttributes.remove(SUBJECT_DN);
            this.selectedAttributes.add(0, SUBJECT_DN);
        }
    }

    protected boolean needsSubjectDn() {
        return true;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.previouslySelectedRootClass == null || this.selectedRootClass == null || !this.previouslySelectedRootClass.equals(this.selectedRootClass)) {
            this.resetValues();
        }
    }

    protected void resetValues() {
        if (!this.isViewOnly()) {
            this.availableAttributes = this.getAvailableAttrs();
            this.cullAvailableAttributes();
            this.setAvailableAttrList(this.createPairModel(this.availableAttributes));
            this.previouslySelectedRootClass = this.selectedRootClass;
        }
    }

    protected void initializeSearchScope() {
        this.searchScopeList = new StringPairPropertySelectionModel();
        this.searchScopeList.add(SUBTREE, "SUBTREE_SCOPE");
        this.searchScopeList.add(ONE_LEVEL, "ONELEVEL_SCOPE");
        this.searchScopeList.add(OBJECT, "OBJECT_SCOPE");
    }

    protected StringPairPropertySelectionModel createPairModel(List<String> l) {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel();
        for (String value : l) {
            model.add(value, value);
        }
        return model;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    public IPropertySelectionModel getSearchScopeList() {
        return this.searchScopeList;
    }

    public void setSearchScopeList(StringPairPropertySelectionModel searchScopeList) {
        this.searchScopeList = searchScopeList;
    }

    public String getSelectedSearchScope() {
        return this.selectedSearchScope;
    }

    public void setSelectedSearchScope(String selectedSearchScope) {
        this.selectedSearchScope = selectedSearchScope;
    }

    public IPropertySelectionModel getRootObjClassList() {
        if (!(this.isViewOnly() || this.rootObjClassList != null && this.rootObjClassList.getOptionCount() != 0)) {
            List objClasses = this.dataSource.getObjectClasses();
            StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
            model.add(SHOW_ALL_ATTRIBUTES, SHOW_ALL);
            String[] objects = objClasses.toArray(new String[0]);
            Arrays.sort(objects, String::compareToIgnoreCase);
            model.addAllStrings(objects);
            this.rootObjClassList = model;
        }
        return this.rootObjClassList;
    }

    public String getSelectedRootClass() {
        return this.selectedRootClass;
    }

    public void setSelectedRootClass(String selectedRootClass) {
        this.selectedRootClass = selectedRootClass;
    }

    public StringPairPropertySelectionModel getAvailableAttrList() {
        return this.availableAttrList;
    }

    public void setAvailableAttrList(StringPairPropertySelectionModel availableAttrList) {
        this.availableAttrList = availableAttrList;
    }

    public String getSelectedAvailableAttr() {
        return this.selectedAvailableAttr;
    }

    public void setSelectedAvailableAttr(String selectedAvailableAttr) {
        this.selectedAvailableAttr = selectedAvailableAttr;
    }

    public List<String> getSelectedAttributes() {
        return this.selectedAttributes;
    }

    public List<String> getSelectedAttributesCopy() {
        List<String> selectedAttributesCopy = this.selectedAttributes.stream().collect(Collectors.toList());
        return selectedAttributesCopy;
    }

    public List<Attribute> getSelectedAttributesWithOptionsCopy() {
        return this.selectedAttributes.stream().map(Attribute::new).collect(Collectors.toList());
    }

    public void setSelectedAttributes(ArrayList<String> selectedAttributes) {
        this.selectedAttributes = selectedAttributes;
    }

    public List<String> getAllAttributes() {
        if (this.allAttributes == null) {
            this.allAttributes = !this.isViewOnly() ? this.dataSource.getLDAPAttributeNameList() : new ArrayList();
        }
        return this.allAttributes;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        this.doBaseDNSummary(summaryList);
        this.doSearchScopeSummary(summaryList);
        this.doAttributeSummary(summaryList);
    }

    private void doSearchScopeSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Search scope", this.selectedSearchScope, this));
    }

    protected void doBaseDNSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Base DN", this.baseDN, this));
    }

    protected void doAttributeSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.selectedAttributes != null) {
            for (String attribute : this.selectedAttributes) {
                summaryList.add(new SummaryInfo("Attribute", this.getMemberOfSummaryDescription(attribute), this));
            }
        }
    }

    protected String getMemberOfSummaryDescription(String attributeName) {
        if (this.memberOfWithNestedGroup && "memberOf".equals(attributeName)) {
            attributeName = (String)attributeName + " (with Nested Groups)";
            return attributeName;
        }
        return attributeName;
    }

    public List<String> getContractToFulfill() {
        AttributeSourceApi attributeSourceTasklet = (AttributeSourceApi)((Object)this.getWizard());
        return attributeSourceTasklet.getContractToFulfill();
    }

    public String getLinkText() {
        MappingTasklet mappingTasklet = this.findParent(MappingTasklet.class);
        if (mappingTasklet != null) {
            return "View " + mappingTasklet.getContractTypeForDisplay();
        }
        Tasklet tasklet = this.getParent();
        if (tasklet instanceof IdpConfigAdapterMappingTasklet) {
            return "View Adapter Contract";
        }
        return "View Attribute Contract";
    }

    protected String getPrefix() {
        Object prefix = "ds.";
        String attrSourceId = this.getAttributeSourceId();
        if (attrSourceId != null) {
            prefix = (String)prefix + attrSourceId + ".";
        }
        return prefix;
    }

    private String getAttributeSourceId() {
        String attributeSourceId = null;
        SpAttributeSourceTasklet spAttributeSourceTasklet = this.findParent(SpAttributeSourceTasklet.class);
        if (spAttributeSourceTasklet != null) {
            attributeSourceId = spAttributeSourceTasklet.getId();
        }
        return attributeSourceId;
    }

    private Set<String> getReferencesInAllAttributeSourceFiltersFromDisk() {
        Set<String> references = null;
        MappingTasklet mappingTasklet = this.findParent(MappingTasklet.class);
        if (mappingTasklet != null) {
            references = mappingTasklet.getReferencesInAllAttributeSourceFiltersFromDisk();
        }
        return references;
    }

    public boolean isBinaryAttributeSelected() {
        if (this.selectedAttributes != null) {
            for (String selectedAttribute : this.selectedAttributes) {
                if (this.dataSource.getBinaryAttributes() == null || !this.dataSource.getBinaryAttributes().contains(selectedAttribute)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean showNestedGroup() {
        return "memberOf".equals(this.selectedAvailableAttr) && this.dataSource.isActiveDirectoryType();
    }

    public boolean isSelectedMemberOfWithNestedGroup() {
        return this.selectedMemberOfWithNestedGroup;
    }

    public void setSelectedMemberOfWithNestedGroup(boolean selectedMemberOfWithNestedGroup) {
        this.selectedMemberOfWithNestedGroup = selectedMemberOfWithNestedGroup;
    }

    private boolean isMemberOfMapped(String attributeSourceId) {
        MappingTasklet mappingTasklet = this.findParent(MappingTasklet.class);
        SAML2MappingModel saml2MappingModel = null;
        List<? extends TokenAuthorizationIssuanceCriterion> issuanceCriterions = null;
        boolean multipleDs = false;
        if (mappingTasklet != null && mappingTasklet.isUseOtherValuesWithOneMapping()) {
            saml2MappingModel = mappingTasklet.getMappingModel();
            issuanceCriterions = mappingTasklet.getIssuanceCriterion();
            multipleDs = mappingTasklet.isMultiAttributeSourceMapping();
        } else {
            AttributeSourceApi attributeSourceApi = (AttributeSourceApi)((Object)this.getParent());
            if (attributeSourceApi != null) {
                saml2MappingModel = attributeSourceApi.getMappingModel();
                issuanceCriterions = attributeSourceApi.getIssuanceCriterion();
            }
        }
        boolean isMappedInMappingState = this.isMemberOfMappedInMappingState(saml2MappingModel, "memberOf", attributeSourceId, multipleDs);
        boolean isMappedInIssuanceCriteria = this.isMemberOfMappedInIssuanceCriteria(issuanceCriterions, "memberOf", attributeSourceId, multipleDs);
        return isMappedInMappingState || isMappedInIssuanceCriteria;
    }

    private boolean isMemberOfMappedInMappingState(SAML2MappingModel model, String attribute, String attributeSourceId, boolean multipleDs) {
        if (model != null) {
            Map map = model.getMapping().getAttributeMapping();
            for (List attributeValues : map.values()) {
                for (AttrMappingValue attributeValue : attributeValues) {
                    if (!(SourceType.LDAP_DATA_STORE == attributeValue.getType() && attribute.equals(attributeValue.getValue()) ? !multipleDs || attributeValue.getAttributeSourceId().equals(attributeSourceId) : SourceType.EXPRESSION == attributeValue.getType() && this.doesExpressionContainLdapAttribute(attributeValue.getValue(), attribute))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isMemberOfMappedInIssuanceCriteria(List<? extends TokenAuthorizationIssuanceCriterion> issuanceCriterions, String attribute, String attributeSourceId, boolean multipleDs) {
        if (issuanceCriterions != null) {
            for (TokenAuthorizationIssuanceCriterion tokenAuthorizationIssuanceCriterion : issuanceCriterions) {
                if (!(SourceType.LDAP_DATA_STORE == tokenAuthorizationIssuanceCriterion.getAttrSourceType() && attribute.equals(tokenAuthorizationIssuanceCriterion.getAttrName()) && !tokenAuthorizationIssuanceCriterion.isMarkedForDelete() ? !multipleDs || tokenAuthorizationIssuanceCriterion.getAttrSourceId().equals(attributeSourceId) : SourceType.EXPRESSION == tokenAuthorizationIssuanceCriterion.getAttrSourceType() && this.doesExpressionContainLdapAttribute(tokenAuthorizationIssuanceCriterion.getExpr(), attribute))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean doesExpressionContainLdapAttribute(String expr, String ldapAttr) {
        try {
            Object parsedExpression = Ognl.parseExpression((String)expr);
            OgnlHelper oh = new OgnlHelper(this.getPrefix());
            oh.searchForDataColumns(parsedExpression);
            List varsInExpression = oh.getList();
            if (varsInExpression != null && varsInExpression.contains(ldapAttr)) {
                return true;
            }
        }
        catch (OgnlException ognlException) {
            // empty catch block
        }
        return false;
    }

    public boolean isShowMemberOfNestedGroupDescription() {
        if (this.origMemberOfWithNestedGroup == this.memberOfWithNestedGroup) {
            return this.origMemberOfWithNestedGroup;
        }
        return this.memberOfWithNestedGroup;
    }

    protected boolean isAttributeOptionsSupported() {
        return true;
    }

    public String getAttributeOption() {
        return this.attributeOption;
    }

    public void setAttributeOption(String attributeOption) {
        this.attributeOption = attributeOption;
    }

    public static class Attribute
    implements Serializable {
        private final String attribute;
        private final String name;
        private final String option;

        public Attribute(String attribute) {
            this.attribute = attribute;
            String[] split = attribute.split(";", 2);
            this.name = split[0];
            this.option = split.length == 2 ? split[1] : null;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public String getName() {
            return this.name;
        }

        public String getOption() {
            return this.option;
        }
    }
}

