/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.PasswordValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.IdpDiscoveryTasklet;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.CommonDomainService;
import org.sourceid.saml20.domain.IdpDiscovery;
import org.sourceid.saml20.domain.LocalSettings;

public class ConfigLocalCommonDomainServerState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private static final int MIN_COOKIE = 1;
    private static final int MAX_COOKIE = 1825;
    private static final Integer[] COOKIE_LIFE_ERR_PARAMS = new Integer[]{1, 1825, -1};
    private String passPhrase;
    private String confirmPassPhrase;
    private boolean passPhraseChanged;
    private String commonDomain;
    private String cookieLifetime;

    public ConfigLocalCommonDomainServerState(Tasklet value) {
        super(value);
        this.setMenuName("Local Common Domain Server");
    }

    @Override
    public void populate(Object dataFromDisk) {
        LocalSettings localSettings = (LocalSettings)dataFromDisk;
        IdpDiscovery idpDiscovery = localSettings.getIdpDiscovery();
        CommonDomainService commonDomainService = idpDiscovery.getCommonDomainService();
        this.passPhrase = commonDomainService.getPassPhrase();
        this.confirmPassPhrase = commonDomainService.getPassPhrase();
        this.commonDomain = commonDomainService.getCommonDomain();
        this.cookieLifetime = Integer.toString(commonDomainService.getCookieLifeDays());
    }

    @Override
    public boolean save(Object dataToDisk) {
        LocalSettings localSettings = (LocalSettings)dataToDisk;
        IdpDiscovery idpDiscovery = localSettings.getIdpDiscovery();
        CommonDomainService commonDomainService = idpDiscovery.getCommonDomainService();
        commonDomainService.setPassPhrase(this.passPhrase);
        commonDomainService.setCommonDomain(this.commonDomain);
        commonDomainService.setCookieLifeDays(Integer.parseInt(this.cookieLifetime));
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        IdpDiscoveryTasklet t = this.getParent(IdpDiscoveryTasklet.class);
        String baseUrl = t.getCommonDomainServiceBaseUrl();
        CharSequence chars = this.commonDomain.subSequence(0, this.commonDomain.length());
        if (!StringUtils.isBlank((String)baseUrl) && baseUrl.contains(chars) && !this.passPhrase.trim().equals(t.getCommonDomainPassphrase())) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Base_url_contains_domain_passphrases_dont_match"), ValidationConstraint.REQUIRED);
        }
        if (this.passPhraseChanged && StringUtils.isNotBlank((String)this.passPhrase)) {
            PasswordValidator passwordValidator;
            if (!this.passPhrase.equals(this.confirmPassPhrase)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Passphrase_confirm_dont_match"), ValidationConstraint.REQUIRED);
            }
            if (!(passwordValidator = new PasswordValidator(this.passPhrase, "passPhrase", "Pass phrase")).validate()) {
                delegate.setFormComponent(null);
                this.recordErrors(passwordValidator.getErrors(), delegate);
            }
        }
        if (!this.isValidCookieLifetime(this.cookieLifetime)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Invalid_cookie_lifetime", COOKIE_LIFE_ERR_PARAMS), ValidationConstraint.REQUIRED);
        }
        if (StringUtils.isBlank((String)this.commonDomain) || !ValidationUtil.startsWithOnePeriodAndHasOneOther((String)this.commonDomain)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Invalid_common_domain"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Common_domain"), this.commonDomain, this));
        summaryList.add(new SummaryInfo(this.getMessage("Cookie_lifetime"), this.cookieLifetime, this));
    }

    private boolean isValidCookieLifetime(String cookie) {
        try {
            int cookieInDays = Integer.parseInt(cookie);
            return cookieInDays == -1 || cookieInDays >= 1 && cookieInDays <= 1825;
        }
        catch (NumberFormatException n) {
            return false;
        }
    }

    public String getCommonDomain() {
        return this.commonDomain;
    }

    public void setCommonDomain(String commonDomain) {
        this.commonDomain = commonDomain;
    }

    public String getConfirmPassPhrase() {
        return this.confirmPassPhrase;
    }

    public void setConfirmPassPhrase(String confirmPassPhrase) {
        this.confirmPassPhrase = confirmPassPhrase;
    }

    public String getCookieLifetime() {
        return this.cookieLifetime;
    }

    public void setCookieLifetime(String cookieLifetime) {
        this.cookieLifetime = cookieLifetime;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(String passPhrase) {
        if (!passPhrase.equals(this.passPhrase)) {
            this.passPhraseChanged = true;
        }
        this.passPhrase = passPhrase;
    }

    public boolean hasExistingPassPhrase() {
        return StringUtils.isNotBlank((String)this.passPhrase);
    }
}

