/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.SpDefaultUrlsValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ConfigSpEventsState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String ssoSuccessUrl;
    private String sloSuccessUrl;
    private boolean confirmSlo;
    private LocalSettings localSettings;

    public ConfigSpEventsState(Tasklet value) {
        super(value);
        this.setMenuName("SP Default URLs");
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.localSettings = (LocalSettings)data;
        this.ssoSuccessUrl = this.localSettings.getSpSsoSuccessUrl();
        this.sloSuccessUrl = this.localSettings.getSpSloSuccessUrl();
        this.confirmSlo = this.localSettings.isConfirmSlo();
        return true;
    }

    @Override
    public void reset() {
        this.populateAllStates(this.localSettings);
    }

    @Override
    public boolean save(Object dataFromDisk) {
        LocalSettingsManager localSettingsMgr = MgmtFactory.getLocalSettingsManager();
        LocalSettings tempLocalSettings = localSettingsMgr.getLocalSettings();
        tempLocalSettings.setSpSsoSuccessUrl(this.ssoSuccessUrl);
        tempLocalSettings.setSpSloSuccessUrl(this.sloSuccessUrl);
        tempLocalSettings.setConfirmSlo(this.confirmSlo);
        localSettingsMgr.saveLocalSettings(tempLocalSettings, AdminAuditLogger.Component.SP_CONFIG_DEFAULT_URLS);
        this.localSettings = tempLocalSettings;
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        SpDefaultUrlsValidator validator = new SpDefaultUrlsValidator.Builder().setSsoSuccessUrl(this.ssoSuccessUrl).setSloSuccessUrl(this.isEnableSaml20SpOrWsFedSp() ? this.sloSuccessUrl : "").build();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Sso_success_url"), this.ssoSuccessUrl, this));
        if (this.isEnableSaml20SpOrWsFedSp()) {
            summaryList.add(new SummaryInfo(this.getMessage("Slo_success_url"), this.sloSuccessUrl, this));
        }
    }

    public boolean isEnableSaml20SpOrWsFedSp() {
        return this.localSettings.isEnableSamlSp() || this.localSettings.isEnableWsFedSp();
    }

    public String getSloSuccessUrl() {
        return this.sloSuccessUrl;
    }

    public void setSloSuccessUrl(String sloSuccessUrl) {
        this.sloSuccessUrl = sloSuccessUrl;
    }

    public String getSsoSuccessUrl() {
        return this.ssoSuccessUrl;
    }

    public void setSsoSuccessUrl(String ssoSuccessUrl) {
        this.ssoSuccessUrl = ssoSuccessUrl;
    }

    public boolean isConfirmSlo() {
        return this.confirmSlo;
    }

    public void setConfirmSlo(boolean confirmSlo) {
        this.confirmSlo = confirmSlo;
    }
}

