/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.IdpConfigAdapterMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningTasklet;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import java.io.Serializable;
import java.util.ArrayList;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.IdpConnection;

public class ConfigUserProvisioningLdapDirSearchState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private String baseDN;

    public ConfigUserProvisioningLdapDirSearchState(Tasklet value) {
        super(value);
        this.setMenuName("Location");
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection connection = (IdpConnection)dataFromDisk;
        AttributeSource source = this.isInboundProvisioningTasklet() ? connection.getInboundProvisioning().getWriteUsersAttributeMapping().getAttributeSource() : connection.getUserProvisioning().getAttributeSource();
        this.baseDN = source.getParameter("search_base");
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection tempConnection = (IdpConnection)dataToDisk;
        if (this.isInboundProvisioningTasklet()) {
            this.saveBaseDnToSource(tempConnection.getInboundProvisioning().getWriteUsersAttributeMapping());
            this.saveBaseDnToSource(tempConnection.getInboundProvisioning().getReadUsersAttributeMapping());
        } else {
            this.saveBaseDnToSource((AttributeMapping)tempConnection.getUserProvisioning());
        }
        return true;
    }

    private void saveBaseDnToSource(AttributeMapping attributeMapping) {
        AttributeSource source;
        if (attributeMapping != null && (source = attributeMapping.getAttributeSource()) != null) {
            source.setParameter("search_base", this.baseDN);
        }
    }

    @Override
    public void cancel(Object newData) {
        if (!this.isViewOnly()) {
            super.cancel(newData);
        }
    }

    public void resetAllValues() {
        this.baseDN = "";
    }

    @Override
    public void reset() {
        this.baseDN = "";
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isNotBlank((String)this.baseDN)) {
            try {
                new LdapName(this.baseDN);
            }
            catch (InvalidNameException e) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Malformed_base_dn"), ValidationConstraint.DISALLOWED_PROTOCOL);
            }
        }
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Base DN", this.baseDN, this));
    }

    public String getLinkText() {
        MappingTasklet mappingTasklet = this.findParent(MappingTasklet.class);
        if (mappingTasklet != null) {
            return mappingTasklet.getContractTypeForDisplay();
        }
        Tasklet tasklet = this.getParent();
        if (tasklet instanceof IdpConfigAdapterMappingTasklet) {
            return "View Adapter Contract";
        }
        return "View Attribute Contract";
    }

    private boolean isInboundProvisioningTasklet() {
        Tasklet tasklet = this.getParent();
        return tasklet instanceof InboundProvisioningTasklet;
    }
}

