/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.ApiMessages;
import com.pingidentity.admin.api.validator.PluginConfigConsistencyValidator;
import com.pingidentity.admin.api.validator.PluginConfigValidator;
import com.pingidentity.admin.api.validator.PluginFieldValidator;
import com.pingidentity.admin.api.validator.PluginTableRowValidator;
import com.pingidentity.admin.api.validator.PluginTableValidator;
import com.pingidentity.crypto.HashedPassword;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.FieldItem;
import com.pingidentity.fsm.tasklet.data.RowItem;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.data.TableItem;
import com.pingidentity.fsm.tasklet.impl.DataSourceTasklet;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.GuiConfigDescriptorBuilder;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.validator.PFValidationDelegate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.common.StringSubstituter;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.HashedField;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.conf.internal.ConfigOverrideMetadata;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.HashedTextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.LinkDescriptor;
import org.sourceid.saml20.adapter.gui.ReadOnlyDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextAreaFieldDescriptor;
import org.sourceid.saml20.adapter.gui.event.ConfigurationListener;
import org.sourceid.saml20.adapter.gui.event.EventException;
import org.sourceid.saml20.adapter.gui.event.PreRenderCallback;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public abstract class ConfigureAdapterState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    protected List<FieldItem> fieldItems = Collections.emptyList();
    protected List<ReadOnlyDescriptor> summaryFieldItems = Collections.emptyList();
    protected List<TableItem> tableItems = Collections.emptyList();
    protected Map<String, FieldItem> priorFields = new HashMap<String, FieldItem>();
    protected Map<String, TableItem> priorTables = new HashMap<String, TableItem>();
    protected String mainDesc;
    protected List<ConfigurationValidator> configurationValidatorChain;
    protected List<ConfigurationListener> configurationListenerChain;
    protected List<PreRenderCallback> preRenderCallbackChain = Collections.emptyList();
    protected static final int NONE = -18783;
    protected int editTableIndex = -18783;
    protected int editRowIndex = -18783;
    private boolean showAdvancedFields;
    private boolean hasAdvancedFields;

    public ConfigureAdapterState(IWizard owner) {
        super(owner, "configureAdapter");
    }

    protected abstract void populate();

    public Configuration buildConfiguration() {
        return this.buildConfiguration(true);
    }

    public Configuration buildConfiguration(boolean buildComposite) {
        List<Field> fields = this.getConfiguredFields(false, buildComposite);
        List<Field> advancedFields = this.getConfiguredFields(true, buildComposite);
        ArrayList<Table> tables = new ArrayList<Table>();
        for (TableItem tableItem : this.getTableItems()) {
            if (!buildComposite && !tableItem.isOverridesParent()) continue;
            String name = tableItem.getTableDescriptor().getName();
            ArrayList<Row> rows = new ArrayList<Row>();
            for (RowItem rowItem : tableItem.getRows()) {
                if (rowItem.isDeleted()) continue;
                ArrayList<Field> rowFields = new ArrayList<Field>();
                for (FieldItem fieldItem : rowItem.getRowFields()) {
                    Field field = this.buildField(fieldItem);
                    rowFields.add(field);
                }
                boolean isDefaultRow = false;
                if (rowItem.isDefault() && tableItem.getTableDescriptor().getRequireDefaultRow()) {
                    isDefaultRow = true;
                }
                Row row = new Row(rowFields, isDefaultRow);
                rows.add(row);
            }
            Table table = new Table(name, rows);
            tables.add(table);
        }
        Configuration configuration = new Configuration(fields, tables, advancedFields);
        PluginInstanceTasklet pluginInstanceTasklet = this.findParent(PluginInstanceTasklet.class);
        if (pluginInstanceTasklet != null) {
            configuration.setId(pluginInstanceTasklet.getPluginId());
            configuration.setAdditionalAttrNames(new HashSet<String>(pluginInstanceTasklet.getAdapterAttributeList()));
        } else {
            DataSourceTasklet dataSourceTaskletInstanceTasklet = this.findParent(DataSourceTasklet.class);
            if (dataSourceTaskletInstanceTasklet != null) {
                configuration.setId(dataSourceTaskletInstanceTasklet.getId());
            }
        }
        return configuration;
    }

    protected List<Field> getConfiguredFields(boolean advancedOnly, boolean buildComposite) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (FieldItem fieldItem : this.getFieldItems()) {
            FieldDescriptor fieldDescriptor = fieldItem.getFieldDescriptor();
            if (fieldDescriptor == null) continue;
            Field field = this.buildField(fieldItem);
            if (!buildComposite && !fieldItem.isOverridesParent()) continue;
            if (advancedOnly) {
                if (!fieldItem.isAdvanced()) continue;
                fields.add(field);
                continue;
            }
            fields.add(field);
        }
        return fields;
    }

    protected Field buildField(FieldItem fieldItem) {
        FieldDescriptor fieldDesc = fieldItem.getFieldDescriptor();
        Object field = fieldDesc instanceof HashedTextFieldDescriptor ? new HashedField(fieldDesc.getName(), fieldItem.getHashValue(), fieldItem.getValue()) : new Field(fieldDesc.getName(), fieldDesc.getLabel(), fieldItem.getValue());
        return field;
    }

    protected void buildFieldAndTableItemsLists(PluginDescriptor pluginDescriptor, Configuration configuration, Configuration revertToConfig, ConfigOverrideMetadata overrideData, boolean hasPluginParent) {
        GuiConfigDescriptorBuilder guiDescriptorBuilder = pluginDescriptor.getGuiConfigDescriptorBuilder();
        GuiConfigDescriptor guiConfigDescriptor = configuration == null ? guiDescriptorBuilder.buildNewGuiDescriptor() : guiDescriptorBuilder.buildConfiguredGuiDescriptor(configuration);
        this.buildFieldAndTableItemsLists(guiConfigDescriptor, (FieldList)configuration, (FieldList)revertToConfig, overrideData, hasPluginParent);
    }

    protected void buildFieldAndTableItemsLists(GuiConfigDescriptor guiDescriptor, FieldList fieldList, FieldList revertToFieldList, ConfigOverrideMetadata overrideData, boolean hasPluginParent) {
        this.editTableIndex = -18783;
        this.editRowIndex = -18783;
        this.showAdvancedFields = false;
        this.hasAdvancedFields = false;
        this.configurationValidatorChain = guiDescriptor.getValidationChain();
        this.configurationListenerChain = guiDescriptor.getListenerChain();
        this.preRenderCallbackChain = guiDescriptor.getPreRenderCallbackChain();
        this.setMainDesc(guiDescriptor.getDescription());
        this.buildFields(guiDescriptor, fieldList, revertToFieldList, overrideData, hasPluginParent);
        if (fieldList == null || fieldList instanceof Configuration) {
            Configuration configuration = (Configuration)fieldList;
            Configuration revertToConfig = revertToFieldList instanceof Configuration ? (Configuration)revertToFieldList : null;
            this.buildAdvancedFields(guiDescriptor, configuration, revertToConfig, overrideData, hasPluginParent);
            this.buildSummaryPageFields(guiDescriptor, configuration, revertToConfig, overrideData, hasPluginParent);
            this.buildTables(guiDescriptor.getTables(), configuration, revertToConfig, overrideData, hasPluginParent);
        }
        this.toggleMetaButtons(guiDescriptor);
        this.onPrePageRender();
    }

    protected void buildFields(GuiConfigDescriptor guiConfigDescriptor, FieldList configuration, FieldList revertToFieldList, ConfigOverrideMetadata overrideData, boolean hasPluginParent) {
        this.buildFields(guiConfigDescriptor.getFields(), configuration, revertToFieldList, overrideData, hasPluginParent);
    }

    protected void buildFields(List<FieldDescriptor> fields, FieldList configuration, FieldList revertToFieldList, ConfigOverrideMetadata overrideData, boolean hasPluginParent) {
        this.fieldItems = new ArrayList<FieldItem>();
        for (FieldDescriptor fieldDesc : fields) {
            FieldItem fieldItem = new FieldItem(fieldDesc);
            fieldItem.setAdvanced(false);
            if (configuration != null) {
                this.setFieldValue(revertToFieldList, overrideData, hasPluginParent, fieldDesc, fieldItem, configuration);
            } else if (fieldDesc.getDefaultValue() != null) {
                fieldItem.setValue(fieldDesc.getDefaultValue());
            }
            this.fieldItems.add(fieldItem);
        }
    }

    private void setFieldValue(FieldList revertToFieldList, ConfigOverrideMetadata overrideData, boolean hasPluginParent, FieldDescriptor fieldDesc, FieldItem fieldItem, FieldList configuration) {
        String fieldName = fieldDesc.getName();
        String fieldValue = configuration.getFieldValue(fieldName);
        String legacyDefaultValue = fieldDesc.getDefaultForLegacyConfig();
        Field field = configuration.getField(fieldName);
        boolean isNewDefaultForLegacyField = this.isNewFieldWithDefaultForLegacy(fieldDesc, field);
        boolean isNewDefaultField = this.isNewFieldWithDefault(fieldDesc, field);
        if (fieldDesc instanceof HashedTextFieldDescriptor) {
            fieldItem.setHashValue(fieldValue);
        } else if (isNewDefaultForLegacyField) {
            fieldItem.setValue(legacyDefaultValue);
        } else if (isNewDefaultField) {
            fieldItem.setValue(fieldDesc.getDefaultValue());
        } else {
            fieldItem.setValue(fieldValue);
        }
        if (hasPluginParent) {
            boolean overridden = fieldItem.isAdvanced() ? overrideData.isAdvancedFieldOverridden(fieldName) : overrideData.isFieldOverridden(fieldName);
            fieldItem.setRawOverridesParent(overridden);
            if (isNewDefaultForLegacyField) {
                fieldItem.setInheritedValue(legacyDefaultValue);
            } else if (isNewDefaultField) {
                fieldItem.setInheritedValue(fieldDesc.getDefaultValue());
            } else {
                fieldItem.setInheritedValue(revertToFieldList.getFieldValue(fieldName));
            }
        }
    }

    private boolean isNewFieldWithDefaultForLegacy(FieldDescriptor fieldDesc, Field field) {
        return field == null && fieldDesc != null && !StringUtils.isEmpty((String)fieldDesc.getDefaultForLegacyConfig());
    }

    private boolean isNewFieldWithDefault(FieldDescriptor fieldDesc, Field field) {
        return field == null && fieldDesc != null && !StringUtils.isEmpty((String)fieldDesc.getDefaultValue());
    }

    protected void buildAdvancedFields(GuiConfigDescriptor guiDescriptor, Configuration configuration, Configuration revertToConfig, ConfigOverrideMetadata overrideData, boolean hasPluginParent) {
        for (FieldDescriptor fieldDesc : guiDescriptor.getAdvancedFields()) {
            this.hasAdvancedFields = true;
            FieldItem fieldItem = new FieldItem(fieldDesc);
            fieldItem.setAdvanced(true);
            if (configuration != null) {
                FieldList revertToFieldList = revertToConfig != null ? revertToConfig.getAdvancedFields() : null;
                this.setFieldValue(revertToFieldList, overrideData, hasPluginParent, fieldDesc, fieldItem, configuration.getAdvancedFields());
            } else if (fieldDesc.getDefaultValue() != null) {
                fieldItem.setValue(fieldDesc.getDefaultValue());
            }
            this.fieldItems.add(fieldItem);
        }
    }

    protected void buildSummaryPageFields(GuiConfigDescriptor guiDescriptor, Configuration configuration, Configuration revertToConfig, ConfigOverrideMetadata overrideData, boolean hasPluginParent) {
        this.summaryFieldItems = guiDescriptor.getSummaryDescriptors();
    }

    protected void buildTables(List<TableDescriptor> tableDescriptors, Configuration configuration, Configuration revertToConfig, ConfigOverrideMetadata overrideData, boolean hasPluginParent) {
        this.tableItems = new ArrayList<TableItem>();
        for (TableDescriptor tableDesc : tableDescriptors) {
            String tableName = tableDesc.getName();
            TableItem tableItem = new TableItem(tableDesc);
            if (configuration != null) {
                Table table = configuration.getTable(tableName);
                if (table != null) {
                    for (Row row : table.getRows()) {
                        RowItem rowItem = this.addNewRowItem(tableItem, false);
                        rowItem.setDefault(row.isDefaultRow());
                        for (FieldItem fieldItem : rowItem.getRowFields()) {
                            FieldDescriptor fieldDesc = fieldItem.getFieldDescriptor();
                            String fieldValue = row.getFieldValue(fieldDesc.getName());
                            if (fieldValue == null) {
                                if (fieldDesc.getDefaultForLegacyConfig() != null) {
                                    fieldValue = fieldDesc.getDefaultForLegacyConfig();
                                } else if (fieldDesc.getDefaultValue() != null) {
                                    fieldValue = fieldDesc.getDefaultValue();
                                }
                            }
                            if (fieldDesc instanceof HashedTextFieldDescriptor) {
                                HashedField hashedField = (HashedField)row.getField(fieldDesc.getName());
                                if (StringUtils.isNotEmpty((String)hashedField.getPlainTextValue())) {
                                    fieldValue = HashedPassword.fromClearText((String)hashedField.getPlainTextValue()).toEncodedText();
                                }
                                fieldItem.setHashValue(fieldValue);
                                continue;
                            }
                            fieldItem.setValue(fieldValue);
                        }
                    }
                }
                if (hasPluginParent) {
                    tableItem.setOverridesParent(overrideData.isTableOverridden(tableName));
                    Table revertToTable = revertToConfig.getTable(tableName);
                    if (revertToTable != null) {
                        for (Row row : revertToTable.getRows()) {
                            RowItem rowItem = new RowItem();
                            for (FieldDescriptor fieldDesc : tableItem.getTableDescriptor().getRowFields()) {
                                FieldItem fieldItem = new FieldItem(fieldDesc);
                                rowItem.getRowFields().add(fieldItem);
                                String fieldValue = row.getFieldValue(fieldItem.getFieldDescriptor().getName());
                                if (fieldDesc instanceof HashedTextFieldDescriptor) {
                                    fieldItem.setHashValue(fieldValue);
                                    continue;
                                }
                                fieldItem.setValue(fieldValue);
                            }
                            tableItem.getInheritedRows().add(rowItem);
                        }
                    }
                }
            }
            this.tableItems.add(tableItem);
        }
    }

    public RowItem addNewRowItem(TableItem tableItem, boolean setDefaultValueForFields) {
        RowItem rowItem = new RowItem();
        tableItem.getRows().add(rowItem);
        if (tableItem.getSize() == 1 && tableItem.getTableDescriptor().getRequireDefaultRow()) {
            this.setDefaultRow(tableItem, 0);
        }
        for (FieldDescriptor fieldDesc : tableItem.getTableDescriptor().getRowFields()) {
            FieldItem fieldItem = new FieldItem(fieldDesc);
            rowItem.getRowFields().add(fieldItem);
            if (fieldDesc.getDefaultValue() == null || !setDefaultValueForFields) continue;
            fieldItem.setValue(fieldDesc.getDefaultValue());
        }
        return rowItem;
    }

    public List<FieldItem> getFieldItems() {
        return this.fieldItems;
    }

    public List<TableItem> getTableItems() {
        return this.tableItems;
    }

    public void setMainDesc(String desc) {
        this.mainDesc = desc;
    }

    public String getMainDesc() {
        return this.mainDesc;
    }

    public List<RowItem> getRowsByTableIndex(int tableIndex) {
        List<TableItem> tableItems = this.getTableItems();
        TableItem tableItem = tableItems.get(tableIndex);
        return tableItem.getRows();
    }

    public void deleteRow(int tableIndex, int rowIndex, PFValidationDelegate vd) {
        List<RowItem> rows = this.getRowsByTableIndex(tableIndex);
        RowItem deleteRowItem = rows.get(rowIndex);
        if (this.isDeletingDefault(this.tableItems.get(tableIndex), deleteRowItem)) {
            String errMsg = ApiMessages.getMessage((ApiMessageKey)ApiMessageKey.config_adapter_cannot_delete_default);
            vd.setFormComponent(null);
            vd.record(errMsg, ValidationConstraint.CONSISTENCY);
        } else {
            deleteRowItem.setDeleted(true);
            deleteRowItem.setDefault(false);
        }
    }

    public void realDeleteRow(int tableIndex, int rowIndex) {
        List<RowItem> rows = this.getRowsByTableIndex(tableIndex);
        rows.remove(rowIndex);
    }

    public void undeleteRow(int tableIndex, int rowIndex, ValidationDelegate vd) {
        List<RowItem> rows = this.getRowsByTableIndex(tableIndex);
        RowItem rowToUndelete = rows.get(rowIndex);
        rowToUndelete.setDeleted(false);
        List<String> errMsgs = this.validateRow(tableIndex, rowIndex);
        if (errMsgs != null && !errMsgs.isEmpty()) {
            for (String errMsg : errMsgs) {
                vd.setFormComponent(null);
                vd.record(errMsg, ValidationConstraint.CONSISTENCY);
            }
            rowToUndelete.setDeleted(true);
        }
    }

    public void moveRowUp(int tableIndex, int rowIndex) {
        List<RowItem> rows = this.getRowsByTableIndex(tableIndex);
        if (rowIndex - 1 >= 0) {
            Collections.swap(rows, rowIndex, rowIndex - 1);
        }
    }

    public void moveRowDown(int tableIndex, int rowIndex) {
        List<RowItem> rows = this.getRowsByTableIndex(tableIndex);
        if (rowIndex + 1 < rows.size()) {
            Collections.swap(rows, rowIndex, rowIndex + 1);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.isRowEditMode()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Finish_editing"), ValidationConstraint.CONSISTENCY);
        } else {
            List<String> errorMessages = this.validateFieldItems();
            if (errorMessages.isEmpty() && this.configurationValidatorChain != null) {
                PluginConfigConsistencyValidator consistencyValidator = new PluginConfigConsistencyValidator(this.configurationValidatorChain, this.buildConfiguration(), "");
                consistencyValidator.validate();
                List<String> consistencyErrors = this.getErrorMsgs(consistencyValidator.getErrors());
                errorMessages.addAll(consistencyErrors);
            }
            for (String errMsg : errorMessages) {
                delegate.setFormComponent(null);
                delegate.record(errMsg, ValidationConstraint.CONSISTENCY);
            }
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if ((this.tableItems == null || this.tableItems.isEmpty()) && (this.fieldItems == null || this.fieldItems.isEmpty())) {
            summaryList.add(new SummaryInfo(this.getMessage("Adapter"), this.getMessage("No_configurable_fields"), this));
        } else {
            if (this.tableItems != null && !this.tableItems.isEmpty()) {
                for (TableItem tableItem : this.tableItems) {
                    for (RowItem rowItem : tableItem.getRows()) {
                        StringBuilder rowValue = new StringBuilder();
                        ArrayList<String> displayList = new ArrayList<String>();
                        if (rowItem.isDeleted()) continue;
                        for (FieldItem fieldItem : rowItem.getRowFields()) {
                            String displayItem = fieldItem.toString();
                            if (fieldItem.isHidden()) continue;
                            if (!StringUtils.isBlank((String)displayItem)) {
                                if ("None Selected".equals(displayItem)) {
                                    displayList.add("{none selected}");
                                    continue;
                                }
                                displayList.add(displayItem);
                                continue;
                            }
                            displayList.add("{no value}");
                        }
                        for (int i = 0; i < displayList.size(); ++i) {
                            rowValue.append((String)displayList.get(i));
                            if (i >= displayList.size() - 1) continue;
                            rowValue.append(", ");
                        }
                        summaryList.add(new SummaryInfo(tableItem.getTableDescriptor().getLabel(), rowValue.toString(), this));
                    }
                }
            }
            if (this.fieldItems != null && !this.fieldItems.isEmpty()) {
                for (FieldItem fieldItem : this.fieldItems) {
                    if (fieldItem.isEncrypted() || fieldItem.getFieldDescriptor() == null || fieldItem.isHidden()) continue;
                    summaryList.add(new SummaryInfo(fieldItem.getFieldDescriptor().getLabel(), fieldItem.toString(), this));
                }
            }
        }
    }

    protected List<String> validateFieldItems() {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (FieldItem fieldItem : this.fieldItems) {
            Configuration existingConfig;
            FieldDescriptor fieldDescriptor = fieldItem.getFieldDescriptor();
            if (fieldDescriptor == null) continue;
            boolean success = true;
            Field field = this.buildField(fieldItem);
            if (fieldDescriptor instanceof TextAreaFieldDescriptor && ((TextAreaFieldDescriptor)fieldDescriptor).isExpression() && fieldItem.getValue() != null && !this.getCurrentUser().isExpressionAdmin() && (existingConfig = this.getExistingPluginInstance()) != null && !fieldItem.getValue().equals(existingConfig.getFieldValue(fieldDescriptor.getName()))) {
                errorMessages.add(ApiMessages.getMessage((ApiMessageKey)ApiMessageKey.expression_admin_role_required));
                success = false;
            }
            if (!success) continue;
            PluginFieldValidator fieldValidator = new PluginFieldValidator(fieldDescriptor, field, "", null);
            success = fieldValidator.validate();
            errorMessages.addAll(this.getErrorMsgs(fieldValidator.getErrors()));
            if (success || !fieldItem.isAdvanced()) continue;
            this.showAdvancedFields = true;
        }
        return errorMessages;
    }

    private Configuration getExistingPluginInstance() {
        Configuration existingConfig = null;
        Tasklet pluginTasklet = this.getParent();
        if (pluginTasklet instanceof PluginInstanceTasklet) {
            String pluginId = ((PluginInstanceTasklet)pluginTasklet).getPluginId();
            ConfigurablePluginInstance existingConfigInstance = ((PluginInstanceTasklet)pluginTasklet).getPluginManager().getInstance(pluginId);
            if (existingConfigInstance != null) {
                existingConfig = existingConfigInstance.getConfiguration();
            }
        }
        return existingConfig;
    }

    public boolean isShowAdvancedFields() {
        return this.showAdvancedFields;
    }

    public void setShowAdvancedFields(boolean showAdvancedFields) {
        this.showAdvancedFields = showAdvancedFields;
    }

    public boolean isHasAdvancedFields() {
        return this.hasAdvancedFields;
    }

    public String getToggleAdvancedButtonText() {
        return (this.showAdvancedFields ? "Hide" : "Show") + " Advanced Fields";
    }

    public boolean isTableRowToEdit(int tableIndex, int rowIndex) {
        return tableIndex == this.editTableIndex && rowIndex == this.editRowIndex;
    }

    public boolean isRowEditMode() {
        return this.editTableIndex != -18783 && this.editRowIndex != -18783;
    }

    public void setTableRowToEdit(int tableIndex, int rowIndex) {
        this.editTableIndex = tableIndex;
        this.editRowIndex = rowIndex;
        if (this.isRowEditMode()) {
            RowItem currentRowItem = this.getCurrentRowItem();
            currentRowItem.backup();
        }
    }

    public void setDefaultRow(int tableIndex, int rowIndex) {
        List<TableItem> tableItems = this.getTableItems();
        TableItem tableItem = tableItems.get(tableIndex);
        this.setDefaultRow(tableItem, rowIndex);
    }

    private void setDefaultRow(TableItem tableItem, int rowIndex) {
        if (tableItem.getTableDescriptor().getRequireDefaultRow()) {
            tableItem.clearDefaults();
            List<RowItem> rows = tableItem.getRows();
            rows.get(rowIndex).setDefault(true);
        }
    }

    public void cancelRowUpdate() {
        RowItem rowItem = this.getCurrentRowItem();
        if (rowItem.isNewRow()) {
            this.realDeleteRow(this.editTableIndex, this.editRowIndex);
        } else {
            rowItem.revert();
        }
        this.resetTableRowToEdit();
    }

    protected RowItem getCurrentRowItem() {
        List<RowItem> rowsByTableIndex = this.getRowsByTableIndex(this.editTableIndex);
        return rowsByTableIndex.get(this.editRowIndex);
    }

    private List<String> validateRow(int tableIndex, int rowIndex) {
        TableItem tableItem = this.getTableItems().get(tableIndex);
        RowItem rowItem = tableItem.getRows().get(rowIndex);
        ArrayList<Field> fields = new ArrayList<Field>();
        for (FieldItem fieldItem : rowItem.getRowFields()) {
            Field field = this.buildField(fieldItem);
            fields.add(field);
        }
        FieldList fieldsInRow = new FieldList(fields){
            private static final long serialVersionUID = 20050515L;
        };
        Configuration configuration = this.buildConfiguration();
        String tableName = tableItem.getTableDescriptor().getName();
        PluginTableValidator tableValidator = new PluginTableValidator(configuration.getTable(tableName), "", tableItem.getTableDescriptor());
        tableValidator.validate();
        PluginTableRowValidator rowValidator = new PluginTableRowValidator(fieldsInRow, "", tableItem.getTableDescriptor(), configuration, null);
        rowValidator.validate();
        List errors = rowValidator.getErrors();
        errors.addAll(tableValidator.getErrors());
        return this.getErrorMsgs(errors);
    }

    private boolean isDeletingDefault(TableItem tableItem, RowItem rowItem) {
        return tableItem != null && tableItem.getTableDescriptor().getRequireDefaultRow() && rowItem.isDefault();
    }

    public void updateRow() {
        List<String> errMsgs = this.validateRow(this.editTableIndex, this.editRowIndex);
        if (errMsgs.isEmpty()) {
            TableItem tableItem = this.getTableItems().get(this.editTableIndex);
            RowItem rowItem = tableItem.getRows().get(this.editRowIndex);
            rowItem.setNewRow(false);
            this.resetTableRowToEdit();
        } else {
            for (String errMsg : errMsgs) {
                this.delegate.setFormComponent(null);
                this.delegate.record(errMsg, ValidationConstraint.CONSISTENCY);
            }
        }
    }

    protected void resetTableRowToEdit() {
        this.setTableRowToEdit(-18783, -18783);
    }

    public void clearSelectionFieldValue(String fieldName) {
        for (FieldItem item : this.fieldItems) {
            if (!fieldName.equals(item.getFieldDescriptor().getName())) continue;
            item.setValue(null);
            break;
        }
    }

    public void clearFieldItemValue(String fieldName) {
        int index = 0;
        for (FieldItem item : this.fieldItems) {
            if (fieldName.equals(item.getFieldDescriptor().getName())) {
                FieldItem fieldWithoutValue = new FieldItem(item.getFieldDescriptor());
                fieldWithoutValue.setAdvanced(item.isAdvanced());
                this.fieldItems.set(index, fieldWithoutValue);
                break;
            }
            ++index;
        }
    }

    public void clearTableFieldItemValue(int tableIndex, int rowIndex, String tableFieldName) {
        List<RowItem> rows = this.getRowsByTableIndex(tableIndex);
        List<FieldItem> tableFieldItems = rows.get(rowIndex).getRowFields();
        int index = 0;
        for (FieldItem tableFieldItem : tableFieldItems) {
            if (tableFieldName.equals(tableFieldItem.getFieldDescriptor().getName())) {
                FieldItem fieldWithoutValue = new FieldItem(tableFieldItem.getFieldDescriptor());
                fieldWithoutValue.setAdvanced(tableFieldItem.isAdvanced());
                tableFieldItems.set(index, fieldWithoutValue);
                break;
            }
            ++index;
        }
    }

    public String getCssClass() {
        return this.cssClass(this.isRowEditMode());
    }

    public String cssClass(int tableIndex) {
        return this.cssClass(this.isRowEditMode() && tableIndex != this.editTableIndex);
    }

    public String cssClass(int tableIndex, int rowIndex) {
        return this.cssClass(!this.isTableRowToEdit(tableIndex, rowIndex));
    }

    public String cssClass(boolean disabled) {
        return disabled ? "disabled" : "plain";
    }

    public boolean isShowDatastoreButton() {
        return false;
    }

    public boolean isShowPasswordCredentialValidatorButton() {
        return false;
    }

    public boolean isShowTrustedCAsButton() {
        return false;
    }

    public boolean isShowDsigButton() {
        return false;
    }

    public boolean isShowCryptoCertButton() {
        return false;
    }

    public boolean isShowKerberosRealmButton() {
        return false;
    }

    public boolean isShowSmsProviderSettingsButton() {
        return false;
    }

    public boolean isShowEmailServerSettingsButton() {
        return false;
    }

    public boolean isShowLocalIdentityButton() {
        return false;
    }

    public boolean isShowNotificationSendersButton() {
        return false;
    }

    public boolean isShowAccessTokenManagerButton() {
        return false;
    }

    public boolean isShowCaptchaProvidersButton() {
        return false;
    }

    public boolean isShowPolicyContractSettingsButton() {
        return false;
    }

    public boolean isShowExtendedPropertiesButton() {
        return false;
    }

    public boolean isShowManageSessionsButton() {
        return false;
    }

    public boolean isShowSourceName() {
        return false;
    }

    public boolean isShowMaskLogValues() {
        return false;
    }

    public boolean isShowManageSecretManagersButton() {
        return false;
    }

    public boolean isShowManageSSLClientKeysAndCertsButton() {
        return false;
    }

    public boolean isDatasourceFilterState() {
        return false;
    }

    public boolean isTestingDatasourceLookup() {
        return false;
    }

    public void onTestLookup(IRequestCycle cycle) {
    }

    public boolean performSaveEvent(ValidationDelegate delegate) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (this.configurationListenerChain != null && this.configurationListenerChain.size() > 0) {
            for (ConfigurationListener configurationListener : this.configurationListenerChain) {
                try {
                    configurationListener.onSave(this.buildConfiguration());
                }
                catch (EventException e) {
                    errorMessages.addAll(e.getErrorMessages());
                    break;
                }
                catch (Exception e) {
                    String msg = "Unexpected exception thrown from " + configurationListener;
                    errorMessages.add(msg);
                    this.log.error((Object)msg, (Throwable)e);
                    break;
                }
            }
        }
        return this.recordErrors(delegate, errorMessages);
    }

    private boolean recordErrors(ValidationDelegate delegate, List<String> errorMessages) {
        boolean success = true;
        for (String errMsg : errorMessages) {
            success = false;
            delegate.setFormComponent(null);
            delegate.record(errMsg, ValidationConstraint.REQUIRED);
        }
        return success;
    }

    public boolean performDeleteEvent(ValidationDelegate delegate) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (this.configurationListenerChain != null && this.configurationListenerChain.size() > 0) {
            for (ConfigurationListener configurationListener : this.configurationListenerChain) {
                try {
                    configurationListener.onDelete(this.buildConfiguration());
                }
                catch (EventException e) {
                    errorMessages.addAll(e.getErrorMessages());
                    break;
                }
                catch (Exception e) {
                    String msg = "Unexpected exception thrown from " + configurationListener;
                    errorMessages.add(msg);
                    this.log.error((Object)msg, (Throwable)e);
                    break;
                }
            }
        }
        return this.recordErrors(delegate, errorMessages);
    }

    void toggleMetaButtons(GuiConfigDescriptor guiConfigDescriptor) {
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        super.formListener(cycle);
        int tableIndex = 0;
        for (TableItem table : this.getTableItems()) {
            if (!table.isOverridesParent()) {
                table.revert();
                if (tableIndex == this.editTableIndex) {
                    this.resetTableRowToEdit();
                }
            }
            ++tableIndex;
        }
        this.onPrePageRender();
    }

    public void onPrePageRender() {
        Configuration configuration = this.buildConfiguration();
        LinkedList<FieldDescriptor> fieldDescriptors = new LinkedList<FieldDescriptor>();
        LinkedList<FieldDescriptor> advancedFieldDescriptors = new LinkedList<FieldDescriptor>();
        LinkedList<TableDescriptor> tableDescriptors = new LinkedList<TableDescriptor>();
        for (FieldItem fieldItem : this.fieldItems) {
            FieldDescriptor fieldDescriptor = fieldItem.getFieldDescriptor();
            if (fieldItem.isAdvanced()) {
                advancedFieldDescriptors.add(fieldDescriptor);
                continue;
            }
            fieldDescriptors.add(fieldDescriptor);
        }
        for (TableItem tableItem : this.tableItems) {
            tableDescriptors.add(tableItem.getTableDescriptor());
        }
        PluginConfigValidator.executePreRenderCallbacks(this.preRenderCallbackChain, fieldDescriptors, advancedFieldDescriptors, tableDescriptors, (Configuration)configuration);
        LinkedList<FieldItem> newFieldItemsList = new LinkedList<FieldItem>();
        this.reconcileFieldList(fieldDescriptors, newFieldItemsList, false);
        this.reconcileFieldList(advancedFieldDescriptors, newFieldItemsList, true);
        for (FieldItem fieldItem : this.fieldItems) {
            this.priorFields.put(fieldItem.getFieldDescriptor().getName(), fieldItem);
        }
        this.fieldItems = newFieldItemsList;
        for (TableItem tableItem : this.tableItems) {
            this.priorTables.put(tableItem.getTableDescriptor().getName(), tableItem);
        }
        this.tableItems = this.reconcileTableList(tableDescriptors);
        for (TableItem tableItem : this.tableItems) {
            for (RowItem row : tableItem.getRows()) {
                row.reconcile(tableItem.getTableDescriptor().getRowFields());
            }
        }
    }

    private List<TableItem> reconcileTableList(List<TableDescriptor> tableDescriptors) {
        LinkedList<TableItem> newTableItemsList = new LinkedList<TableItem>();
        for (TableDescriptor tableDescriptor : tableDescriptors) {
            String name = tableDescriptor.getName();
            TableItem tableItem = this.findTableByName(name);
            if (tableItem == null && (tableItem = this.priorTables.remove(name)) == null) {
                tableItem = new TableItem(tableDescriptor);
            }
            newTableItemsList.add(tableItem);
        }
        return newTableItemsList;
    }

    private void reconcileFieldList(List<FieldDescriptor> fieldDescriptors, List<FieldItem> newFieldItemsList, boolean isAdvanced) {
        for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
            String name = fieldDescriptor.getName();
            FieldItem fieldItem = this.findFieldByName(name);
            if (fieldItem == null && (fieldItem = this.priorFields.remove(name)) == null) {
                fieldItem = new FieldItem(fieldDescriptor);
                fieldItem.setAdvanced(isAdvanced);
                if (fieldDescriptor.getDefaultValue() != null) {
                    fieldItem.setValue(fieldDescriptor.getDefaultValue());
                }
            }
            newFieldItemsList.add(fieldItem);
        }
    }

    FieldItem findFieldByName(String name) {
        Iterator<FieldItem> i = this.fieldItems.iterator();
        while (i.hasNext()) {
            FieldItem item = i.next();
            if (!name.equals(item.getFieldDescriptor().getName())) continue;
            i.remove();
            return item;
        }
        return null;
    }

    TableItem findTableByName(String name) {
        Iterator<TableItem> i = this.tableItems.iterator();
        while (i.hasNext()) {
            TableItem item = i.next();
            if (!name.equals(item.getTableDescriptor().getName())) continue;
            i.remove();
            return item;
        }
        return null;
    }

    public boolean hasParentInstance() {
        return false;
    }

    protected List<String> getErrorMsgs(List<ValidationError> errors) {
        ArrayList<String> result = new ArrayList<String>();
        for (ValidationError error : errors) {
            result.add(error.getMessage());
        }
        return result;
    }

    @Override
    public void doSummaryHeader(ArrayList<SummaryInfo> summaryHeader) {
        if (this.summaryFieldItems == null || this.summaryFieldItems.isEmpty()) {
            this.summaryFieldItems = new ArrayList<ReadOnlyDescriptor>();
        }
        Configuration newConfiguration = this.buildConfiguration();
        ArrayList<ReadOnlyDescriptor> copySummaryFields = new ArrayList<ReadOnlyDescriptor>(this.summaryFieldItems);
        for (PreRenderCallback callback : this.preRenderCallbackChain) {
            callback.summaryPageCallback(copySummaryFields, newConfiguration);
        }
        for (ReadOnlyDescriptor fieldItem : copySummaryFields) {
            String baseUrl = MgmtFactory.getLocalSettingsManager().getLocalSettings().getBaseUrl();
            SummaryInfo summaryInfo = new SummaryInfo(fieldItem.getName(), fieldItem.getDescription(), this);
            if (fieldItem instanceof LinkDescriptor) {
                HashMap<String, String> substitutionMap = new HashMap<String, String>();
                substitutionMap.put("pluginId", newConfiguration.getId());
                substitutionMap.put("baseUrl", baseUrl);
                String link = StringSubstituter.substituteValuesTolarateUnkownKey((String)((LinkDescriptor)fieldItem).getLink(), substitutionMap);
                summaryInfo.setLink(link);
            }
            summaryHeader.add(summaryInfo);
        }
    }
}

