/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.util.ConfigurationUtil;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.ConfigureAdapterState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.PluginInstanceApi;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.Set;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.internal.ConfigOverrideMetadata;
import org.sourceid.saml20.adapter.gui.CustomSourceFieldDescriptor;
import org.sourceid.saml20.adapter.gui.DsigKeypairFieldDescriptor;
import org.sourceid.saml20.adapter.gui.EncryptionCertificateFieldDescriptor;
import org.sourceid.saml20.adapter.gui.ExtendedPropertiesFileDescriptor;
import org.sourceid.saml20.adapter.gui.JdbcDatastoreFieldDescriptor;
import org.sourceid.saml20.adapter.gui.LdapDatastoreFieldDescriptor;
import org.sourceid.saml20.adapter.gui.NotificationSenderFieldDescriptor;
import org.sourceid.saml20.adapter.gui.PasswordCredentialValidatorFieldDescriptor;
import org.sourceid.saml20.adapter.gui.PolicyContractFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TrustedCAFieldDescriptor;
import org.sourceid.saml20.adapter.gui.kerberos.KerberosRealmFieldDescriptor;
import org.sourceid.saml20.adapter.gui.localidentity.LocalIdentityProfileFieldDescriptor;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class ConfigureAuthnAdapterState
extends ConfigureAdapterState {
    private static final long serialVersionUID = 20050515L;
    private ConfigurablePluginInstance instance;
    private PluginDescriptor descriptor;
    private boolean needDataStoreButton;
    private boolean needPasswordCredentialValidatorButton;
    private boolean needTrustedCAsButton;
    private boolean needDsigButton;
    private boolean needCryptoCertButton;
    private boolean needKerberosRealmButton;
    private boolean needSmsProviderSettingsButton;
    private boolean needEmailServerSettingsButton;
    private boolean isDisplayingForFirstTime = true;
    private String oldParentId;
    private boolean needLocalIdentityButton;
    private boolean needCaptchaSettingsButton;
    private boolean needManageSessionsButton;
    private boolean needNotificationSendersButton;
    private boolean needPolicyContractButton;
    private boolean needExtendedPropertyButton;

    public ConfigureAuthnAdapterState(IWizard owner) {
        super(owner);
        this.setMenuName("Instance Configuration");
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        this.onStateActivated();
        super.appendErrors(delegate, component, fastFail);
    }

    @Override
    public void onStateActivated() {
        PluginInstanceTasklet parentTasklet = this.findParent(PluginInstanceTasklet.class);
        if (parentTasklet != null) {
            boolean hasParent = this.hasParentInstance();
            String parentId = this.getParentInstanceId();
            boolean removingParent = !hasParent && this.oldParentId != null;
            boolean addingParent = hasParent && this.oldParentId == null;
            Configuration parentCompositeConfig = null;
            PluginManager<?, ?> pluginMgr = parentTasklet.getPluginManager();
            if (hasParent) {
                parentCompositeConfig = ConfigurationUtil.createAdminCompositeConfiguration((ConfigurablePluginInstance)pluginMgr.getInstance(parentId), pluginMgr);
            }
            if (this.descriptor == null || !parentTasklet.getSelectedDescriptor().equals((Object)this.descriptor) || removingParent || hasParent) {
                this.descriptor = parentTasklet.getSelectedDescriptor();
                Configuration compositeConfiguration = null;
                ConfigOverrideMetadata overrideData = null;
                if (removingParent) {
                    ConfigurablePluginInstance tmpInstance = pluginMgr.newInstance();
                    tmpInstance.setParentId(this.oldParentId);
                    this.save(tmpInstance);
                    compositeConfiguration = ConfigurationUtil.createAdminCompositeConfiguration((ConfigurablePluginInstance)tmpInstance, pluginMgr);
                } else if (addingParent) {
                    if (parentTasklet.isNewTasklet() && this.isDisplayingForFirstTime) {
                        compositeConfiguration = ConfigurationUtil.createAdminCompositeConfiguration((ConfigurablePluginInstance)pluginMgr.getInstance(parentId), pluginMgr);
                        overrideData = new ConfigOverrideMetadata();
                        this.isDisplayingForFirstTime = false;
                    } else {
                        ConfigurablePluginInstance tmpInstance = pluginMgr.newInstance();
                        tmpInstance.setParentId(parentId);
                        this.save(tmpInstance);
                        compositeConfiguration = ConfigurationUtil.createAdminCompositeConfiguration((ConfigurablePluginInstance)tmpInstance, pluginMgr);
                        overrideData = new ConfigOverrideMetadata(true);
                    }
                } else if (hasParent) {
                    ConfigurablePluginInstance tmpInstance = pluginMgr.newInstance();
                    tmpInstance.setParentId(parentId);
                    this.save(tmpInstance);
                    compositeConfiguration = ConfigurationUtil.createAdminCompositeConfiguration((ConfigurablePluginInstance)tmpInstance, pluginMgr);
                    overrideData = ConfigurationUtil.createConfigOverrideMetadata((Configuration)tmpInstance.getConfiguration(), (Configuration)compositeConfiguration, (GuiConfigDescriptor)tmpInstance.getGuiDescriptor());
                }
                this.oldParentId = parentId;
                this.buildFieldAndTableItemsLists(this.descriptor, compositeConfiguration, parentCompositeConfig, overrideData, hasParent);
            }
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.instance = (ConfigurablePluginInstance)dataFromDisk;
        if (this.instance != null) {
            this.populate();
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConfigurablePluginInstance instance = (ConfigurablePluginInstance)dataToDisk;
        Configuration configuration = this.buildConfiguration(false);
        instance.setConfiguration(configuration);
        return true;
    }

    @Override
    protected void populate() {
        if (this.instance != null) {
            this.descriptor = this.instance.getDescriptor();
            this.editRowIndex = -18783;
            this.editTableIndex = -18783;
            this.oldParentId = this.instance.getParentId();
            Configuration config = this.instance.getConfiguration();
            PluginInstanceApi parentTasklet = this.findParent(PluginInstanceApi.class);
            PluginManager<?, ?> pluginMgr = parentTasklet.getPluginManager();
            Configuration compositeConfig = ConfigurationUtil.createAdminCompositeConfiguration((ConfigurablePluginInstance)this.instance, pluginMgr);
            Configuration parentCompositeConfig = null;
            if (this.oldParentId != null) {
                parentCompositeConfig = ConfigurationUtil.createAdminCompositeConfiguration((ConfigurablePluginInstance)pluginMgr.getInstance(this.oldParentId), pluginMgr);
            }
            ConfigOverrideMetadata overrideData = ConfigurationUtil.createConfigOverrideMetadata((Configuration)config, (Configuration)compositeConfig, (GuiConfigDescriptor)this.instance.getGuiDescriptor());
            this.buildFieldAndTableItemsLists(this.descriptor, compositeConfig, parentCompositeConfig, overrideData, this.instance.getParentId() != null);
        }
    }

    @Override
    void toggleMetaButtons(GuiConfigDescriptor guiConfigDescriptor) {
        super.toggleMetaButtons(guiConfigDescriptor);
        Set fieldDescriptors = guiConfigDescriptor.getAllDescriptorTypesInUse();
        this.needPasswordCredentialValidatorButton = fieldDescriptors.contains(PasswordCredentialValidatorFieldDescriptor.class);
        this.needDataStoreButton = fieldDescriptors.contains(LdapDatastoreFieldDescriptor.class) || fieldDescriptors.contains(JdbcDatastoreFieldDescriptor.class) || fieldDescriptors.contains(CustomSourceFieldDescriptor.class);
        this.needTrustedCAsButton = fieldDescriptors.contains(TrustedCAFieldDescriptor.class);
        this.needDsigButton = fieldDescriptors.contains(DsigKeypairFieldDescriptor.class);
        this.needCryptoCertButton = fieldDescriptors.contains(EncryptionCertificateFieldDescriptor.class);
        this.needKerberosRealmButton = fieldDescriptors.contains(KerberosRealmFieldDescriptor.class);
        this.needSmsProviderSettingsButton = true;
        this.needEmailServerSettingsButton = true;
        this.needLocalIdentityButton = fieldDescriptors.contains(LocalIdentityProfileFieldDescriptor.class);
        this.needNotificationSendersButton = fieldDescriptors.contains(NotificationSenderFieldDescriptor.class);
        this.needCaptchaSettingsButton = true;
        this.needManageSessionsButton = this.descriptor.getType().equals("Session Authentication Selector");
        this.needPolicyContractButton = fieldDescriptors.contains(PolicyContractFieldDescriptor.class);
        this.needExtendedPropertyButton = fieldDescriptors.contains(ExtendedPropertiesFileDescriptor.class);
    }

    @Override
    public boolean isShowDatastoreButton() {
        return this.needDataStoreButton;
    }

    @Override
    public boolean isShowPasswordCredentialValidatorButton() {
        return this.needPasswordCredentialValidatorButton;
    }

    @Override
    public boolean isShowTrustedCAsButton() {
        return this.needTrustedCAsButton;
    }

    @Override
    public boolean isShowDsigButton() {
        return this.needDsigButton;
    }

    @Override
    public boolean isShowCryptoCertButton() {
        return this.needCryptoCertButton;
    }

    @Override
    public boolean isShowKerberosRealmButton() {
        return this.needKerberosRealmButton;
    }

    @Override
    public boolean isShowSmsProviderSettingsButton() {
        boolean isHtmlFormIdpAuthnAdapter = this.descriptor.getType().equals("HTML Form IdP Adapter");
        this.needSmsProviderSettingsButton = this.needPasswordCredentialValidatorButton && isHtmlFormIdpAuthnAdapter;
        return this.needSmsProviderSettingsButton;
    }

    @Override
    public boolean isShowEmailServerSettingsButton() {
        boolean isHtmlFormIdpAuthnAdapter = this.descriptor.getType().equals("HTML Form IdP Adapter");
        this.needEmailServerSettingsButton = this.needPasswordCredentialValidatorButton && isHtmlFormIdpAuthnAdapter;
        return this.needEmailServerSettingsButton;
    }

    @Override
    public boolean isShowLocalIdentityButton() {
        boolean isHtmlFormIdpAuthnAdapter = this.descriptor.getType().equals("HTML Form IdP Adapter");
        return this.needLocalIdentityButton && isHtmlFormIdpAuthnAdapter;
    }

    @Override
    public boolean isShowNotificationSendersButton() {
        return this.needNotificationSendersButton;
    }

    @Override
    public boolean isShowAccessTokenManagerButton() {
        return MgmtFactory.getAuthzServerManager().isEnableOAuth() && this.descriptor.getType().equals("OAuth Bearer Access Token Token Processor");
    }

    @Override
    public boolean isShowCaptchaProvidersButton() {
        boolean isHtmlFormIdpAuthnAdapter = this.descriptor.getType().equals("HTML Form IdP Adapter");
        boolean isIdFirstAdapter = this.descriptor.getType().equals("Identifier First Adapter");
        return this.needCaptchaSettingsButton && (isHtmlFormIdpAuthnAdapter || isIdFirstAdapter);
    }

    @Override
    public boolean isShowPolicyContractSettingsButton() {
        boolean isHtmlFormIdpAuthnAdapter = this.descriptor.getType().equals("HTML Form IdP Adapter");
        return this.needPolicyContractButton && isHtmlFormIdpAuthnAdapter;
    }

    @Override
    public boolean isShowExtendedPropertiesButton() {
        boolean isExtPropSelector = "Extended Property Authentication Selector".equals(this.descriptor.getType());
        return this.needExtendedPropertyButton && isExtPropSelector;
    }

    @Override
    public boolean isShowManageSessionsButton() {
        return this.needManageSessionsButton;
    }

    public GuiConfigDescriptor getGuiConfigDescriptor() {
        if (this.instance == null || this.instance.getConfiguration() == null) {
            return this.descriptor.getGuiConfigDescriptorBuilder().buildNewGuiDescriptor();
        }
        return this.descriptor.getGuiConfigDescriptorBuilder().buildConfiguredGuiDescriptor(this.instance.getConfiguration());
    }

    public String getParentInstanceId() {
        Tasklet t = this.getParent();
        if (t instanceof PluginInstanceApi) {
            PluginInstanceApi parentTasklet = (PluginInstanceApi)((Object)t);
            return parentTasklet.getParentPluginInstanceId();
        }
        return null;
    }

    @Override
    public boolean hasParentInstance() {
        return this.getParentInstanceId() != null;
    }
}

